/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.util;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.eclipse.sirius.common.tools.internal.util.FastInverseCrossReferencesList;

public class SiriusCrossReferenceAdapterImpl
extends ECrossReferenceAdapter
implements SiriusCrossReferenceAdapter {
    protected boolean isSettingTargets;
    private boolean resolveProxyEnabled = true;
    private Collection<EReference> featureToBeCrossReferencedWhiteList = new HashSet<EReference>();

    @Override
    public void disableResolveProxy() {
        this.resolveProxyEnabled = false;
    }

    @Override
    public void enableResolveProxy() {
        this.resolveProxyEnabled = true;
    }

    protected boolean resolve() {
        if (this.resolveProxyEnabled) {
            return super.resolve();
        }
        return false;
    }

    protected ECrossReferenceAdapter.InverseCrossReferencer createInverseCrossReferencer() {
        return new ECrossReferenceAdapter.InverseCrossReferencer(this){
            private static final long serialVersionUID = 1L;

            protected Collection<EStructuralFeature.Setting> newCollection() {
                return new FastInverseCrossReferencesList(() -> !SiriusCrossReferenceAdapterImpl.this.settingTargets || SiriusCrossReferenceAdapterImpl.this.resolve());
            }
        };
    }

    protected void addAdapter(Notifier notifier) {
        EList eAdapters = notifier.eAdapters();
        if (!eAdapters.contains(this)) {
            boolean oldSettingTargets = this.isSettingTargets;
            try {
                this.isSettingTargets = true;
                eAdapters.add(this);
            }
            finally {
                this.isSettingTargets = oldSettingTargets;
            }
        }
    }

    public void setFeatureToBeCrossReferencedWhiteList(Collection<EReference> featureToBeCrossReferencedWhiteList) {
        this.featureToBeCrossReferencedWhiteList = featureToBeCrossReferencedWhiteList;
    }

    protected boolean isIncluded(EReference eReference) {
        return eReference.getEOpposite() == null && !eReference.isDerived() || this.featureToBeCrossReferencedWhiteList.contains(eReference);
    }
}

