/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.util;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import org.eclipse.sirius.diagram.sequence.Messages;

public class Range {
    private static final Range EMPTY_RANGE = new Range(0, 0);
    private final int lower;
    private final int upper;

    public Range(int lower, int upper) {
        Preconditions.checkArgument((lower <= upper ? 1 : 0) != 0, (Object)Messages.Range_wrongArgument);
        this.lower = lower;
        this.upper = upper;
    }

    public static Range emptyRange() {
        return EMPTY_RANGE;
    }

    public boolean isEmpty() {
        return this == EMPTY_RANGE;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj instanceof Range) {
            Range that = (Range)obj;
            result = this.isEmpty() || that.isEmpty() ? false : this.lower == that.lower && this.upper == that.upper;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        long temp = this.lower;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.upper;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public int getLowerBound() {
        return this.isEmpty() ? Integer.MIN_VALUE : this.lower;
    }

    public int getUpperBound() {
        return this.isEmpty() ? Integer.MIN_VALUE : this.upper;
    }

    public int clamp(int value) {
        int result = this.isEmpty() ? Integer.MIN_VALUE : (value < this.lower ? this.lower : (this.upper < value ? this.upper : value));
        return result;
    }

    public boolean includes(int value) {
        return this.includes(value, false, false);
    }

    public boolean includes(int value, boolean excludeLowerBounds, boolean excludeUpperBounds) {
        boolean result = false;
        if (!this.isEmpty()) {
            if (excludeLowerBounds) {
                result = this.lower < value;
            } else {
                boolean bl = result = this.lower <= value;
            }
            result = excludeUpperBounds ? result && value < this.upper : result && value <= this.upper;
        }
        return result;
    }

    public int width() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.upper - this.lower;
    }

    public int middleValue() {
        if (this.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        return this.lower + this.width() / 2;
    }

    public Range union(Range other) {
        Range result = this.isEmpty() ? other : (other.isEmpty() ? this : new Range(Math.min(this.lower, other.lower), Math.max(this.upper, other.upper)));
        return result;
    }

    public Range intersection(Range other) {
        int u;
        int l;
        Range result = this.isEmpty() || other.isEmpty() ? Range.emptyRange() : ((l = Math.max(this.lower, other.lower)) <= (u = Math.min(this.upper, other.upper)) ? new Range(l, u) : Range.emptyRange());
        return result;
    }

    public boolean intersects(Range other) {
        return !this.intersection(other).isEmpty();
    }

    public boolean includes(Range other) {
        return this.intersection(other).equals(other);
    }

    public boolean includesOneBoundOnly(Range other) {
        return this.includes(other.getLowerBound()) && !this.includes(other.getUpperBound()) || !this.includes(other.getLowerBound()) && this.includes(other.getUpperBound());
    }

    public boolean includesAtLeastOneBound(Range other) {
        return this.includes(other) || this.includesOneBoundOnly(other);
    }

    public Range shifted(int distance) {
        if (this.isEmpty()) {
            return EMPTY_RANGE;
        }
        return new Range(this.lower + distance, this.upper + distance);
    }

    public Range grown(int distance) {
        Preconditions.checkArgument((distance >= 0 ? 1 : 0) != 0);
        if (this.isEmpty()) {
            return EMPTY_RANGE;
        }
        return new Range(this.lower - distance, this.upper + distance);
    }

    public Range shrinked(int distance) {
        Preconditions.checkArgument((distance >= 0 ? 1 : 0) != 0);
        if (this.isEmpty()) {
            return EMPTY_RANGE;
        }
        Preconditions.checkArgument((this.width() - 2 * distance >= 0 ? 1 : 0) != 0);
        return new Range(this.lower + distance, this.upper - distance);
    }

    public double getProportionalLocation(int n) {
        double result = Double.NaN;
        if (!this.isEmpty()) {
            double offset = this.clamp(n) - this.getLowerBound();
            double width = this.width();
            result = width != 0.0 ? offset / width : 0.0;
        }
        return result;
    }

    public boolean validatesBoundsAreDifferent(Range other) {
        return this.getLowerBound() != other.getLowerBound() && this.getLowerBound() != other.getUpperBound() && this.getUpperBound() != other.getLowerBound() && this.getUpperBound() != other.getUpperBound();
    }

    public String toString() {
        if (!this.isEmpty()) {
            return MessageFormat.format("[{0}, {1}]", this.lower, this.upper);
        }
        return MessageFormat.format("[<{0}>]", Messages.Range_emptyRange);
    }
}

