/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.notation.BasicDecorationNode;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class SetGMFViewsToNillMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("6.9.0.201309101020");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            LinkedHashSet allViewsToUpdate = Sets.newLinkedHashSet();
            for (DView view : dAnalysis.getOwnedViews()) {
                for (DDiagram dDiagram : Iterables.filter((Iterable)new DViewQuery(view).getLoadedRepresentations(), DDiagram.class)) {
                    DiagramCreationUtil diagramCreationUtil = new DiagramCreationUtil(dDiagram);
                    if (!diagramCreationUtil.findAssociatedGMFDiagram()) continue;
                    Diagram gmfDiagram = diagramCreationUtil.getAssociatedGMFDiagram();
                    allViewsToUpdate.addAll(this.getViewsToUpdate(gmfDiagram));
                }
            }
            for (View viewToUpdate : allViewsToUpdate) {
                viewToUpdate.setElement(null);
            }
        }
        super.postLoad(dAnalysis, loadedVersion);
    }

    private Collection<View> getViewsToUpdate(Diagram gmdDiagram) {
        LinkedHashSet viewsToUpdate = Sets.newLinkedHashSet();
        TreeIterator childIterator = gmdDiagram.eAllContents();
        EReference elementReference = NotationPackage.eINSTANCE.getView_Element();
        while (childIterator.hasNext()) {
            EObject child = (EObject)childIterator.next();
            if (!(child instanceof View) || child.eIsSet((EStructuralFeature)elementReference)) continue;
            boolean childIsANoteOrAText = child instanceof Shape && (ViewType.NOTE.equals(((Shape)child).getType()) || ViewType.TEXT.equals(((Shape)child).getType()));
            boolean childIsANoteAttachement = child instanceof Connector && ViewType.NOTEATTACHMENT.equals(((Connector)child).getType());
            boolean childIsADecorationNode = child instanceof BasicDecorationNode;
            if (!childIsANoteOrAText && !childIsANoteAttachement && !childIsADecorationNode) continue;
            viewsToUpdate.add((View)child);
        }
        return viewsToUpdate;
    }
}

