/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.clipboard;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.viewpoint.description.Group;

public final class SiriusClipboardManager {
    private static final SiriusClipboardManager INSTANCE = new SiriusClipboardManager();
    private TransactionalEditingDomain sourceDomain;
    private Collection<Object> clipboard;

    private SiriusClipboardManager() {
    }

    public static SiriusClipboardManager getInstance() {
        return INSTANCE;
    }

    private Collection<Object> getDomainSafeClipboard(TransactionalEditingDomain targetedDomain, Collection<Object> copyOfClipboard) {
        if (copyOfClipboard == null || targetedDomain == null) {
            return copyOfClipboard;
        }
        EList resources = targetedDomain.getResourceSet().getResources();
        boolean keepDescriptions = false;
        for (EObject eObject : Iterables.filter(copyOfClipboard, EObject.class)) {
            this.removeExternalReferences(eObject, (Collection<Resource>)resources, keepDescriptions);
        }
        return copyOfClipboard;
    }

    private void removeExternalReferences(EObject eObject, Collection<Resource> domainResources, boolean keepDescriptions) {
        for (EReference feature : eObject.eClass().getEAllReferences()) {
            Object value = eObject.eGet((EStructuralFeature)feature);
            if (feature.isDerived()) continue;
            if (value instanceof EObject) {
                EObject target = (EObject)value;
                if (feature.isContainment()) {
                    this.removeExternalReferences(target, domainResources, keepDescriptions);
                    continue;
                }
                if (!this.isExternalEObject(target, domainResources, keepDescriptions)) continue;
                eObject.eUnset((EStructuralFeature)feature);
                continue;
            }
            if (!(value instanceof EList)) continue;
            EList values = (EList)value;
            for (EObject target : Lists.newArrayList((Iterable)Iterables.filter((Iterable)values, EObject.class))) {
                if (feature.isContainment()) {
                    this.removeExternalReferences(target, domainResources, keepDescriptions);
                    continue;
                }
                if (!this.isExternalEObject(target, domainResources, keepDescriptions)) continue;
                values.remove((Object)target);
            }
        }
        if (eObject instanceof EModelElement) {
            for (EAnnotation annotation : ((EModelElement)eObject).getEAnnotations()) {
                this.removeExternalReferences((EObject)annotation, domainResources, keepDescriptions);
            }
        }
        if (eObject instanceof EAnnotation) {
            EList references = ((EAnnotation)eObject).getReferences();
            for (EObject target : Lists.newArrayList((Iterable)references)) {
                if (!this.isExternalEObject(target, domainResources, keepDescriptions)) continue;
                references.remove((Object)target);
            }
        }
    }

    private boolean isExternalEObject(EObject target, Collection<Resource> domainResources, boolean keepDescriptions) {
        boolean isExternal;
        Resource targetResource = target.eResource();
        boolean bl = isExternal = target.eIsProxy() || targetResource != null && !domainResources.contains(targetResource);
        if (isExternal && targetResource != null) {
            isExternal = !(targetResource.getContents().iterator().next() instanceof Group);
        }
        return isExternal;
    }

    private Collection<Object> getCopyOfClipboard() {
        if (this.clipboard != null && !this.clipboard.isEmpty()) {
            return EcoreUtil.copyAll(this.clipboard);
        }
        return null;
    }

    public void setDomainClipboard(TransactionalEditingDomain targetedDomain) {
        Collection<Object> copyOfClipboard = this.getCopyOfClipboard();
        if (targetedDomain != this.sourceDomain) {
            copyOfClipboard = this.getDomainSafeClipboard(targetedDomain, copyOfClipboard);
        }
        targetedDomain.setClipboard(copyOfClipboard);
    }

    public void setSiriusClipboard(TransactionalEditingDomain domain) {
        this.sourceDomain = domain;
        if (this.sourceDomain != null) {
            this.clipboard = this.sourceDomain.getClipboard();
            this.sourceDomain.setClipboard(null);
        } else {
            this.clipboard = null;
        }
    }

    public void setSiriusClipboard(Collection<Object> copies) {
        this.sourceDomain = null;
        this.clipboard = copies;
    }

    public boolean hasPasteData() {
        return this.clipboard != null && !this.clipboard.isEmpty();
    }

    public void dispose() {
        if (this.sourceDomain != null) {
            this.sourceDomain.setClipboard(null);
        }
        this.sourceDomain = null;
        this.clipboard = null;
    }
}

