/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;

public class CreateDiagramWithInitialOperation
extends AbstractCommandTask {
    private UICallBack uiCallBack;
    private DiagramDescription description;
    private EObject semanticElement;
    private IProgressMonitor monitor;

    public CreateDiagramWithInitialOperation(DiagramDescription desc, EObject semanticElement, UICallBack uiCallBack, IProgressMonitor monitor) {
        this.semanticElement = semanticElement;
        this.description = desc;
        this.uiCallBack = uiCallBack;
        this.monitor = monitor;
    }

    private String askDiagramName(EObject semantic) throws InterruptedException {
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)semantic);
        String theName = new IdentifiedElementQuery((IdentifiedElement)this.description).getLabel();
        if (!StringUtil.isEmpty((String)this.description.getTitleExpression())) {
            try {
                theName = interpreter.evaluateString(semantic, this.description.getTitleExpression());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)this.description, (EStructuralFeature)DescriptionPackage.eINSTANCE.getRepresentationDescription_TitleExpression(), (Throwable)e);
            }
        }
        if (this.uiCallBack != null) {
            theName = this.uiCallBack.askForDetailName(theName, theName, this.description.getEndUserDocumentation());
        }
        return theName;
    }

    public void execute() {
        if (this.semanticElement != null) {
            try {
                if (this.monitor == null) {
                    this.monitor = new NullProgressMonitor();
                }
                String name = this.askDiagramName(this.semanticElement);
                DialectManager.INSTANCE.createRepresentation(name, this.semanticElement, (RepresentationDescription)this.description, SessionManager.INSTANCE.getSession(this.semanticElement), this.monitor);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public String getLabel() {
        return null;
    }
}

