/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.al.annotationprocessor;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import fr.inria.diverse.k3.al.annotationprocessor.Composition;
import fr.inria.diverse.k3.al.annotationprocessor.Opposite;
import java.util.Collection;
import java.util.List;
import org.eclipse.xtend.lib.macro.AbstractFieldProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class OppositeProcessor
extends AbstractFieldProcessor {
    protected MutableTypeDeclaration containingType;
    protected MutableFieldDeclaration field;
    protected MutableTypeDeclaration oppositeType;
    protected MutableFieldDeclaration oppositeField;
    @Extension
    protected TransformationContext context;
    protected static final String GENERATED_PREFIX = "__K3_";

    public void doTransform(MutableFieldDeclaration field, TransformationContext ctx) {
        MutableFieldDeclaration _findFirst_1;
        MutableTypeDeclaration _declaringType;
        this.context = ctx;
        Iterable _annotations = field.getAnnotations();
        Functions.Function1<AnnotationReference, Boolean> _function = new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                TypeReference _newTypeReference = OppositeProcessor.this.context.newTypeReference(Opposite.class, new TypeReference[0]);
                Type _type = _newTypeReference.getType();
                return Objects.equal((Object)_annotationTypeDeclaration, (Object)_type);
            }
        };
        AnnotationReference _findFirst = (AnnotationReference)IterableExtensions.findFirst((Iterable)_annotations, (Functions.Function1)_function);
        final Object oppositeRefName = _findFirst.getValue("value");
        TypeReference _type = field.getType();
        boolean _isCollection = this.isCollection(_type);
        if (_isCollection) {
            boolean _notEquals;
            TypeReference _type_1 = field.getType();
            List _actualTypeArguments = _type_1.getActualTypeArguments();
            int _size = _actualTypeArguments.size();
            boolean bl = _notEquals = _size != 1;
            if (_notEquals) {
                this.context.addError((Element)field, "Only collections with 1 type parameter are supported");
                return;
            }
            TypeReference _type_2 = field.getType();
            List _actualTypeArguments_1 = _type_2.getActualTypeArguments();
            TypeReference _head = (TypeReference)IterableExtensions.head((Iterable)_actualTypeArguments_1);
            String _name = _head.getName();
            MutableClassDeclaration _findClass = this.context.findClass(_name);
            this.oppositeType = _findClass;
        } else {
            TypeReference _type_3 = field.getType();
            String _name_1 = _type_3.getName();
            MutableClassDeclaration _findClass_1 = this.context.findClass(_name_1);
            this.oppositeType = _findClass_1;
        }
        this.field = field;
        this.containingType = _declaringType = field.getDeclaringType();
        Iterable _declaredFields = this.oppositeType.getDeclaredFields();
        Functions.Function1<MutableFieldDeclaration, Boolean> _function_1 = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

            public Boolean apply(MutableFieldDeclaration f) {
                String _simpleName = f.getSimpleName();
                return _simpleName.equals(oppositeRefName);
            }
        };
        this.oppositeField = _findFirst_1 = (MutableFieldDeclaration)IterableExtensions.findFirst((Iterable)_declaredFields, (Functions.Function1)_function_1);
        boolean _check = this.check();
        if (_check) {
            this.field.setVisibility(Visibility.PRIVATE);
            this.generateInitializer();
            this.generateGetterMethod();
            this.generateSetterProxyMethod();
            this.generateResetMethod();
            this.generateSetMethod();
        }
    }

    protected void generateInitializer() {
        TypeReference _type = this.field.getType();
        boolean _isCollection = this.isCollection(_type);
        if (_isCollection) {
            TypeReference _type_1 = this.field.getType();
            List _actualTypeArguments = _type_1.getActualTypeArguments();
            TypeReference _head = (TypeReference)IterableExtensions.head((Iterable)_actualTypeArguments);
            final String t = _head.getSimpleName();
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"new java.util.ArrayList<");
                    _builder.append((Object)t, "");
                    _builder.append((Object)">()");
                }
            };
            this.field.setInitializer(_client);
        } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"null");
                }
            };
            this.field.setInitializer(_client_1);
        }
    }

    protected void generateGetterMethod() {
        final String f = this.field.getSimpleName();
        TypeReference _type = this.field.getType();
        boolean _isCollection = this.isCollection(_type);
        if (_isCollection) {
            String _getterName = this.getGetterName(this.field);
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setVisibility(Visibility.PUBLIC);
                    TypeReference _type = OppositeProcessor.this.field.getType();
                    List _actualTypeArguments = _type.getActualTypeArguments();
                    TypeReference _head = (TypeReference)IterableExtensions.head((Iterable)_actualTypeArguments);
                    TypeReference _newTypeReference = OppositeProcessor.this.context.newTypeReference(ImmutableList.class, new TypeReference[]{_head});
                    it.setReturnType(_newTypeReference);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"return com.google.common.collect.ImmutableList.copyOf(");
                            _builder.append((Object)f, "");
                            _builder.append((Object)") ;");
                        }
                    };
                    it.setBody(_client);
                }
            };
            this.containingType.addMethod(_getterName, (Procedures.Procedure1)_function);
        } else {
            String _getterName_1 = this.getGetterName(this.field);
            Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setVisibility(Visibility.PUBLIC);
                    TypeReference _type = OppositeProcessor.this.field.getType();
                    it.setReturnType(_type);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"return ");
                            _builder.append((Object)f, "");
                            _builder.append((Object)" ;");
                        }
                    };
                    it.setBody(_client);
                }
            };
            this.containingType.addMethod(_getterName_1, (Procedures.Procedure1)_function_1);
        }
    }

    protected void generateSetterProxyMethod() {
        final String f = this.field.getSimpleName();
        final String o = this.oppositeField.getSimpleName();
        final TypeReference t = this.oppositeField.getType();
        TypeReference _type = this.field.getType();
        boolean _isCollection = this.isCollection(_type);
        if (_isCollection) {
            String _simpleName = this.field.getSimpleName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_simpleName);
            String _plus = "add" + _firstUpper;
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setVisibility(Visibility.PUBLIC);
                    TypeReference _type = OppositeProcessor.this.field.getType();
                    List _actualTypeArguments = _type.getActualTypeArguments();
                    TypeReference _head = (TypeReference)IterableExtensions.head((Iterable)_actualTypeArguments);
                    it.addParameter("obj", _head);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"if (!");
                            _builder.append((Object)f, "");
                            _builder.append((Object)".contains(obj)) {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"if (obj != null)");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"obj.");
                            _builder.append((Object)OppositeProcessor.GENERATED_PREFIX, "\t\t");
                            _builder.append((Object)o, "\t\t");
                            _builder.append((Object)"_set(this) ;");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)f, "\t");
                            _builder.append((Object)".add(obj) ;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"}");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                }
            };
            this.containingType.addMethod(_plus, (Procedures.Procedure1)_function);
        } else {
            String _setterName = this.getSetterName(this.field);
            Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setVisibility(Visibility.PUBLIC);
                    TypeReference _type = OppositeProcessor.this.field.getType();
                    it.addParameter("obj", _type);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"if (obj != ");
                            _builder.append((Object)f, "");
                            _builder.append((Object)") {");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"if (");
                            _builder.append((Object)f, "\t");
                            _builder.append((Object)" != null)");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)f, "\t\t");
                            _builder.append((Object)".");
                            _builder.append((Object)OppositeProcessor.GENERATED_PREFIX, "\t\t");
                            _builder.append((Object)o, "\t\t");
                            _builder.append((Object)"_reset(");
                            boolean _isCollection = OppositeProcessor.this.isCollection(t);
                            if (_isCollection) {
                                _builder.append((Object)"this");
                            }
                            _builder.append((Object)") ;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"if (obj != null)");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"obj.");
                            _builder.append((Object)OppositeProcessor.GENERATED_PREFIX, "\t\t");
                            _builder.append((Object)o, "\t\t");
                            _builder.append((Object)"_set(this) ;");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)f, "\t");
                            _builder.append((Object)" = obj ;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"}");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                }
            };
            this.containingType.addMethod(_setterName, (Procedures.Procedure1)_function_1);
        }
    }

    protected void generateResetMethod() {
        final String f = this.field.getSimpleName();
        final String o = this.oppositeField.getSimpleName();
        final TypeReference t = this.oppositeField.getType();
        TypeReference _type = this.field.getType();
        boolean _isCollection = this.isCollection(_type);
        if (_isCollection) {
            String _simpleName = this.field.getSimpleName();
            String _plus = GENERATED_PREFIX + _simpleName;
            String _plus_1 = String.valueOf(_plus) + "_reset";
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setVisibility(Visibility.PUBLIC);
                    TypeReference _type = OppositeProcessor.this.field.getType();
                    List _actualTypeArguments = _type.getActualTypeArguments();
                    TypeReference _head = (TypeReference)IterableExtensions.head((Iterable)_actualTypeArguments);
                    it.addParameter("obj", _head);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"if (");
                            _builder.append((Object)f, "");
                            _builder.append((Object)".contains(obj))");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)f, "\t");
                            _builder.append((Object)".remove(obj) ;");
                            _builder.newLineIfNotEmpty();
                        }
                    };
                    it.setBody(_client);
                }
            };
            this.containingType.addMethod(_plus_1, (Procedures.Procedure1)_function);
            String _simpleName_1 = this.field.getSimpleName();
            String _firstUpper = StringExtensions.toFirstUpper((String)_simpleName_1);
            String _plus_2 = "remove" + _firstUpper;
            Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setVisibility(Visibility.PUBLIC);
                    TypeReference _type = OppositeProcessor.this.field.getType();
                    List _actualTypeArguments = _type.getActualTypeArguments();
                    TypeReference _head = (TypeReference)IterableExtensions.head((Iterable)_actualTypeArguments);
                    it.addParameter("obj", _head);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"if (obj != null)");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)"obj.");
                            _builder.append((Object)OppositeProcessor.GENERATED_PREFIX, "\t");
                            _builder.append((Object)o, "\t");
                            _builder.append((Object)"_reset(");
                            boolean _isCollection = OppositeProcessor.this.isCollection(t);
                            if (_isCollection) {
                                _builder.append((Object)"this");
                            }
                            _builder.append((Object)") ;");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)f, "");
                            _builder.append((Object)".remove(obj) ;");
                            _builder.newLineIfNotEmpty();
                        }
                    };
                    it.setBody(_client);
                }
            };
            this.containingType.addMethod(_plus_2, (Procedures.Procedure1)_function_1);
        } else {
            Procedures.Procedure1<MutableMethodDeclaration> _function_2 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setVisibility(Visibility.PUBLIC);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)f, "");
                            _builder.append((Object)" = null ;");
                        }
                    };
                    it.setBody(_client);
                }
            };
            this.containingType.addMethod(GENERATED_PREFIX + f + "_reset", (Procedures.Procedure1)_function_2);
        }
    }

    protected void generateSetMethod() {
        final String f = this.field.getSimpleName();
        final String o = this.oppositeField.getSimpleName();
        final TypeReference t = this.oppositeField.getType();
        TypeReference _type = this.field.getType();
        boolean _isCollection = this.isCollection(_type);
        if (_isCollection) {
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setVisibility(Visibility.PUBLIC);
                    TypeReference _type = OppositeProcessor.this.field.getType();
                    List _actualTypeArguments = _type.getActualTypeArguments();
                    TypeReference _head = (TypeReference)IterableExtensions.head((Iterable)_actualTypeArguments);
                    it.addParameter("obj", _head);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)f, "");
                            _builder.append((Object)".add(obj) ;");
                            _builder.newLineIfNotEmpty();
                        }
                    };
                    it.setBody(_client);
                }
            };
            this.containingType.addMethod(GENERATED_PREFIX + f + "_set", (Procedures.Procedure1)_function);
        } else {
            Procedures.Procedure1<MutableMethodDeclaration> _function_1 = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    it.setVisibility(Visibility.PUBLIC);
                    TypeReference _type = OppositeProcessor.this.field.getType();
                    it.addParameter("obj", _type);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"if (");
                            _builder.append((Object)f, "");
                            _builder.append((Object)" != null)");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)f, "\t");
                            _builder.append((Object)".");
                            _builder.append((Object)OppositeProcessor.GENERATED_PREFIX, "\t");
                            _builder.append((Object)o, "\t");
                            _builder.append((Object)"_reset(");
                            boolean _isCollection = OppositeProcessor.this.isCollection(t);
                            if (_isCollection) {
                                _builder.append((Object)"this");
                            }
                            _builder.append((Object)") ;");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)f, "");
                            _builder.append((Object)" = obj ;");
                            _builder.newLineIfNotEmpty();
                        }
                    };
                    it.setBody(_client);
                }
            };
            this.containingType.addMethod(GENERATED_PREFIX + f + "_set", (Procedures.Procedure1)_function_1);
        }
    }

    protected boolean check() {
        boolean _not;
        Functions.Function1<AnnotationReference, Boolean> _function;
        if (this.field.getType().isPrimitive() || this.field.getType().isWrapper()) {
            TypeReference _type = this.field.getType();
            String _simpleName = _type.getSimpleName();
            String _plus = "Can't declare a primitive type " + _simpleName;
            String _plus_1 = String.valueOf(_plus) + " as opposite";
            this.context.addError((Element)this.field, _plus_1);
            return false;
        }
        if (this.oppositeField == null) {
            this.context.addError((Element)this.field, "Referenced opposite attribute doesn't exist");
            return false;
        }
        if (!this.isCollection(this.oppositeField.getType()) && !Objects.equal((Object)this.oppositeField.getType(), (Object)this.context.newTypeReference((Type)this.containingType, new TypeReference[0])) || this.isCollection(this.oppositeField.getType()) && !Objects.equal((Object)IterableExtensions.head((Iterable)this.oppositeField.getType().getActualTypeArguments()), (Object)this.context.newTypeReference((Type)this.containingType, new TypeReference[0]))) {
            TypeReference _type_1 = this.oppositeField.getType();
            String _simpleName_1 = _type_1.getSimpleName();
            String _plus_2 = "The opposite attribute type (" + _simpleName_1;
            String _plus_3 = String.valueOf(_plus_2) + ") doesn't match";
            this.context.addError((Element)this.field, _plus_3);
            return false;
        }
        if (IterableExtensions.exists((Iterable)this.field.getAnnotations(), (Functions.Function1)new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                TypeReference _newTypeReference = OppositeProcessor.this.context.newTypeReference(Composition.class, new TypeReference[0]);
                Type _type = _newTypeReference.getType();
                return Objects.equal((Object)_annotationTypeDeclaration, (Object)_type);
            }
        }) && IterableExtensions.exists((Iterable)this.oppositeField.getAnnotations(), (Functions.Function1)new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                AnnotationTypeDeclaration _annotationTypeDeclaration = it.getAnnotationTypeDeclaration();
                TypeReference _newTypeReference = OppositeProcessor.this.context.newTypeReference(Composition.class, new TypeReference[0]);
                Type _type = _newTypeReference.getType();
                return Objects.equal((Object)_annotationTypeDeclaration, (Object)_type);
            }
        })) {
            this.context.addError((Element)this.field, "Can't declare as opposites two composition references");
            return false;
        }
        Iterable _annotations = this.oppositeField.getAnnotations();
        boolean _exists = IterableExtensions.exists((Iterable)_annotations, (Functions.Function1)(_function = new Functions.Function1<AnnotationReference, Boolean>(){

            public Boolean apply(AnnotationReference it) {
                return Objects.equal((Object)it.getAnnotationTypeDeclaration(), (Object)OppositeProcessor.this.context.newTypeReference(Opposite.class, new TypeReference[0]).getType()) && it.getValue("value").equals(OppositeProcessor.this.field.getSimpleName());
            }
        }));
        boolean bl = _not = !_exists;
        if (_not) {
            this.context.addError((Element)this.field, "The opposite attribute must be marked as opposite of this attribute");
            return false;
        }
        return true;
    }

    protected boolean isCollection(TypeReference type) {
        TypeReference _newWildcardTypeReference = this.context.newWildcardTypeReference();
        TypeReference _newTypeReference = this.context.newTypeReference(Collection.class, new TypeReference[]{_newWildcardTypeReference});
        return _newTypeReference.isAssignableFrom(type);
    }

    protected String getGetterName(MutableFieldDeclaration f) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"get");
        String _simpleName = f.getSimpleName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_simpleName);
        _builder.append((Object)_firstUpper, "");
        return _builder.toString();
    }

    protected String getSetterName(MutableFieldDeclaration f) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"set");
        String _simpleName = f.getSimpleName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_simpleName);
        _builder.append((Object)_firstUpper, "");
        return _builder.toString();
    }
}

