/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.jdt.preferences;

import org.eclipse.contribution.jdt.preferences.WeavableProjectListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.util.Util;

public class ReindexingJob
extends WorkspaceJob {
    private static final Object LOCK = new Object();
    private static boolean isRunning = false;

    public ReindexingJob() {
        super("Reindexing for JDT Weaving");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        ReindexingJob.waitForJobFamily("org.eclipse.jdt.ui", monitor);
        Object object = LOCK;
        synchronized (object) {
            if (isRunning) {
                return Status.OK_STATUS;
            }
        }
        isRunning = true;
        IndexManager indexer = JavaModelManager.getIndexManager();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        monitor.beginTask("Reindexing", projects == null ? 0 : projects.length);
        if (projects == null) {
            return Status.OK_STATUS;
        }
        int i = 0;
        while (i < projects.length) {
            if (WeavableProjectListener.getInstance().isWeavableProject(projects[i])) {
                projects[i].accept((IResourceVisitor)new TouchJavaLikeResourceVisitor(monitor));
                indexer.indexAll(projects[i]);
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++i;
        }
        Object object2 = LOCK;
        synchronized (object2) {
            isRunning = false;
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return ReindexingJob.class == family;
    }

    public static void waitForJobFamily(Object jobFamily, IProgressMonitor monitor) {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(jobFamily, monitor);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    private class TouchJavaLikeResourceVisitor
    implements IResourceVisitor {
        IProgressMonitor monitor;

        TouchJavaLikeResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1 && Util.isJavaLikeFileName((String)resource.getName())) {
                resource.touch(this.monitor);
            }
            return true;
        }
    }
}

