/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.ui.editor;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.session.SessionSpecificEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;

public class EcoreEntitiesMatchingStrategy
implements IEditorMatchingStrategy {
    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        boolean result = false;
        SessionSpecificEditorInput sseiRef = this.getSessionSpecificEditorInput(editorRef);
        if (sseiRef != null) {
            if (sseiRef.equals((Object)input)) {
                result = true;
            } else if (input instanceof IFileEditorInput) {
                Session sessionRef = sseiRef.getSession();
                URI inputUri = URI.createPlatformResourceURI((String)((IFileEditorInput)input).getFile().getFullPath().toString(), (boolean)true);
                if (sessionRef != null && sessionRef.isOpen()) {
                    Resource currentRes = sessionRef.getTransactionalEditingDomain().getResourceSet().getResource(inputUri, false);
                    result = currentRes != null && sessionRef.getSemanticResources().contains(currentRes);
                }
            }
        }
        return result;
    }

    private SessionSpecificEditorInput getSessionSpecificEditorInput(IEditorReference editorRef) {
        SessionSpecificEditorInput ssei = null;
        try {
            IEditorInput editorInput = editorRef.getEditorInput();
            if (editorInput instanceof SessionSpecificEditorInput) {
                ssei = (SessionSpecificEditorInput)editorInput;
            }
        }
        catch (PartInitException partInitException) {}
        return ssei;
    }
}

