/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gemoc.dsl.debug.Variable;
import org.eclipse.gemoc.dsl.debug.ide.DSLBreakpoint;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLStackFrameAdapter;
import org.eclipse.gemoc.dsl.debug.ide.adapter.value.DSLObjectValue;
import org.eclipse.gemoc.dsl.debug.ide.adapter.variable.DSLObjectVariable;
import org.eclipse.gemoc.dsl.debug.ide.ui.DebugIdeUiPlugin;
import org.eclipse.gemoc.dsl.debug.ide.ui.EMFEditorUtils;
import org.eclipse.gemoc.dsl.debug.provider.CustomDebugItemProviderAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class DSLDebugModelPresentation
implements IDebugModelPresentation,
IDebugEditorPresentation {
    protected final Map<ImageDescriptor, Image> imagesCache = new HashMap<ImageDescriptor, Image>();
    private final ILabelProvider eLabelProvider;

    public DSLDebugModelPresentation() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        CustomDebugItemProviderAdapterFactory debugFactory = new CustomDebugItemProviderAdapterFactory();
        adapterFactory.addAdapterFactory((AdapterFactory)debugFactory);
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.eLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
    }

    public void addListener(ILabelProviderListener listener) {
        this.eLabelProvider.addListener(listener);
    }

    public void dispose() {
        for (Image cachedImage : this.imagesCache.values()) {
            cachedImage.dispose();
        }
        this.eLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        Object unwrapped = this.unwrapp(element);
        boolean res = unwrapped instanceof Variable ? this.isLabelProperty(((Variable)unwrapped).getValue(), property) : this.eLabelProvider.isLabelProperty(this.unwrapp(element), property);
        return res;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.eLabelProvider.removeListener(listener);
    }

    public IEditorInput getEditorInput(Object element) {
        return EMFEditorUtils.getEditorInput(element);
    }

    public String getEditorId(IEditorInput input, Object element) {
        String res = EMFEditorUtils.getEditorID(input, element);
        return res;
    }

    public void setAttribute(String attribute, Object value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(Object element) {
        Image res;
        Object unwrapped = this.unwrapp(element);
        if (unwrapped instanceof Variable) {
            res = this.getImage(((Variable)unwrapped).getValue());
        } else if (element instanceof DSLBreakpoint) {
            ImageDescriptor descriptor;
            Image cachedImage;
            Object image = ((DSLBreakpoint)element).getImage();
            if (image instanceof ComposedImage) {
                ((ComposedImage)image).getImages().add(DebugIdeUiPlugin.INSTANCE.getImage("full/deco16/breakpoint_enabled"));
            }
            if ((cachedImage = this.imagesCache.get(descriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(image))) == null) {
                cachedImage = new Image((Device)Display.getDefault(), descriptor.getImageData());
                this.imagesCache.put(descriptor, cachedImage);
            }
            res = cachedImage;
        } else if (unwrapped != null) {
            Object object = unwrapped;
            synchronized (object) {
                res = this.eLabelProvider.getImage(unwrapped);
            }
        } else {
            res = null;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(Object element) {
        String res;
        Object unwrapped = this.unwrapp(element);
        if (unwrapped instanceof Variable) {
            res = this.getText(((Variable)unwrapped).getValue());
        } else if (element instanceof DSLBreakpoint) {
            res = ((DSLBreakpoint)element).getText();
        } else {
            Object object = unwrapped;
            synchronized (object) {
                res = this.eLabelProvider.getText(unwrapped);
            }
        }
        return res;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    private Object unwrapp(Object element) {
        Object res = element instanceof DSLObjectVariable ? ((DSLObjectVariable)element).getObject() : (element instanceof DSLObjectValue ? ((DSLObjectValue)element).getValue() : (element instanceof Adapter ? ((Adapter)element).getTarget() : element));
        return res;
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        if (frame instanceof DSLStackFrameAdapter) {
            EObject instruction = ((DSLStackFrameAdapter)frame).getCurrentInstruction();
            URI instructionUri = EcoreUtil.getURI((EObject)instruction);
            EMFEditorUtils.selectInstruction(editorPart, instructionUri);
        }
        return true;
    }

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
    }
}

