/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.commons;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.executionframework.engine.commons.DefaultExecutionPlatform;
import org.eclipse.gemoc.executionframework.engine.commons.DslHelper;
import org.eclipse.gemoc.executionframework.engine.commons.EngineContextException;
import org.eclipse.gemoc.executionframework.engine.core.ExecutionWorkspace;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionPlatform;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionWorkspace;
import org.eclipse.gemoc.xdsmlframework.api.core.IRunConfiguration;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtension;
import org.osgi.framework.Bundle;

public abstract class ModelExecutionContext
implements IExecutionContext {
    protected IRunConfiguration _runConfiguration;
    protected Resource _resourceModel;
    protected ExecutionMode _executionMode;
    protected LanguageDefinitionExtension _languageDefinition;
    protected Bundle _dslBundle;
    private IExecutionWorkspace _executionWorkspace;
    protected IExecutionPlatform _executionPlatform;

    public ModelExecutionContext(IRunConfiguration runConfiguration, ExecutionMode executionMode) throws EngineContextException {
        this._runConfiguration = runConfiguration;
        this._executionMode = executionMode;
        try {
            this._executionWorkspace = new ExecutionWorkspace(this._runConfiguration.getExecutedModelURI());
            try {
                this._executionWorkspace.copyFileToExecutionFolder(this._executionWorkspace.getModelPath());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this._languageDefinition = this.getLanguageDefinition(this._runConfiguration.getLanguageName());
            this._dslBundle = DslHelper.getDslBundle(this._runConfiguration.getLanguageName());
            this._executionPlatform = this.createExecutionPlatform();
        }
        catch (CoreException e) {
            EngineContextException exception = new EngineContextException("Cannot initialize the execution context, see inner exception.", (Exception)((Object)e));
            throw exception;
        }
    }

    public void initializeResourceModel() {
        this._resourceModel = this._runConfiguration.getAnimatorURI() != null ? this._executionPlatform.getModelLoader().loadModelForAnimation((IExecutionContext)this) : this._executionPlatform.getModelLoader().loadModel((IExecutionContext)this);
        this.setUpEditingDomain();
    }

    protected void checkResourceSetContent() {
        boolean foundOnce = false;
        for (Resource res : this._resourceModel.getResourceSet().getResources()) {
            boolean found = res.getURI().path().equals(this._runConfiguration.getExecutedModelURI().path());
            if (found && foundOnce) {
                Activator.getDefault().error("Error: found more than one resource in the resourceSet with the following path :" + this._runConfiguration.getExecutedModelURI().path());
                for (Resource r : this._resourceModel.getResourceSet().getResources()) {
                    Activator.getDefault().info(r.getURI().toString());
                }
                break;
            }
            if (!found) continue;
            foundOnce = true;
        }
    }

    protected IExecutionPlatform createExecutionPlatform() throws CoreException {
        return new DefaultExecutionPlatform(this._languageDefinition, this._runConfiguration);
    }

    protected abstract LanguageDefinitionExtension getLanguageDefinition(String var1) throws EngineContextException;

    private ResourceSet getResourceSet() {
        return this._resourceModel.getResourceSet();
    }

    private void setUpEditingDomain() {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((ResourceSet)this.getResourceSet());
        if (editingDomain == null) {
            editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(this.getResourceSet());
        }
    }

    public IRunConfiguration getRunConfiguration() {
        return this._runConfiguration;
    }

    public Resource getResourceModel() {
        return this._resourceModel;
    }

    public void dispose() {
        this._executionPlatform.dispose();
    }

    public IExecutionWorkspace getWorkspace() {
        return this._executionWorkspace;
    }

    public ExecutionMode getExecutionMode() {
        return this._executionMode;
    }

    public IExecutionPlatform getExecutionPlatform() {
        return this._executionPlatform;
    }

    public LanguageDefinitionExtension getLanguageDefinitionExtension() {
        return this._languageDefinition;
    }

    public Bundle getDslBundle() {
        return this._dslBundle;
    }
}

