/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.traceaddon;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.commons.eclipse.emf.EMFResource;
import org.eclipse.gemoc.executionframework.debugger.IDynamicPartAccessor;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.gemoc.trace.commons.model.generictrace.BooleanAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericDimension;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericSequentialStep;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericSmallStep;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericState;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericStep;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericTracedObject;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenerictraceFactory;
import org.eclipse.gemoc.trace.commons.model.generictrace.IntegerAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.IntegerObjectAttributeValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.ManyReferenceValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.SingleReferenceValue;
import org.eclipse.gemoc.trace.commons.model.generictrace.StringAttributeValue;
import org.eclipse.gemoc.trace.commons.model.launchconfiguration.LaunchConfiguration;
import org.eclipse.gemoc.trace.commons.model.trace.BigStep;
import org.eclipse.gemoc.trace.commons.model.trace.MSEModel;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.Trace;
import org.eclipse.gemoc.trace.commons.model.trace.TraceFactory;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.gemoc.api.ITraceConstructor;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.ModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.NewObjectModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.NonCollectionFieldModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.PotentialCollectionFieldModelChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.RemovedObjectModelChange;

public class GenericTraceConstructor
implements ITraceConstructor {
    private Trace<GenericSequentialStep, GenericTracedObject, GenericState> traceRoot;
    private Resource executedModel;
    private MSEModel mseModel;
    private Resource traceResource;
    private final Map<EObject, TracedObject<?>> exeToTraced;
    private final Deque<GenericSequentialStep> context = new LinkedList<GenericSequentialStep>();
    private GenericState lastState;
    IDynamicPartAccessor dynamicPartAccessor;
    private boolean copiedState = false;

    public GenericTraceConstructor(Resource executedModel, Resource traceResource, Map<EObject, TracedObject<?>> exeToTraced, IDynamicPartAccessor dynamicPartAccessor) {
        this.executedModel = executedModel;
        this.traceResource = traceResource;
        this.exeToTraced = exeToTraced;
        this.dynamicPartAccessor = dynamicPartAccessor;
    }

    private Set<Resource> getAllExecutedModelResources() {
        HashSet<Resource> allResources = new HashSet<Resource>();
        allResources.add(this.executedModel);
        allResources.addAll(EMFResource.getRelatedResources((Resource)this.executedModel));
        allResources.removeIf(r -> r == null);
        return allResources;
    }

    private boolean addNewObjectToStateIfDynamic(EObject object, GenericState state) {
        EClass c = object.eClass();
        List fields = this.dynamicPartAccessor.extractMutableField(object);
        List<EStructuralFeature> mutableProperties = fields.stream().map(f -> f.getMutableProperty()).collect(Collectors.toList());
        if (this.dynamicPartAccessor.isDynamic(object) || !fields.isEmpty()) {
            return this.addNewObjectToState(object, mutableProperties, this.lastState);
        }
        return true;
    }

    private GenericValue getGenericValue(EObject object, EStructuralFeature mutableProperty, GenericState state) {
        IntegerAttributeValue result = null;
        List fields = this.dynamicPartAccessor.extractMutableField(object);
        Optional<MutableField> dynamicProperty = fields.stream().filter(field -> field.getMutableProperty().getName().equals(mutableProperty.getName())).findFirst();
        if (mutableProperty instanceof EAttribute) {
            EClassifier eType = mutableProperty.getEType();
            if (eType == EcorePackage.Literals.EINT) {
                IntegerAttributeValue value = GenerictraceFactory.eINSTANCE.createIntegerAttributeValue();
                if (dynamicProperty.isPresent()) {
                    value.setAttributeValue(((Integer)dynamicProperty.get().getValue()).intValue());
                }
                result = value;
            } else if (eType == EcorePackage.Literals.EBOOLEAN) {
                BooleanAttributeValue value = GenerictraceFactory.eINSTANCE.createBooleanAttributeValue();
                if (dynamicProperty.isPresent()) {
                    value.setAttributeValue(((Boolean)dynamicProperty.get().getValue()).booleanValue());
                }
                result = value;
            } else if (eType == EcorePackage.Literals.ESTRING) {
                StringAttributeValue value = GenerictraceFactory.eINSTANCE.createStringAttributeValue();
                if (dynamicProperty.isPresent()) {
                    value.setAttributeValue((String)dynamicProperty.get().getValue());
                }
                result = value;
            } else if (eType == EcorePackage.Literals.EINTEGER_OBJECT) {
                IntegerObjectAttributeValue value = GenerictraceFactory.eINSTANCE.createIntegerObjectAttributeValue();
                if (dynamicProperty.isPresent()) {
                    value.setAttributeValue((Integer)dynamicProperty.get().getValue());
                }
                result = value;
            }
        } else if (mutableProperty instanceof EReference) {
            if (mutableProperty.isMany()) {
                List modelElements = new ArrayList();
                if (dynamicProperty.isPresent()) {
                    modelElements = (List)dynamicProperty.get().getValue();
                }
                ManyReferenceValue value = GenerictraceFactory.eINSTANCE.createManyReferenceValue();
                for (EObject o : modelElements) {
                    if (this.dynamicPartAccessor.isDynamic(o) || !fields.isEmpty()) {
                        value.getReferenceValues().add((Object)((EObject)this.exeToTraced.get(o)));
                        continue;
                    }
                    value.getReferenceValues().add((Object)o);
                }
                result = value;
            } else {
                EObject o = null;
                if (dynamicProperty.isPresent()) {
                    o = (EObject)dynamicProperty.get().getValue();
                }
                SingleReferenceValue value = GenerictraceFactory.eINSTANCE.createSingleReferenceValue();
                if (o != null && this.dynamicPartAccessor.isDynamic(o)) {
                    value.setReferenceValue((EObject)this.exeToTraced.get(o));
                } else {
                    value.setReferenceValue(o);
                }
                result = value;
            }
        }
        return result;
    }

    private boolean addNewObjectToState(EObject object, List<EStructuralFeature> mutableProperties, GenericState state) {
        boolean added = false;
        if (!this.exeToTraced.containsKey(object)) {
            List fields = this.dynamicPartAccessor.extractMutableField(object);
            GenericTracedObject tracedObject = GenerictraceFactory.eINSTANCE.createGenericTracedObject();
            if (this.dynamicPartAccessor.isDynamic(object) || !fields.isEmpty()) {
                tracedObject.setOriginalObject(object);
            }
            this.exeToTraced.put(object, (TracedObject<?>)tracedObject);
            for (EStructuralFeature mutableProperty : mutableProperties) {
                IntegerAttributeValue value;
                Optional<MutableField> dynamicProperty = fields.stream().filter(field -> field.getMutableProperty().getName().equals(mutableProperty.getName())).findFirst();
                GenericDimension dimension = GenerictraceFactory.eINSTANCE.createGenericDimension();
                IntegerAttributeValue firstValue = null;
                dimension.setDynamicProperty(mutableProperty);
                tracedObject.getAllDimensions().add((Object)dimension);
                if (mutableProperty instanceof EAttribute) {
                    EClassifier eType = mutableProperty.getEType();
                    if (eType == EcorePackage.Literals.EINT) {
                        value = GenerictraceFactory.eINSTANCE.createIntegerAttributeValue();
                        if (dynamicProperty.isPresent()) {
                            value.setAttributeValue(((Integer)dynamicProperty.get().getValue()).intValue());
                        }
                        firstValue = value;
                    } else if (eType == EcorePackage.Literals.EBOOLEAN) {
                        value = GenerictraceFactory.eINSTANCE.createBooleanAttributeValue();
                        if (dynamicProperty.isPresent()) {
                            value.setAttributeValue(((Boolean)dynamicProperty.get().getValue()).booleanValue());
                        }
                        firstValue = value;
                    } else if (eType == EcorePackage.Literals.ESTRING) {
                        value = GenerictraceFactory.eINSTANCE.createStringAttributeValue();
                        if (dynamicProperty.isPresent()) {
                            value.setAttributeValue((String)dynamicProperty.get().getValue());
                        }
                        firstValue = value;
                    }
                } else if (mutableProperty instanceof EReference) {
                    if (mutableProperty.isMany()) {
                        List modelElements = new ArrayList();
                        if (dynamicProperty.isPresent()) {
                            modelElements = (List)dynamicProperty.get().getValue();
                        }
                        value = GenerictraceFactory.eINSTANCE.createManyReferenceValue();
                        for (EObject o : modelElements) {
                            this.addNewObjectToStateIfDynamic(o, state);
                            value.getReferenceValues().add((Object)((EObject)this.exeToTraced.get(o)));
                        }
                        firstValue = value;
                    } else {
                        EObject o = null;
                        if (dynamicProperty.isPresent()) {
                            o = (EObject)dynamicProperty.get().getValue();
                        }
                        if (o != null) {
                            this.addNewObjectToStateIfDynamic(o, state);
                            value = GenerictraceFactory.eINSTANCE.createSingleReferenceValue();
                            value.setReferenceValue((EObject)this.exeToTraced.get(o));
                            firstValue = value;
                        }
                    }
                }
                if (firstValue == null) continue;
                dimension.getValues().add(firstValue);
                state.getValues().add((Object)firstValue);
            }
            this.traceRoot.getTracedObjects().add((Object)tracedObject);
            added = true;
        }
        return added;
    }

    private void addInitialState() {
        if (this.lastState == null) {
            Set<Resource> allResources = this.getAllExecutedModelResources();
            this.lastState = GenerictraceFactory.eINSTANCE.createGenericState();
            for (Resource r : allResources) {
                TreeIterator i = r.getAllContents();
                while (i.hasNext()) {
                    EObject o = (EObject)i.next();
                    this.addNewObjectToStateIfDynamic(o, this.lastState);
                }
            }
            this.traceRoot.getStates().add((Object)this.lastState);
        }
    }

    private GenericState copyState(GenericState oldState) {
        GenericState newState = GenerictraceFactory.eINSTANCE.createGenericState();
        newState.getValues().addAll((Collection)oldState.getValues());
        this.copiedState = true;
        return newState;
    }

    public void addState(List<ModelChange> modelChanges) {
        if (this.lastState == null) {
            this.addInitialState();
        }
        if (!modelChanges.isEmpty()) {
            boolean stateChanged = false;
            GenericState newState = this.copyState(this.lastState);
            for (ModelChange modelChange : modelChanges) {
                ManyReferenceValue lastValue;
                GenericDimension dimension;
                GenericTracedObject tracedObject;
                Optional<MutableField> dynamicProperty;
                EStructuralFeature p;
                EObject o = modelChange.getChangedObject();
                List fields = this.dynamicPartAccessor.extractMutableField(o);
                if (modelChange instanceof NewObjectModelChange) {
                    stateChanged = true;
                    this.addNewObjectToStateIfDynamic(o, newState);
                    continue;
                }
                if (modelChange instanceof RemovedObjectModelChange) {
                    stateChanged = true;
                    EList values = newState.getValues();
                    ((GenericTracedObject)this.exeToTraced.get(o)).getAllDimensions().forEach(arg_0 -> GenericTraceConstructor.lambda$4((List)values, arg_0));
                    continue;
                }
                if (modelChange instanceof NonCollectionFieldModelChange) {
                    Object pValue;
                    stateChanged = true;
                    p = ((NonCollectionFieldModelChange)modelChange).getChangedField();
                    dynamicProperty = fields.stream().filter(field -> field.getMutableProperty().getName().equals(p.getName())).findFirst();
                    tracedObject = (GenericTracedObject)this.exeToTraced.get(o);
                    dimension = tracedObject.getAllDimensions().stream().filter(d -> d.getDynamicProperty().getName().equals(p.getName())).findFirst().orElse(null);
                    if (dimension == null) continue;
                    EList values = dimension.getValues();
                    if (dynamicProperty.isPresent() && (pValue = dynamicProperty.get().getValue()) instanceof EObject) {
                        this.addNewObjectToStateIfDynamic((EObject)pValue, newState);
                    }
                    Object object = lastValue = values.isEmpty() ? null : (GenericValue)values.get(values.size() - 1);
                    if (lastValue != null) {
                        newState.getValues().remove((Object)lastValue);
                    }
                    GenericValue newValue = this.getGenericValue(o, p, newState);
                    values.add(newValue);
                    newState.getValues().add((Object)newValue);
                    continue;
                }
                if (!(modelChange instanceof PotentialCollectionFieldModelChange)) continue;
                p = ((PotentialCollectionFieldModelChange)modelChange).getChangedField();
                dynamicProperty = fields.stream().filter(field -> field.getMutableProperty().getName().equals(p.getName())).findFirst();
                tracedObject = (GenericTracedObject)this.exeToTraced.get(o);
                dimension = tracedObject.getAllDimensions().stream().filter(d -> d.getDynamicProperty() == p).findFirst().orElse(null);
                if (dimension == null) continue;
                EList dimensionValues = dimension.getValues();
                lastValue = (ManyReferenceValue)dimensionValues.get(dimensionValues.size() - 1);
                List values = new ArrayList();
                if (dynamicProperty.isPresent()) {
                    values = (List)dynamicProperty.get().getValue();
                }
                for (EObject eObj : values) {
                    this.addNewObjectToStateIfDynamic(eObj, newState);
                }
                boolean change = false;
                if (lastValue != null) {
                    if (lastValue.getReferenceValues().size() == values.size()) {
                        Iterator it = values.iterator();
                        for (EObject aPreviousValue : lastValue.getReferenceValues()) {
                            EObject aCurrentValue;
                            if (aPreviousValue == this.exeToTraced.get(aCurrentValue = (EObject)it.next())) continue;
                            change = true;
                            break;
                        }
                    } else {
                        change = true;
                    }
                } else {
                    change = true;
                }
                if (!change) continue;
                stateChanged = true;
                newState.getValues().remove((Object)lastValue);
                GenericValue newValue = this.getGenericValue(o, p, newState);
                dimension.getValues().add((Object)newValue);
                newState.getValues().add((Object)newValue);
            }
            if (stateChanged) {
                GenericStep currentStep = (GenericStep)this.context.peekFirst();
                if (currentStep != null && currentStep instanceof BigStep) {
                    GenericState startingState = this.lastState;
                    GenericState endingState = newState;
                    this.addImplicitStep((BigStep<GenericStep, GenericState>)((BigStep)currentStep), startingState, endingState);
                }
                this.lastState = newState;
                this.traceRoot.getStates().add((Object)this.lastState);
            } else if (this.copiedState) {
                newState.getValues().clear();
            }
            this.copiedState = false;
        }
    }

    private void addImplicitStep(BigStep<GenericStep, GenericState> currentStep, GenericState startingState, GenericState endingState) {
        GenericSmallStep implicitStep = GenerictraceFactory.eINSTANCE.createGenericSmallStep();
        implicitStep.setStartingState((State)startingState);
        implicitStep.setEndingState((State)endingState);
        currentStep.getSubSteps().add((Object)implicitStep);
    }

    public void addStep(Step<?> step) {
        GenericSequentialStep step_cast = null;
        if (step != null && step instanceof GenericSequentialStep) {
            step_cast = (GenericSequentialStep)step;
            if (this.mseModel == null) {
                this.mseModel = TraceFactory.eINSTANCE.createMSEModel();
                this.traceResource.getContents().add((Object)this.mseModel);
            }
            this.mseModel.getOwnedMSEs().add((Object)step_cast.getMseoccurrence().getMse());
            GenericState state = (GenericState)this.traceRoot.getStates().get(this.traceRoot.getStates().size() - 1);
            step_cast.setStartingState((State)state);
            if (!this.context.isEmpty() && this.context.getFirst() != null) {
                this.context.getFirst().getSubSteps().add((Object)step_cast);
            } else {
                ((GenericSequentialStep)this.traceRoot.getRootStep()).getSubSteps().add((Object)step_cast);
            }
        }
        this.context.push(step_cast);
    }

    public void endStep(Step<?> step) {
        GenericStep popped = (GenericStep)this.context.pop();
        if (popped != null) {
            popped.setEndingState((State)this.lastState);
        }
    }

    public EObject initTrace(LaunchConfiguration launchConfiguration) {
        this.traceRoot = GenerictraceFactory.eINSTANCE.createGenericTrace();
        this.traceRoot.setLaunchconfiguration(launchConfiguration);
        GenericSequentialStep rootStep = GenerictraceFactory.eINSTANCE.createGenericSequentialStep();
        this.traceRoot.setRootStep((Step)rootStep);
        this.traceResource.getContents().add(this.traceRoot);
        return this.traceRoot;
    }

    public void save() {
        try {
            this.traceResource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save(URI uri) {
        try {
            this.traceResource.setURI(uri);
            this.traceResource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isPartialTraceConstructor() {
        return false;
    }

    private static /* synthetic */ void lambda$4(List list, GenericDimension d) {
        boolean bl = list.remove(d.getValues().get(d.getValues().size() - 1));
    }
}

