/**
 * Copyright (c) 2016, 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.trace.metamodel.generator;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class TraceMMStrings {
  public final static String class_Trace = "SpecificTrace";
  
  public final static String class_State = "State";
  
  public final static String class_SpecificState = "SpecificState";
  
  public final static String class_TracedObject = "SpecificTracedObject";
  
  public final static String class_Dimension = "SpecificDimension";
  
  public final static String class_Value = "SpecificValue";
  
  public final static String class_AttributeValue = "SpecificAttributeValue";
  
  public final static String class_ReferenceValue = "SpecificReferenceValue";
  
  public final static String class_Step = "SpecificStep";
  
  public final static String class_RootStep = "SpecificRootStep";
  
  public final static String package_States = "States";
  
  public final static String package_Steps = "Steps";
  
  public final static String ref_Dimensions = "dimensions";
  
  public final static String ref_OriginalObject = "originalObject";
  
  public final static String ref_ValueToTrace = "parent";
  
  public final static String ref_ValueToStates = "statesRef";
  
  public final static String ref_TraceToStates = "statesTrace";
  
  public final static String ref_StateToStep_started = "startedStepsRef";
  
  public final static String ref_StateToStep_ended = "endedStepsRef";
  
  public final static String ref_StepToState_starting = "startingStateRef";
  
  public final static String ref_StepToState_ending = "endingStateRef";
  
  public static String class_createTraceClassName(final EClass runtimeClass) {
    String _name = runtimeClass.getName();
    return ("Traced" + _name);
  }
  
  public static String ref_createTraceClassToTracedClass(final EClass tracedClass) {
    EPackage _ePackage = tracedClass.getEPackage();
    String _name = _ePackage.getName();
    String _firstLower = StringExtensions.toFirstLower(_name);
    String _plus = (_firstLower + "_");
    String _name_1 = tracedClass.getName();
    String _firstLower_1 = StringExtensions.toFirstLower(_name_1);
    String _plus_1 = (_plus + _firstLower_1);
    return (_plus_1 + "s");
  }
  
  public static String class_createStateClassName(final EClass runtimeClass, final EStructuralFeature runtimeProperty) {
    String _name = runtimeClass.getName();
    String _plus = (_name + "_");
    String _name_1 = runtimeProperty.getName();
    String _plus_1 = (_plus + _name_1);
    return (_plus_1 + "_Value");
  }
  
  public static String class_createDimensionClassName(final EClass runtimeClass, final EStructuralFeature runtimeProperty) {
    String _name = runtimeClass.getName();
    String _plus = (_name + "_");
    String _name_1 = runtimeProperty.getName();
    String _plus_1 = (_plus + _name_1);
    return (_plus_1 + "_Dimension");
  }
  
  public static String ref_createTraceClassToValueClass(final EStructuralFeature runtimeProperty) {
    String _name = runtimeProperty.getName();
    return (_name + "Sequence");
  }
  
  public static String ref_createGlobalToState(final EClass stateClass) {
    String _name = stateClass.getName();
    String _firstLower = StringExtensions.toFirstLower(_name);
    return (_firstLower + "s");
  }
  
  public static String ref_createTraceClassToStepClass(final EClass stepClass) {
    String _name = stepClass.getName();
    return (_name + "_Sequence");
  }
  
  public static String package_createTracedPackage(final EPackage runtimePackage) {
    return runtimePackage.getName();
  }
  
  public static String ref_OriginalObject_MultipleInheritance(final EClass originalClass) {
    String _name = originalClass.getName();
    return ((TraceMMStrings.ref_OriginalObject + "_") + _name);
  }
}
