/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.site.SiteObject;
import org.w3c.dom.Node;

public class SiteCategory
extends SiteObject
implements ISiteCategory {
    private static final long serialVersionUID = 1L;
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return this.name != null;
    }

    @Override
    protected void parse(Node node) {
        this.name = this.getNodeAttribute(node, "name");
    }

    @Override
    protected void reset() {
        this.name = null;
    }

    @Override
    public void setName(String name) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChanged("name", oldValue, name);
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.print(indent);
        writer.print("<category");
        if (this.name != null) {
            writer.print(" name=\"" + SiteObject.getWritableString(this.name) + "\"");
        }
        writer.println("/>");
    }

    @Override
    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("name")) {
            this.setName(newValue != null ? newValue.toString() : null);
        } else {
            super.restoreProperty(name, oldValue, newValue);
        }
    }

    @Override
    public ISiteCategoryDefinition getDefinition() {
        ISiteCategoryDefinition[] definitions;
        ISite site = this.getSite();
        ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = definitions = site.getCategoryDefinitions();
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteCategoryDefinition def = iSiteCategoryDefinitionArray[n2];
            if (def.getName().equals(this.getName())) {
                return def;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append("{").append("name=").append(this.name).append("}");
        return builder.toString();
    }
}

