/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.wizards.ctxhelp;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpContext;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpModel;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpObject;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpTopic;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.wizards.ctxhelp.CtxWizardMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewCtxHelpOperation
extends WorkspaceModifyOperation {
    private IFile fFile;

    public NewCtxHelpOperation(IFile file) {
        this.fFile = file;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        CtxHelpModel model = new CtxHelpModel((IDocument)CoreUtility.getTextDocument((InputStream)this.fFile.getContents()), false);
        model.setUnderlyingResource((IResource)this.fFile);
        this.initializeModel(model);
        model.save();
        model.dispose();
        this.openFile();
        monitor.done();
    }

    private void initializeModel(CtxHelpModel model) {
        CtxHelpContext context = model.getFactory().createContext();
        context.setID(CtxWizardMessages.NewCtxHelpOperation_context);
        model.getCtxHelpRoot().addChild((CtxHelpObject)context);
        CtxHelpTopic topic = model.getFactory().createTopic();
        topic.setLabel(CtxWizardMessages.NewCtxHelpOperation_topic);
        context.addChild((CtxHelpObject)topic);
    }

    protected void openFile() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow ww = PDEUserAssistanceUIPlugin.getActiveWorkbenchWindow();
                if (ww == null) {
                    return;
                }
                IWorkbenchPage page = ww.getActivePage();
                if (page == null || !NewCtxHelpOperation.this.fFile.exists()) {
                    return;
                }
                IWorkbenchPart focusPart = page.getActivePart();
                if (focusPart instanceof ISetSelectionTarget) {
                    StructuredSelection selection = new StructuredSelection((Object)NewCtxHelpOperation.this.fFile);
                    ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                }
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)NewCtxHelpOperation.this.fFile, (String)"org.eclipse.pde.ua.ui.ctxHelpEditor");
                }
                catch (PartInitException partInitException) {}
            }
        });
    }
}

