/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.parts.PluginVersionPart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.ContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.FragmentFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.framework.Version;

public class FragmentContentPage
extends ContentPage {
    private Text fPluginIdText_newV;
    private Text fPluginIdText_oldV;
    private Text fPluginVersion;
    private Combo fMatchCombo;
    private boolean fNewVersion;
    private Composite fNotebook;
    private StackLayout fNotebookLayout;
    private Composite fOldComp;
    private Composite fNewComp;
    private PluginVersionPart fVersionPart;
    private Label fEELabel;
    private Button fExeEnvButton;
    private Combo fEEChoice;
    private static final String NO_EXECUTION_ENVIRONMENT = PDEUIMessages.PluginContentPage_noEE;
    protected ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            FragmentContentPage.this.validatePage();
        }
    };

    public FragmentContentPage(String pageName, IProjectProvider provider, NewProjectCreationPage page, AbstractFieldData data) {
        super(pageName, provider, page, data);
        this.setTitle(PDEUIMessages.ContentPage_ftitle);
        this.setDescription(PDEUIMessages.ContentPage_fdesc);
        this.updateVersion(false);
        this.fVersionPart = new PluginVersionPart(this.fNewVersion);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        this.createFragmentPropertiesGroup(container);
        this.createParentPluginGroup(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.new_fragment_required_data");
    }

    private void createFragmentPropertiesGroup(Composite container) {
        Group propertiesGroup = new Group(container, 0);
        propertiesGroup.setLayout((Layout)new GridLayout(3, false));
        propertiesGroup.setLayoutData((Object)new GridData(768));
        propertiesGroup.setText(PDEUIMessages.ContentPage_fGroup);
        Label label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_fid);
        this.fIdText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_fversion);
        this.fVersionText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_fname);
        this.fNameText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_fprovider);
        this.fProviderCombo = this.createProviderCombo((Composite)propertiesGroup, this.propertiesListener, 2);
        this.createExecutionEnvironmentControls((Composite)propertiesGroup);
    }

    private void createParentPluginGroup(Composite container) {
        Group parentGroup = new Group(container, 0);
        parentGroup.setLayout((Layout)new GridLayout(2, false));
        parentGroup.setLayoutData((Object)new GridData(768));
        parentGroup.setText(PDEUIMessages.ContentPage_parentPluginGroup);
        this.fNotebook = new Composite((Composite)parentGroup, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.fNotebook.setLayoutData((Object)gd);
        this.fNotebookLayout = new StackLayout();
        this.fNotebook.setLayout((Layout)this.fNotebookLayout);
        this.fNewComp = this.createNewVersionComp(this.fNotebook);
        this.fOldComp = this.createOldVersionComp(this.fNotebook);
        this.fNotebookLayout.topControl = this.fNewVersion ? this.fNewComp : this.fOldComp;
    }

    private Composite createNewVersionComp(Composite notebook) {
        Composite comp = new Composite(notebook, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText(PDEUIMessages.FragmentContentPage_pid);
        this.fPluginIdText_newV = this.createPluginIdContainer(comp, true, 2);
        this.fVersionPart.createVersionFields(comp, false, true);
        this.fVersionPart.addListeners(this.listener, this.listener);
        return comp;
    }

    private Composite createOldVersionComp(Composite notebook) {
        Composite comp = new Composite(notebook, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText(PDEUIMessages.FragmentContentPage_pid);
        Composite container = new Composite(comp, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.fPluginIdText_oldV = this.createPluginIdContainer(container, false, 1);
        label = new Label(comp, 0);
        label.setText(PDEUIMessages.FragmentContentPage_pversion);
        this.fPluginVersion = this.createText(comp, this.listener);
        label = new Label(comp, 0);
        label.setText(PDEUIMessages.ContentPage_matchRule);
        this.fMatchCombo = new Combo(comp, 2056);
        this.fMatchCombo.setLayoutData((Object)new GridData(768));
        this.fMatchCombo.setItems(new String[]{"", PDEUIMessages.ManifestEditor_MatchSection_equivalent, PDEUIMessages.ManifestEditor_MatchSection_compatible, PDEUIMessages.ManifestEditor_MatchSection_perfect, PDEUIMessages.ManifestEditor_MatchSection_greater});
        this.fMatchCombo.setText(this.fMatchCombo.getItem(0));
        return comp;
    }

    private void createExecutionEnvironmentControls(Composite container) {
        this.fEELabel = new Label(container, 0);
        this.fEELabel.setText(PDEUIMessages.NewProjectCreationPage_executionEnvironments_label);
        this.fEEChoice = new Combo(container, 2060);
        this.fEEChoice.setLayoutData((Object)new GridData(768));
        IExecutionEnvironment[] exeEnvs = VMUtil.getExecutionEnvironments();
        TreeSet<String> availableEEs = new TreeSet<String>();
        IExecutionEnvironment[] iExecutionEnvironmentArray = exeEnvs;
        int n = exeEnvs.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment exeEnv = iExecutionEnvironmentArray[n2];
            availableEEs.add(exeEnv.getId());
            ++n2;
        }
        availableEEs.add(NO_EXECUTION_ENVIRONMENT);
        this.fEEChoice.setItems(availableEEs.toArray(new String[availableEEs.size() - 1]));
        this.fEEChoice.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.validatePage()));
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        String[] EEChoices = this.fEEChoice.getItems();
        int i = 0;
        while (i < EEChoices.length) {
            if (!EEChoices[i].equals(NO_EXECUTION_ENVIRONMENT) && VMUtil.getExecutionEnvironment((String)EEChoices[i]).isStrictlyCompatible(defaultVM)) {
                this.fEEChoice.select(i);
                break;
            }
            ++i;
        }
        this.fExeEnvButton = new Button(container, 8);
        this.fExeEnvButton.setLayoutData((Object)new GridData());
        this.fExeEnvButton.setText(PDEUIMessages.NewProjectCreationPage_environmentsButton);
        this.fExeEnvButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)FragmentContentPage.this.getShell(), (String)"org.eclipse.jdt.debug.ui.jreProfiles", (String[])new String[]{"org.eclipse.jdt.debug.ui.jreProfiles"}, null).open();
            }
        });
    }

    private Text createPluginIdContainer(Composite parent, final boolean validateRange, int span) {
        final Text pluginText = this.createText(parent, this.listener);
        Button browse = new Button(parent, 8);
        browse.setText(PDEUIMessages.ContentPage_browse);
        browse.setLayoutData((Object)new GridData());
        browse.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (!PDECore.getDefault().areModelsInitialized()) {
                try {
                    this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            PDECore.getDefault().getModelManager().targetReloaded(monitor);
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
            BusyIndicator.showWhile((Display)pluginText.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    PluginSelectionDialog dialog = new PluginSelectionDialog(pluginText.getShell(), false, false);
                    dialog.create();
                    if (dialog.open() == 0) {
                        IPluginModel model = (IPluginModel)dialog.getFirstResult();
                        IPlugin plugin = model.getPlugin();
                        String version = FragmentContentPage.this.computeInitialPluginVersion(plugin.getVersion());
                        if (validateRange) {
                            FragmentContentPage.this.fVersionPart.setVersion(version);
                            FragmentContentPage.this.fVersionPart.preloadFields();
                        } else {
                            FragmentContentPage.this.fPluginVersion.setText(version);
                        }
                        pluginText.setText(plugin.getId());
                    }
                }
            });
        }));
        SWTUtil.setButtonDimensionHint(browse);
        return pluginText;
    }

    private String computeInitialPluginVersion(String pluginVersion) {
        if (pluginVersion != null && VersionUtil.validateVersion((String)pluginVersion).isOK()) {
            Version pvi = Version.parseVersion((String)pluginVersion);
            return String.valueOf(pvi.getMajor()) + "." + pvi.getMinor() + "." + pvi.getMicro();
        }
        return pluginVersion;
    }

    @Override
    public void updateData() {
        String version;
        super.updateData();
        if (this.fNewVersion) {
            version = this.fVersionPart.getVersion();
            ((FragmentFieldData)this.fData).setPluginId(this.fPluginIdText_newV.getText().trim());
        } else {
            version = this.fPluginVersion.getText().trim();
            ((FragmentFieldData)this.fData).setPluginId(this.fPluginIdText_oldV.getText().trim());
            ((FragmentFieldData)this.fData).setMatch(this.fMatchCombo.getSelectionIndex());
        }
        if (this.fEEChoice.isEnabled() && !this.fEEChoice.getText().equals(NO_EXECUTION_ENVIRONMENT)) {
            this.fData.setExecutionEnvironment(this.fEEChoice.getText().trim());
        } else {
            this.fData.setExecutionEnvironment(null);
        }
        ((FragmentFieldData)this.fData).setPluginVersion(version);
    }

    @Override
    protected void validatePage() {
        String errorMessage = this.validateProperties();
        String warningMessage = null;
        if (errorMessage == null) {
            String pluginID;
            String string = pluginID = this.fNewVersion ? this.fPluginIdText_newV.getText().trim() : this.fPluginIdText_oldV.getText().trim();
            if (pluginID.length() == 0) {
                errorMessage = PDEUIMessages.ContentPage_nopid;
            } else {
                if (!PDECore.getDefault().areModelsInitialized()) {
                    try {
                        this.getContainer().run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                PDECore.getDefault().getModelManager().targetReloaded(monitor);
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!(PluginRegistry.findModel((String)pluginID) instanceof IPluginModel)) {
                    warningMessage = PDEUIMessages.ContentPage_pluginNotFound;
                } else if (this.fNewVersion) {
                    IStatus status = this.fVersionPart.validateFullVersionRangeText(false);
                    if (status.getSeverity() != 0) {
                        errorMessage = status.getMessage();
                    }
                } else {
                    errorMessage = this.validateVersion(this.fPluginVersion);
                }
            }
        }
        if (errorMessage == null && warningMessage == null) {
            IExecutionEnvironment ee;
            String eeid = this.fEEChoice.getText();
            if (this.fEEChoice.isEnabled() && (ee = VMUtil.getExecutionEnvironment((String)eeid)) != null && ee.getCompatibleVMs().length == 0) {
                warningMessage = PDEUIMessages.NewProjectCreationPage_invalidEE;
            }
        }
        if (this.fInitialized) {
            this.setErrorMessage(errorMessage);
            this.setMessage(warningMessage, 2);
        }
        this.setPageComplete(errorMessage == null);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.fMainPage.updateData();
            this.updateVersion(true);
        }
        super.setVisible(visible);
    }

    private void updateVersion(boolean updateComposite) {
        boolean bl = this.fNewVersion = Double.parseDouble(this.fData.getTargetVersion()) > 3.0;
        if (updateComposite) {
            Control oldPage = this.fNotebookLayout.topControl;
            this.fNotebookLayout.topControl = this.fNewVersion ? this.fNewComp : this.fOldComp;
            if (oldPage != this.fNotebookLayout.topControl) {
                this.fNotebook.layout();
            }
        }
    }
}

