/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.helper.task.DeleteEObjectTask;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.UnexecutableTask;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.internal.helper.task.DeleteDRepresentationElementsTask;
import org.eclipse.sirius.business.internal.helper.task.DeleteDRepresentationTask;
import org.eclipse.sirius.business.internal.helper.task.DeleteWithoutToolTask;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.tool.DeleteElementDescription;
import org.eclipse.sirius.diagram.tools.internal.command.builders.AbstractDiagramCommandBuilder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.NoNullResourceCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.internal.command.builders.ElementsToSelectTask;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class DeletionCommandBuilder
extends AbstractDiagramCommandBuilder {
    private DDiagram diagram;
    private DDiagramElement diagramElement;
    private DeleteElementDescription tool;
    private boolean deleteFromDiagram;

    public DeletionCommandBuilder() {
    }

    public DeletionCommandBuilder(DDiagram diagram) {
        this.diagram = diagram;
    }

    public DeletionCommandBuilder(DDiagramElement diagramElement, boolean deleteFromDiagram) {
        this.diagramElement = diagramElement;
        this.deleteFromDiagram = deleteFromDiagram;
    }

    public Command buildCommand() {
        UnexecutableCommand command = UnexecutableCommand.INSTANCE;
        if (this.diagram != null) {
            command = this.buildDeleteDiagram();
        } else if (this.diagramElement != null) {
            command = this.deleteFromDiagram ? this.buildDeleteDiagramElementFromDiagram() : this.buildDeleteDiagramElement();
        }
        return command;
    }

    private Command buildDeleteDiagram() {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        if (this.permissionAuthority.canDeleteInstance((EObject)this.diagram)) {
            DCommand vpCmd = this.createEnclosingCommand();
            vpCmd.getTasks().add(new DeleteDRepresentationTask((DRepresentation)this.diagram));
            cmd = vpCmd;
        }
        return cmd;
    }

    private Command buildDeleteDiagramElementFromDiagram() {
        if (this.permissionAuthority.canDeleteInstance((EObject)this.diagramElement)) {
            DCommand cmd = this.createEnclosingCommand();
            cmd.getTasks().add(new DeleteEObjectTask((EObject)this.diagramElement, this.modelAccessor));
            ArrayList contents = Lists.newArrayList((Iterable)this.modelAccessor.eAllContents((EObject)this.diagramElement, "EdgeTarget"));
            contents.add(this.diagramElement);
            for (EObject element : contents) {
                if (!(element instanceof EdgeTarget)) continue;
                EdgeTarget target = (EdgeTarget)element;
                for (DEdge edge : Iterables.concat(target.getIncomingEdges(), target.getOutgoingEdges())) {
                    cmd.getTasks().add(new DeleteEObjectTask((EObject)edge, this.modelAccessor));
                }
            }
            return cmd;
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command buildDeleteDiagramElement() {
        Set<EObject> semanticElements;
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        this.setTool();
        if ((this.tool == null || this.isDeleteAllowedByTool()) && this.permissionAuthority.canDeleteInstance((EObject)this.diagramElement) && (semanticElements = this.getRootSemanticElementsToDestroy(this.diagramElement)) != null) {
            DCommand result = this.createEnclosingCommand();
            if (this.tool != null) {
                this.addDeleteDiagramElementFromTool(result);
                this.addRefreshTask(this.diagramElement, result, (AbstractToolDescription)this.tool);
                Option<DDiagram> parentDiagram = new EObjectQuery((EObject)this.diagramElement).getParentDiagram();
                result.getTasks().add(new ElementsToSelectTask((AbstractToolDescription)this.tool, InterpreterUtil.getInterpreter((EObject)this.diagramElement), this.diagramElement.getTarget(), (DRepresentation)parentDiagram.get()));
                cmd = new NoNullResourceCommand((Command)result, (EObject)this.diagramElement);
            } else {
                cmd = this.buildDeleteDiagramElementCommandWithoutTool(result, semanticElements);
            }
        }
        return cmd;
    }

    private void setTool() {
        DiagramElementMapping mapping = null;
        mapping = this.diagramElement.getDiagramElementMapping();
        if (mapping != null) {
            this.tool = mapping.getDeletionDescription();
        }
    }

    private void addDeleteDiagramElementFromTool(DCommand cmd) {
        Option<EdgeMapping> edgeMapping;
        EObject semanticContainer = this.diagramElement.getTarget();
        EObject viewContainer = this.diagramElement.eContainer();
        cmd.getTasks().addAll(this.buildDeleteFromToolTask(semanticContainer, viewContainer).getTasks());
        cmd.getTasks().add(new DeleteDRepresentationElementsTask(this.modelAccessor, cmd, this.taskHelper, this.diagramElement){

            protected void addDialectSpecificAdditionalDeleteSubTasks(DSemanticDecorator decorator, List<ICommandTask> subTasks) {
                if (decorator instanceof EdgeTarget) {
                    EdgeTarget edgeTarget = (EdgeTarget)decorator;
                    for (DEdge edge : Iterables.concat(edgeTarget.getIncomingEdges(), edgeTarget.getOutgoingEdges())) {
                        subTasks.add((ICommandTask)new DeleteEObjectTask((EObject)edge, DeletionCommandBuilder.this.modelAccessor));
                    }
                }
            }
        });
        if (this.diagramElement instanceof DEdge && (edgeMapping = new IEdgeMappingQuery(((DEdge)this.diagramElement).getActualMapping()).getEdgeMapping()).some() && !((EdgeMapping)edgeMapping.get()).isUseDomainElement()) {
            cmd.getTasks().add(new DeleteEObjectTask((EObject)this.diagramElement, this.modelAccessor));
        }
    }

    private boolean isDeleteAllowedByTool() {
        EObject semanticContainer = this.diagramElement.getTarget();
        EObject viewContainer = this.diagramElement.eContainer();
        boolean delete = true;
        if (this.tool.getPrecondition() != null && !StringUtil.isEmpty((String)this.tool.getPrecondition().trim())) {
            delete = false;
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)this.diagramElement);
            interpreter.setVariable("containerView", (Object)viewContainer);
            interpreter.setVariable("view", (Object)this.diagramElement);
            interpreter.setVariable("element", (Object)semanticContainer);
            try {
                delete = interpreter.evaluateBoolean(semanticContainer, this.tool.getPrecondition());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)this.tool, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
            }
            interpreter.unSetVariable("containerView");
            interpreter.unSetVariable("view");
            interpreter.unSetVariable("element");
        }
        return delete;
    }

    private DCommand buildDeleteFromToolTask(EObject deletedSemanticElement, EObject containerView) {
        DCommand result = this.createEnclosingCommand();
        if (this.permissionAuthority.canEditInstance(containerView)) {
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)deletedSemanticElement);
            HashMap<Object, Object> variables = new HashMap<Object, Object>();
            result.getTasks().add(new InitInterpreterVariablesTask(variables, interpreter, this.uiCallback));
            variables.put(this.tool.getContainerView(), containerView);
            variables.put(this.tool.getElement(), deletedSemanticElement);
            variables.put(this.tool.getElementView(), this.diagramElement);
            this.addDiagramVariable(result, containerView, interpreter);
            Option<DDiagram> parentDiagram = new EObjectQuery(containerView).getParentDiagram();
            if (this.tool.getInitialOperation() != null && this.tool.getInitialOperation().getFirstModelOperations() != null) {
                result.getTasks().add(this.taskHelper.buildTaskFromModelOperation((DRepresentation)parentDiagram.get(), deletedSemanticElement, this.tool.getInitialOperation().getFirstModelOperations()));
            }
        } else {
            result.getTasks().add(UnexecutableTask.INSTANCE);
        }
        return result;
    }

    private Command buildDeleteDiagramElementCommandWithoutTool(DCommand result, Set<EObject> semanticElements) {
        DCommand cmd;
        if (semanticElements.isEmpty()) {
            cmd = result;
        } else {
            DeleteWithoutToolTask deleteWithoutToolTask = new DeleteWithoutToolTask(this.diagramElement, semanticElements, this.modelAccessor, this.taskHelper){

                protected void addDialectSpecificAdditionalDeleteSubTasks(DSemanticDecorator decorator, List<ICommandTask> subTasks) {
                    if (decorator instanceof EdgeTarget) {
                        EdgeTarget edgeTarget = (EdgeTarget)decorator;
                        for (DEdge edge : Iterables.concat(edgeTarget.getIncomingEdges(), edgeTarget.getOutgoingEdges())) {
                            subTasks.add((ICommandTask)new DeleteEObjectTask((EObject)edge, DeletionCommandBuilder.this.modelAccessor));
                        }
                    }
                }
            };
            result.getTasks().add(deleteWithoutToolTask);
            this.addRefreshTask(this.diagramElement, result, (AbstractToolDescription)this.tool);
            cmd = new NoNullResourceCommand((Command)result, (EObject)this.diagramElement);
        }
        return cmd;
    }

    private Set<EObject> getRootSemanticElementsToDestroy(DDiagramElement currentDiagramElement) {
        LinkedHashSet elementsToDestroy = Sets.newLinkedHashSet();
        boolean canDelete = this.appendRootSemanticElementsToDestroy(currentDiagramElement, elementsToDestroy);
        return canDelete ? elementsToDestroy : null;
    }

    private boolean appendRootSemanticElementsToDestroy(DDiagramElement currentDiagramElement, Set<EObject> elementsToDestroy) {
        boolean canDelete = true;
        for (EObject semantic : currentDiagramElement.getSemanticElements()) {
            if (semantic == null || EcoreUtil.isAncestor(elementsToDestroy, (EObject)semantic)) continue;
            if (!this.permissionAuthority.canDeleteInstance(semantic)) {
                canDelete = false;
                break;
            }
            elementsToDestroy.add(semantic);
        }
        if (canDelete) {
            for (EObject child : currentDiagramElement.eContents()) {
                if (!(child instanceof DDiagramElement) || this.appendRootSemanticElementsToDestroy((DDiagramElement)child, elementsToDestroy)) continue;
                canDelete = false;
                break;
            }
        }
        return canDelete;
    }

    protected String getEnclosingCommandLabel() {
        String commandLabel = Messages.DeletionCommandBuilder_deleteLabel;
        if (this.diagram != null) {
            commandLabel = Messages.DeletionCommandBuilder_deleteDiagramLabel;
        } else if (this.diagramElement != null) {
            commandLabel = this.deleteFromDiagram ? Messages.DeletionCommandBuilder_deleteFromDiagramLabel : (this.tool == null ? Messages.DeletionCommandBuilder_deleteFromModelLabel : new IdentifiedElementQuery((IdentifiedElement)this.tool).getLabel());
        }
        return commandLabel;
    }

    @Override
    protected Option<DDiagram> getDDiagram() {
        if (this.diagram == null && this.diagramElement != null) {
            return Options.newSome((Object)this.diagramElement.getParentDiagram());
        }
        return Options.newSome((Object)this.diagram);
    }
}

