/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.contribution;

import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.description.contribution.ContributionFactory;
import org.eclipse.sirius.description.contribution.ContributionPoint;

public final class ContributionPointHelper {
    private ContributionPointHelper() {
    }

    public static ContributionPoint make(EObject point, String origin) {
        ContributionPoint cp = ContributionFactory.eINSTANCE.createContributionPoint();
        cp.setContributed(point);
        cp.setOrigin(origin);
        return cp;
    }

    public static void updateIfNeeded(EList<ContributionPoint> originalPoints, List<ContributionPoint> newPoints) {
        if (!ContributionPointHelper.sameContributions(originalPoints, newPoints)) {
            originalPoints.clear();
            originalPoints.addAll(newPoints);
        }
    }

    private static boolean sameContributions(EList<ContributionPoint> contributionPoints, List<ContributionPoint> newPoints) {
        boolean result = true;
        if (contributionPoints.size() != newPoints.size()) {
            result = false;
        } else {
            int i = 0;
            while (i < contributionPoints.size()) {
                ContributionPoint newPoint;
                ContributionPoint oldPoint = (ContributionPoint)contributionPoints.get(i);
                if (!ContributionPointHelper.sameContribution(oldPoint, newPoint = newPoints.get(i))) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private static boolean sameContribution(ContributionPoint oldPoint, ContributionPoint newPoint) {
        return Objects.equal((Object)oldPoint.getContributed(), (Object)newPoint.getContributed()) && Objects.equal((Object)oldPoint.getOrigin(), (Object)newPoint.getOrigin());
    }
}

