/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.quickoutline;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.IContentSelectionProvider;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.filter.StringMatcher;
import org.eclipse.wst.sse.ui.internal.quickoutline.StringPatternFilter;
import org.eclipse.wst.sse.ui.quickoutline.AbstractQuickOutlineConfiguration;

public class QuickOutlinePopupDialog
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private static final String DIALOG_SECTION = "org.eclipse.wst.sse.ui.quick_outline";
    private Text fFilterText;
    private TreeViewer fTreeViewer;
    private IStructuredModel fModel;
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;
    private IContentSelectionProvider fSelectionProvider;
    private StringPatternFilter fFilter;
    static /* synthetic */ Class class$0;

    public QuickOutlinePopupDialog(Shell parent, int shellStyle, IStructuredModel model, AbstractQuickOutlineConfiguration configuration) {
        super(parent, shellStyle, true, true, true, true, true, null, null);
        this.fContentProvider = configuration.getContentProvider();
        this.fLabelProvider = configuration.getLabelProvider();
        this.fSelectionProvider = configuration.getContentSelectionProvider();
        this.fModel = model;
        this.create();
    }

    protected Control createDialogArea(Composite parent) {
        this.createTreeViewer(parent, 768);
        this.addListeners(this.fTreeViewer.getTree());
        this.installFilter();
        return this.fTreeViewer.getControl();
    }

    protected Control createTitleControl(Composite parent) {
        this.createFilterText(parent);
        return this.fFilterText;
    }

    protected void createTreeViewer(Composite parent, int style) {
        Tree tree = new Tree(parent, style);
        GridData gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 12;
        tree.setLayoutData((Object)gd);
        this.fTreeViewer = new TreeViewer(tree);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fTreeViewer.setAutoExpandLevel(2);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setInput((Object)this.fModel);
    }

    protected void createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        Dialog.applyDialogFont((Control)this.fFilterText);
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    QuickOutlinePopupDialog.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    QuickOutlinePopupDialog.this.fTreeViewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    QuickOutlinePopupDialog.this.fTreeViewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    QuickOutlinePopupDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    protected void installFilter() {
        this.fFilter = new StringPatternFilter();
        this.fTreeViewer.addFilter((ViewerFilter)this.fFilter);
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                int length = text.length();
                if (length > 0 && text.charAt(length - 1) != '*') {
                    text = String.valueOf(text) + '*';
                }
                QuickOutlinePopupDialog.this.setMatcherString(text, true);
            }
        });
    }

    protected void setMatcherString(String pattern, boolean update) {
        this.fFilter.updatePattern(pattern);
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    protected void stringMatcherUpdated() {
        this.fTreeViewer.getControl().setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
        this.selectFirstMatch();
        this.fTreeViewer.getControl().setRedraw(true);
    }

    private void selectFirstMatch() {
        TreeItem item = this.findItem(this.fTreeViewer.getTree().getItems(), this.fFilter.getStringMatcher());
        if (item != null) {
            this.fTreeViewer.getTree().setSelection(item);
        } else {
            this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private TreeItem findItem(TreeItem[] items, StringMatcher matcher) {
        if (matcher == null) {
            return items.length > 0 ? items[0] : null;
        }
        int length = items.length;
        TreeItem result = null;
        int i = 0;
        while (i < length) {
            if (matcher.match(items[i].getText())) {
                return items[i];
            }
            if (items[i].getItemCount() > 0 && (result = this.findItem(items[i].getItems(), matcher)) != null) {
                return result;
            }
            ++i;
        }
        return result;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = SSEUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SECTION);
        if (settings == null) {
            settings = SSEUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SECTION);
        }
        return settings;
    }

    private void gotoSelectedElement() {
        ITextEditor editor;
        Object element = this.getSelectedElement();
        this.dispose();
        if (element != null && (editor = this.getActiveTextEditor()) != null) {
            editor.selectAndReveal(((IndexedRegion)element).getStartOffset(), ((IndexedRegion)element).getEndOffset() - ((IndexedRegion)element).getStartOffset());
        }
    }

    private ITextEditor getActiveTextEditor() {
        IWorkbenchWindow ww;
        IWorkbenchPage page;
        IWorkbench wb = PlatformUI.getWorkbench();
        ITextEditor editor = null;
        if (wb != null && (page = (ww = wb.getActiveWorkbenchWindow()).getActivePage()) != null) {
            IEditorPart part = page.getActiveEditor();
            if (part instanceof ITextEditor) {
                editor = (ITextEditor)part;
            } else {
                ITextEditor iTextEditor;
                if (part != null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iTextEditor = (ITextEditor)part.getAdapter((Class)clazz);
                } else {
                    iTextEditor = null;
                }
                editor = iTextEditor;
            }
        }
        return editor;
    }

    private Object getSelectedElement() {
        if (this.fTreeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
    }

    private void addListeners(final Tree tree) {
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    QuickOutlinePopupDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickOutlinePopupDialog.this.gotoSelectedElement();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                TreeItem o;
                if (tree.equals(e.getSource()) && (o = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem) {
                    Rectangle clientArea = tree.getClientArea();
                    if (!o.equals(this.fLastItem)) {
                        this.fLastItem = o;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (e.y - clientArea.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = QuickOutlinePopupDialog.this.fTreeViewer.scrollUp(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (clientArea.y + clientArea.height - e.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = QuickOutlinePopupDialog.this.fTreeViewer.scrollDown(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        QuickOutlinePopupDialog.this.gotoSelectedElement();
                    }
                }
            }
        });
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void dispose() {
        this.close();
    }

    public boolean isFocusControl() {
        return this.getShell().getDisplay().getActiveShell() == this.getShell();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.fFilterText.setFocus();
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setInformation(String information) {
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public boolean hasContents() {
        return this.fTreeViewer != null && this.fTreeViewer.getInput() != null;
    }

    public void setInput(Object input) {
        if (!(input instanceof ISelection)) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(input));
        } else if (this.fSelectionProvider != null) {
            ISelection selection = this.fSelectionProvider.getSelection(this.fTreeViewer, (ISelection)input);
            this.fTreeViewer.setSelection(selection);
        } else {
            this.fTreeViewer.setSelection((ISelection)input);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.fTreeViewer = null;
        this.fFilterText = null;
        this.fModel = null;
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
    }
}

