/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.generator;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtext.generator.AbstractStubGeneratingFragment;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.model.FileAccessFactory;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.ManifestAccess;
import org.eclipse.xtext.xtext.generator.model.PluginXmlAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.xbase.XbaseUsageDetector;

public class GeneratorFragment2
extends AbstractStubGeneratingFragment {
    @Inject
    private CodeConfig codeConfig;
    @Inject
    private FileAccessFactory fileAccessFactory;
    @Inject
    @Extension
    private XtextGeneratorNaming _xtextGeneratorNaming;
    @Inject
    @Extension
    private XbaseUsageDetector _xbaseUsageDetector;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean generateMwe = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean generateJavaMain = false;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean generateXtendMain = false;

    @Override
    public boolean isGenerateStub() {
        return !this._xbaseUsageDetector.inheritsXbase(this.getGrammar()) && super.isGenerateStub();
    }

    public boolean isGenerateJavaMain() {
        return !this._xbaseUsageDetector.inheritsXbase(this.getGrammar()) && this.generateJavaMain;
    }

    public boolean isGenerateXtendMain() {
        return !this._xbaseUsageDetector.inheritsXbase(this.getGrammar()) && this.generateXtendMain;
    }

    public boolean isGenerateMwe() {
        return !this._xbaseUsageDetector.inheritsXbase(this.getGrammar()) && this.generateMwe;
    }

    protected TypeReference getGeneratorStub(Grammar grammar) {
        String _runtimeBasePackage = this._xtextGeneratorNaming.getRuntimeBasePackage(grammar);
        String _plus = _runtimeBasePackage + ".generator.";
        String _simpleName = GrammarUtil.getSimpleName((Grammar)grammar);
        String _plus_1 = _plus + _simpleName;
        String _plus_2 = _plus_1 + "Generator";
        return new TypeReference(_plus_2);
    }

    protected TypeReference getJavaMain(Grammar grammar) {
        String _packageName = this.getGeneratorStub(grammar).getPackageName();
        String _plus = _packageName + ".Main";
        return new TypeReference(_plus);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        if (this.generateJavaMain && this.generateXtendMain) {
            issues.addWarning("Options 'generateJavaMain' and 'generateXtendMain' are mutually exclusive. Generating Xtend only.", this);
            this.generateJavaMain = false;
        }
    }

    @Override
    public void generate() {
        PluginXmlAccess _pluginXml;
        boolean _tripleNotEquals_3;
        boolean _tripleNotEquals_2;
        boolean _isGenerateMwe;
        boolean _isGenerateXtendMain;
        boolean _isGenerateJavaMain;
        boolean _isGenerateStub = this.isGenerateStub();
        if (_isGenerateStub) {
            boolean _isGenerateXtendStub;
            boolean _tripleNotEquals;
            new GuiceModuleAccess.BindingFactory().addTypeToType(TypeReference.typeRef(IGenerator2.class, new TypeReference[0]), this.getGeneratorStub(this.getLanguage().getGrammar())).contributeTo(this.getLanguage().getRuntimeGenModule());
            ManifestAccess _manifest = this.getProjectConfig().getRuntime().getManifest();
            boolean bl = _tripleNotEquals = _manifest != null;
            if (_tripleNotEquals) {
                Set<String> _requiredBundles = this.getProjectConfig().getRuntime().getManifest().getRequiredBundles();
                _requiredBundles.add("org.eclipse.xtext.xbase.lib");
            }
            if (_isGenerateXtendStub = this.isGenerateXtendStub()) {
                this.doGenerateXtendStubFile();
            } else {
                this.doGenerateJavaStubFile();
            }
        }
        if (this.isGenerateStub() || this.isGenerateJavaMain()) {
            boolean _tripleNotEquals_1;
            ManifestAccess _manifest_1 = this.getProjectConfig().getRuntime().getManifest();
            boolean bl = _tripleNotEquals_1 = _manifest_1 != null;
            if (_tripleNotEquals_1) {
                Set<String> _exportedPackages = this.getProjectConfig().getRuntime().getManifest().getExportedPackages();
                String _packageName = this.getGeneratorStub(this.getLanguage().getGrammar()).getPackageName();
                _exportedPackages.add(_packageName);
            }
        }
        if (_isGenerateJavaMain = this.isGenerateJavaMain()) {
            this.doGenerateJavaMain();
        }
        if (_isGenerateXtendMain = this.isGenerateXtendMain()) {
            this.doGenerateXtendMain();
        }
        if (_isGenerateMwe = this.isGenerateMwe()) {
            this.doGenerateMweFile();
        }
        this.contributeEclipsePluginGuiceBindings();
        ManifestAccess _manifest_2 = this.getProjectConfig().getEclipsePlugin().getManifest();
        boolean bl = _tripleNotEquals_2 = _manifest_2 != null;
        if (_tripleNotEquals_2) {
            Set<String> _requiredBundles_1 = this.getProjectConfig().getEclipsePlugin().getManifest().getRequiredBundles();
            _requiredBundles_1.add("org.eclipse.xtext.builder");
        }
        boolean bl2 = _tripleNotEquals_3 = (_pluginXml = this.getProjectConfig().getEclipsePlugin().getPluginXml()) != null;
        if (_tripleNotEquals_3) {
            this.contributeEclipsePluginExtensions();
        }
    }

    protected void contributeEclipsePluginGuiceBindings() {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        StringConcatenationClient expression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                TypeReference _typeRef = TypeReference.typeRef("org.eclipse.core.resources.ResourcesPlugin", new TypeReference[0]);
                _builder.append((Object)_typeRef);
                _builder.append((Object)".getWorkspace().getRoot()");
            }
        };
        StringConcatenationClient statement = _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"binder.bind(");
                TypeReference _typeRef = TypeReference.typeRef("org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer", new TypeReference[0]);
                _builder.append((Object)_typeRef);
                _builder.append((Object)".class)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)".annotatedWith(");
                _builder.append(Names.class, "\t");
                _builder.append((Object)".named(\"builderPreferenceInitializer\"))");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)".to(");
                TypeReference _typeReference = new TypeReference("org.eclipse.xtext.builder.preferences", "BuilderPreferenceAccess.Initializer");
                _builder.append((Object)_typeReference, "\t");
                _builder.append((Object)".class);");
                _builder.newLineIfNotEmpty();
            }
        };
        new GuiceModuleAccess.BindingFactory().addTypeToType(TypeReference.typeRef("org.eclipse.xtext.builder.IXtextBuilderParticipant", new TypeReference[0]), TypeReference.typeRef("org.eclipse.xtext.builder.BuilderParticipant", new TypeReference[0])).addTypeToInstance(TypeReference.typeRef("org.eclipse.core.resources.IWorkspaceRoot", new TypeReference[0]), expression).addConfiguredBinding("BuilderPreferenceStoreInitializer", statement).contributeTo(this.getLanguage().getEclipsePluginGenModule());
    }

    protected void doGenerateXtendStubFile() {
        TypeReference _generatorStub = this.getGeneratorStub(this.getGrammar());
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Generates code from your model files on save.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* ");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"class ");
                String _simpleName = GeneratorFragment2.this.getGeneratorStub(GeneratorFragment2.this.getLanguage().getGrammar()).getSimpleName();
                _builder.append((Object)_simpleName);
                _builder.append((Object)" extends ");
                _builder.append(AbstractGenerator.class);
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"override void doGenerate(");
                _builder.append(Resource.class, "\t");
                _builder.append((Object)" resource, ");
                _builder.append(IFileSystemAccess2.class, "\t");
                _builder.append((Object)" fsa, ");
                _builder.append(IGeneratorContext.class, "\t");
                _builder.append((Object)" context) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"//\t\tfsa.generateFile('greetings.txt', 'People to greet: ' + ");
                _builder.newLine();
                _builder.append((Object)"//\t\t\tresource.allContents");
                _builder.newLine();
                _builder.append((Object)"//\t\t\t\t.filter(Greeting)");
                _builder.newLine();
                _builder.append((Object)"//\t\t\t\t.map[name]");
                _builder.newLine();
                _builder.append((Object)"//\t\t\t\t.join(', '))");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        this.fileAccessFactory.createXtendFile(_generatorStub, _client).writeTo(this.getProjectConfig().getRuntime().getSrc());
    }

    protected void doGenerateJavaStubFile() {
        TypeReference _generatorStub = this.getGeneratorStub(this.getGrammar());
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* Generates code from your model files on save.");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* ");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"public class ");
                String _simpleName = GeneratorFragment2.this.getGeneratorStub(GeneratorFragment2.this.getLanguage().getGrammar()).getSimpleName();
                _builder.append((Object)_simpleName);
                _builder.append((Object)" extends ");
                _builder.append(AbstractGenerator.class);
                _builder.append((Object)" {");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Override.class, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"public void doGenerate(");
                _builder.append(Resource.class, "\t");
                _builder.append((Object)" resource, ");
                _builder.append(IFileSystemAccess2.class, "\t");
                _builder.append((Object)" fsa, ");
                _builder.append(IGeneratorContext.class, "\t");
                _builder.append((Object)" context) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"//\t\tIterator<Greeting> filtered = Iterators.filter(resource.getAllContents(), Greeting.class);");
                _builder.newLine();
                _builder.append((Object)"//\t\tIterator<String> names = Iterators.transform(filtered, new Function<Greeting, String>() {");
                _builder.newLine();
                _builder.append((Object)"//");
                _builder.newLine();
                _builder.append((Object)"//\t\t\t@");
                _builder.append(Override.class);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"//\t\t\tpublic String apply(Greeting greeting) {");
                _builder.newLine();
                _builder.append((Object)"//\t\t\t\treturn greeting.getName();");
                _builder.newLine();
                _builder.append((Object)"//\t\t\t}");
                _builder.newLine();
                _builder.append((Object)"//\t\t});");
                _builder.newLine();
                _builder.append((Object)"//\t\tfsa.generateFile(\"greetings.txt\", \"People to greet: \" + IteratorExtensions.join(names, \", \"));");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        this.fileAccessFactory.createJavaFile(_generatorStub, _client).writeTo(this.getProjectConfig().getRuntime().getSrc());
    }

    protected void doGenerateJavaMain() {
        TypeReference _javaMain = this.getJavaMain(this.getGrammar());
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"public class Main {");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"public static void main(String[] args) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (args.length == 0) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"System.err.println(\"Aborting: no path to EMF resource provided!\");");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append(Injector.class, "\t\t");
                _builder.append((Object)" injector = new ");
                TypeReference _runtimeSetup = GeneratorFragment2.this._xtextGeneratorNaming.getRuntimeSetup(GeneratorFragment2.this.getGrammar());
                _builder.append((Object)_runtimeSetup, "\t\t");
                _builder.append((Object)"().createInjectorAndDoEMFRegistration();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"Main main = injector.getInstance(Main.class);");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"main.runGenerator(args[0]);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(Provider.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ResourceSet.class, "\t");
                _builder.append((Object)"> resourceSetProvider;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(IResourceValidator.class, "\t");
                _builder.append((Object)" validator;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(GeneratorDelegate.class, "\t");
                _builder.append((Object)" generator;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.append((Object)" ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"private ");
                _builder.append(JavaIoFileSystemAccess.class, "\t");
                _builder.append((Object)" fileAccess;");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"protected void runGenerator(String string) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Load the resource");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append(ResourceSet.class, "\t\t");
                _builder.append((Object)" set = resourceSetProvider.get();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append(Resource.class, "\t\t");
                _builder.append((Object)" resource = set.getResource(");
                _builder.append(URI.class, "\t\t");
                _builder.append((Object)".createFileURI(string), true);");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Validate the resource");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append(List.class, "\t\t");
                _builder.append((Object)"<");
                _builder.append(Issue.class, "\t\t");
                _builder.append((Object)"> list = validator.validate(resource, ");
                _builder.append(CheckMode.class, "\t\t");
                _builder.append((Object)".ALL, ");
                _builder.append(CancelIndicator.class, "\t\t");
                _builder.append((Object)".NullImpl);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (!list.isEmpty()) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"for (");
                _builder.append(Issue.class, "\t\t\t");
                _builder.append((Object)" issue : list) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t\t");
                _builder.append((Object)"System.err.println(issue);");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Configure and start the generator");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"fileAccess.setOutputPath(\"src-gen/\");");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append(GeneratorContext.class, "\t\t");
                _builder.append((Object)" context = new ");
                _builder.append(GeneratorContext.class, "\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"context.setCancelIndicator(");
                _builder.append(CancelIndicator.class, "\t\t");
                _builder.append((Object)".NullImpl);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"generator.generate(resource, fileAccess, context);");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"System.out.println(\"Code generation finished.\");");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        this.fileAccessFactory.createJavaFile(_javaMain, _client).writeTo(this.getProjectConfig().getRuntime().getSrc());
    }

    protected void doGenerateXtendMain() {
        TypeReference _javaMain = this.getJavaMain(this.getGrammar());
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"class Main {");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"def static main(String[] args) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (args.empty) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"System::err.println('Aborting: no path to EMF resource provided!')");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val injector = new ");
                TypeReference _runtimeSetup = GeneratorFragment2.this._xtextGeneratorNaming.getRuntimeSetup(GeneratorFragment2.this.getGrammar());
                _builder.append((Object)_runtimeSetup, "\t\t");
                _builder.append((Object)"().createInjectorAndDoEMFRegistration");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val main = injector.getInstance(Main)");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"main.runGenerator(args.get(0))");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.append((Object)" ");
                _builder.append(Provider.class, "\t");
                _builder.append((Object)"<");
                _builder.append(ResourceSet.class, "\t");
                _builder.append((Object)"> resourceSetProvider");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.append((Object)" ");
                _builder.append(IResourceValidator.class, "\t");
                _builder.append((Object)" validator");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.append((Object)" ");
                _builder.append(GeneratorDelegate.class, "\t");
                _builder.append((Object)" generator");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"@");
                _builder.append(Inject.class, "\t");
                _builder.append((Object)" ");
                _builder.append(JavaIoFileSystemAccess.class, "\t");
                _builder.append((Object)" fileAccess");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"def protected runGenerator(String string) {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Load the resource");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val set = resourceSetProvider.get");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val resource = set.getResource(");
                _builder.append(URI.class, "\t\t");
                _builder.append((Object)".createFileURI(string), true)");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Validate the resource");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val issues = validator.validate(resource, ");
                _builder.append(CheckMode.class, "\t\t");
                _builder.append((Object)".ALL, ");
                _builder.append(CancelIndicator.class, "\t\t");
                _builder.append((Object)".NullImpl)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"if (!issues.empty) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"issues.forEach[System.err.println(it)]");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"return");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// Configure and start the generator");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"fileAccess.outputPath = 'src-gen/'");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"val context = new ");
                _builder.append(GeneratorContext.class, "\t\t");
                _builder.append((Object)" => [");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"cancelIndicator = ");
                _builder.append(CancelIndicator.class, "\t\t\t");
                _builder.append((Object)".NullImpl");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"]");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"generator.generate(resource, fileAccess, context)");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"System.out.println('Code generation finished.')");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        this.fileAccessFactory.createXtendFile(_javaMain, _client).writeTo(this.getProjectConfig().getRuntime().getSrc());
    }

    protected void doGenerateMweFile() {
        String _path = this.getGeneratorStub(this.getLanguage().getGrammar()).getPath();
        String _plus = _path + "MWE.mwe2";
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _fileHeader = GeneratorFragment2.this.codeConfig.getFileHeader();
                _builder.append((Object)_fileHeader);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"module ");
                String _name = GeneratorFragment2.this.getGeneratorStub(GeneratorFragment2.this.getLanguage().getGrammar()).getName();
                _builder.append((Object)_name);
                _builder.append((Object)"MWE");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"import org.eclipse.emf.mwe.utils.*");
                _builder.newLine();
                _builder.append((Object)"import ");
                String _packageName = GeneratorFragment2.this._xtextGeneratorNaming.getRuntimeSetup(GeneratorFragment2.this.getGrammar()).getPackageName();
                _builder.append((Object)_packageName);
                _builder.append((Object)".*");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append((Object)"var targetDir");
                _builder.newLine();
                _builder.append((Object)"var modelPath");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"Workflow {");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"component = org.eclipse.xtext.mwe.Reader {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// lookup all resources on the classpath");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// useJavaClassPath = true");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// or define search scope explicitly");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"path = modelPath");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"// this class will be generated by the xtext generator ");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"register = ");
                String _simpleName = GeneratorFragment2.this._xtextGeneratorNaming.getRuntimeSetup(GeneratorFragment2.this.getGrammar()).getSimpleName();
                _builder.append((Object)_simpleName, "\t\t");
                _builder.append((Object)" {}");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"loadResource = {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"slot = \"model\"");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"component = org.eclipse.xtext.generator.GeneratorComponent {");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"register = ");
                String _simpleName_1 = GeneratorFragment2.this._xtextGeneratorNaming.getRuntimeSetup(GeneratorFragment2.this.getGrammar()).getSimpleName();
                _builder.append((Object)_simpleName_1, "\t\t");
                _builder.append((Object)" {}");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"slot = 'model'");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"outlet = {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"path = targetDir");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        this.fileAccessFactory.createTextFile(_plus, _client).writeTo(this.getProjectConfig().getRuntime().getSrc());
    }

    protected boolean contributeEclipsePluginExtensions() {
        boolean _xblockexpression = false;
        String name = this.getLanguage().getGrammar().getName();
        List<CharSequence> _entries = this.getProjectConfig().getEclipsePlugin().getPluginXml().getEntries();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<extension point=\"org.eclipse.xtext.builder.participant\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<participant");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("class=\"");
        TypeReference _eclipsePluginExecutableExtensionFactory = this._xtextGeneratorNaming.getEclipsePluginExecutableExtensionFactory(this.getGrammar());
        _builder.append((Object)_eclipsePluginExecutableExtensionFactory, "\t\t");
        _builder.append(":org.eclipse.xtext.builder.IXtextBuilderParticipant\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("fileExtensions=\"");
        String _join = IterableExtensions.join(this.getLanguage().getFileExtensions(), (CharSequence)",");
        _builder.append(_join, "\t\t");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("</extension>");
        _builder.newLine();
        _builder.append("<extension point=\"org.eclipse.ui.preferencePages\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<page");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("category=\"");
        _builder.append(name, "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("class=\"");
        TypeReference _eclipsePluginExecutableExtensionFactory_1 = this._xtextGeneratorNaming.getEclipsePluginExecutableExtensionFactory(this.getGrammar());
        _builder.append((Object)_eclipsePluginExecutableExtensionFactory_1, "\t\t");
        _builder.append(":org.eclipse.xtext.builder.preferences.BuilderPreferencePage\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("id=\"");
        _builder.append(name, "\t\t");
        _builder.append(".compiler.preferencePage\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("name=\"Compiler\">");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<keywordReference id=\"");
        String _namespace = GrammarUtil.getNamespace((Grammar)this.getLanguage().getGrammar());
        String _plus = _namespace + ".ui.keyword_";
        String _simpleName = GrammarUtil.getSimpleName((Grammar)this.getLanguage().getGrammar());
        String _plus_1 = _plus + _simpleName;
        _builder.append(_plus_1, "\t\t");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("</page>");
        _builder.newLine();
        _builder.append("</extension>");
        _builder.newLine();
        _builder.append("<extension point=\"org.eclipse.ui.propertyPages\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<page");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("category=\"");
        _builder.append(name, "\t\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("class=\"");
        TypeReference _eclipsePluginExecutableExtensionFactory_2 = this._xtextGeneratorNaming.getEclipsePluginExecutableExtensionFactory(this.getGrammar());
        _builder.append((Object)_eclipsePluginExecutableExtensionFactory_2, "\t\t");
        _builder.append(":org.eclipse.xtext.builder.preferences.BuilderPreferencePage\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("id=\"");
        _builder.append(name, "\t\t");
        _builder.append(".compiler.propertyPage\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("name=\"Compiler\">");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<keywordReference id=\"");
        String _namespace_1 = GrammarUtil.getNamespace((Grammar)this.getLanguage().getGrammar());
        String _plus_2 = _namespace_1 + ".ui.keyword_";
        String _simpleName_1 = GrammarUtil.getSimpleName((Grammar)this.getLanguage().getGrammar());
        String _plus_3 = _plus_2 + _simpleName_1;
        _builder.append(_plus_3, "\t\t");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("<enabledWhen>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<adapt type=\"org.eclipse.core.resources.IProject\"/>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("</enabledWhen>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<filter name=\"projectNature\" value=\"org.eclipse.xtext.ui.shared.xtextNature\"/>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</page>");
        _builder.newLine();
        _builder.append("</extension>");
        _builder.newLine();
        _builder.append("<extension point=\"org.eclipse.ui.menus\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<menuContribution locationURI=\"popup:#TextEditorContext?after=xtext.ui.openDeclaration\">");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<command");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("commandId=\"org.eclipse.xtext.ui.OpenGeneratedFileCommand\"");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("id=\"");
        _builder.append(name, "\t\t\t");
        _builder.append(".OpenGeneratedCode\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("style=\"push\">");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<visibleWhen checkEnabled=\"false\">");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("<reference definitionId=\"");
        _builder.append(name, "\t\t\t\t");
        _builder.append(".Editor.opened\" />");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("</visibleWhen>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("</command>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</menuContribution>");
        _builder.newLine();
        _builder.append("</extension>");
        _builder.newLine();
        _builder.append("<extension point=\"org.eclipse.ui.handlers\">");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<handler");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("class=\"");
        TypeReference _eclipsePluginExecutableExtensionFactory_3 = this._xtextGeneratorNaming.getEclipsePluginExecutableExtensionFactory(this.getGrammar());
        _builder.append((Object)_eclipsePluginExecutableExtensionFactory_3, "\t\t");
        _builder.append(":org.eclipse.xtext.ui.generator.trace.OpenGeneratedFileHandler\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("commandId=\"org.eclipse.xtext.ui.OpenGeneratedFileCommand\">");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<activeWhen>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<reference definitionId=\"");
        _builder.append(name, "\t\t\t");
        _builder.append(".Editor.opened\" />");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("</activeWhen>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</handler>");
        _builder.newLine();
        _builder.append("</extension>");
        _builder.newLine();
        _xblockexpression = _entries.add(_builder.toString());
        return _xblockexpression;
    }

    public void setGenerateMwe(boolean generateMwe) {
        this.generateMwe = generateMwe;
    }

    public void setGenerateJavaMain(boolean generateJavaMain) {
        this.generateJavaMain = generateJavaMain;
    }

    public void setGenerateXtendMain(boolean generateXtendMain) {
        this.generateXtendMain = generateXtendMain;
    }
}

