/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.codeexecution.behaviors;

import fr.inria.aoste.timesquare.backend.codeexecution.behaviors.CodeExecutionBehavior;
import fr.inria.aoste.timesquare.backend.codeexecution.persistentoptions.Variable;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockBehavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.ConfigurationHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.TraceHelper;
import fr.inria.aoste.timesquare.trace.util.ReferenceNameBuilder;
import fr.inria.aoste.trace.ModelElementReference;
import java.util.ArrayList;
import org.eclipse.jdt.core.IMethod;

public class CodeExecutionClockBehavior
extends CodeExecutionBehavior
implements ClockBehavior {
    private transient ArrayList<ModelElementReference> _mersToForce = null;
    private transient ArrayList<ClockEntity> _clockToForce = null;
    private ArrayList<String> _clockQualifiedNameToForce = null;

    public CodeExecutionClockBehavior(Variable var, IMethod method, ArrayList<ClockEntity> clocksToForce, ConfigurationHelper helper) {
        super(var, method, helper);
        this.additionalInitiation(clocksToForce);
    }

    public CodeExecutionClockBehavior(Variable var, String methodName, ArrayList<ClockEntity> clocksToForce, ConfigurationHelper helper) {
        super(var, methodName, helper);
        this.additionalInitiation(clocksToForce);
    }

    private void additionalInitiation(ArrayList<ClockEntity> clocksToForce) {
        this._clockToForce = new ArrayList();
        this._mersToForce = new ArrayList();
        this._clockQualifiedNameToForce = new ArrayList();
        if (clocksToForce != null) {
            this._clockToForce = clocksToForce;
            for (ClockEntity ce : clocksToForce) {
                ModelElementReference mer = ce.getModelElementReference();
                this._mersToForce.add(mer);
                this._clockQualifiedNameToForce.add(ReferenceNameBuilder.buildQualifiedName((ModelElementReference)mer, (String)"::"));
            }
        }
    }

    public ArrayList<String> getClockQualifiedNameToForce() {
        return this._clockQualifiedNameToForce;
    }

    public ArrayList<ClockEntity> getClocksToForce() {
        return this._clockToForce;
    }

    public ArrayList<ModelElementReference> getMersTForce() {
        return this._mersToForce;
    }

    public void run(TraceHelper helper) {
        super.execute(this._mersToForce);
    }

    public void runWithWrongActivationState(TraceHelper helper) {
    }
}

