/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.power.view;

import fr.inria.aoste.timesquare.backend.power.view.IPowerView;
import fr.inria.aoste.timesquare.backend.power.view.PowerData;
import fr.inria.aoste.timesquare.backend.power.view.Ruler;
import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import java.util.ArrayList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class PowerView
extends ViewPart
implements IPowerView {
    private static final String POWER_VIEW = "Power View";
    public static final String FR_INRIA_AOSTE_TIMESQUARE_BACKEND_POWER_POWERVIEW = "fr.inria.aoste.timesquare.backend.power.powerview";
    private static PowerView courant;
    public static final int offsetx = 160;
    public static final int offsety = 20;
    public static final int stepscale = 10;
    public static final int steppower = 1;
    public int sizex = 400;
    public int sizey = 300;
    private FigureCanvas canvas = null;
    private Composite composite = null;
    private Panel contents = null;
    private int cptcolor = 0;
    public ArrayList<PowerData> listPowerDatas = new ArrayList();
    private Ruler xRuler = null;
    private Ruler yRuler = null;
    public ArrayList<Label> llabel = new ArrayList();

    public static synchronized IPowerView getCourant() {
        if (courant == null) {
            try {
                PluginHelpers.getShowView((String)FR_INRIA_AOSTE_TIMESQUARE_BACKEND_POWER_POWERVIEW);
                if (courant == null) {
                    PluginHelpers.getCreateView((String)FR_INRIA_AOSTE_TIMESQUARE_BACKEND_POWER_POWERVIEW);
                }
                PluginHelpers.getShowView((String)FR_INRIA_AOSTE_TIMESQUARE_BACKEND_POWER_POWERVIEW);
                if (courant != null) {
                    courant.setFocus();
                }
            }
            catch (Throwable ex) {
                ErrorConsole.printError((Throwable)ex, (String)POWER_VIEW);
            }
        }
        return courant;
    }

    public static synchronized void refreshCourant() {
        if (courant != null) {
            courant.refresh();
        }
    }

    private static final synchronized void setCourant(PowerView courant) {
        PowerView.courant = courant;
    }

    public PowerView() {
        PowerView.setCourant(this);
    }

    public void createPartControl(Composite parent) {
        this.composite = new Composite(parent, 2048);
        this.composite.setLayout((Layout)new FillLayout());
        this.canvas = new FigureCanvas(this.composite, 0x20000000);
        this.contents = new Panel();
        this.canvas.setBackground(ColorConstants.white);
        this.canvas.setVerticalScrollBarVisibility(FigureCanvas.ALWAYS);
        this.canvas.setHorizontalScrollBarVisibility(FigureCanvas.ALWAYS);
        this.canvas.setContents((IFigure)this.contents);
    }

    public void dispose() {
        super.dispose();
        PowerView.setCourant(null);
    }

    @Override
    public void clear() {
        this.cptcolor = 0;
        this.listPowerDatas.clear();
        this.llabel.clear();
        this.contents.removeAll();
        this.xRuler = new Ruler(this.contents, Ruler.HV.horizontal, 160, 20, 10, 5, 140);
        this.yRuler = new Ruler(this.contents, Ruler.HV.vertical, 160, 20, 1, 20, 140);
        this.contents.add((IFigure)this.xRuler);
        this.contents.add((IFigure)this.yRuler);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PowerView.this.contentRepaint();
            }
        });
    }

    protected void contentRepaint() {
        for (Object f : this.contents.getChildren()) {
            if (!(f instanceof IPowerViewFigure)) continue;
            ((IPowerViewFigure)f).updateLocation(this.yRuler.getLenght() + 20);
        }
        this.contents.repaint();
    }

    protected IFigure createDot(Panel contents, int x, int y, Color color) {
        Dot dotFigure = new Dot(color, 2);
        contents.add((IFigure)dotFigure);
        dotFigure.setLocation(new Point(x, y));
        contents.setConstraint((IFigure)dotFigure, (Object)new Rectangle(x, y, -1, -1));
        this.xRuler.updateLenght(x);
        this.yRuler.updateLenght(y);
        Dimension d = contents.getMinimumSize();
        contents.setMinimumSize(new Dimension(Math.min(d.width, x), Math.min(d.height, y)));
        this.contentRepaint();
        this.canvas.layout();
        this.canvas.update();
        this.canvas.redraw();
        return dotFigure;
    }

    @Override
    public IFigure createDot(int x, int y, Color color) {
        CreateDotRunnable cdr = new CreateDotRunnable(x, y, color);
        Display.getDefault().syncExec((Runnable)cdr);
        return cdr.getTmp();
    }

    public void createLine(final IFigure newf, final IFigure old, final Color color) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PolylineConnection wireFigure = new PolylineConnection();
                wireFigure.setForegroundColor(color);
                EllipseAnchor sourceAnchor = new EllipseAnchor(old);
                EllipseAnchor targetAnchor = new EllipseAnchor(newf);
                wireFigure.setSourceAnchor((ConnectionAnchor)sourceAnchor);
                wireFigure.setTargetAnchor((ConnectionAnchor)targetAnchor);
                PowerView.this.contents.add((IFigure)wireFigure);
            }
        });
    }

    @Override
    public PowerData createPowerData(String s) {
        Color c = this.getNewColour();
        PowerData powerData = new PowerData(s, this, c);
        this.listPowerDatas.add(powerData);
        int height = 30 + this.llabel.size() * 25;
        Label l = new Label(s);
        RectangleText rectangle = new RectangleText();
        int size = 100;
        rectangle.setOpaque(false);
        rectangle.setLineStyle(3);
        rectangle.setForegroundColor(c);
        rectangle.setBounds(new Rectangle(1, height, size, 20));
        l.setBounds(new Rectangle(4, height + 1, size - 4, 18));
        l.setForegroundColor(ColorConstants.black);
        l.setOpaque(true);
        Font font = new Font(null, "Arial", 10, 1);
        l.setFont(font);
        l.setForegroundColor(c);
        rectangle.add((IFigure)l);
        this.llabel.add(l);
        this.contents.add((IFigure)rectangle);
        return powerData;
    }

    public Color getNewColour() {
        this.cptcolor = this.cptcolor == 8 ? 0 : ++this.cptcolor;
        switch (this.cptcolor) {
            case 0: {
                return ColorConstants.red;
            }
            case 1: {
                return ColorConstants.blue;
            }
            case 2: {
                return ColorConstants.green;
            }
            case 3: {
                return ColorConstants.lightBlue;
            }
            case 4: {
                return ColorConstants.lightGreen;
            }
            case 5: {
                return ColorConstants.lightGray;
            }
            case 6: {
                return ColorConstants.darkBlue;
            }
        }
        return ColorConstants.darkGreen;
    }

    @Override
    public int refresh() {
        return 0;
    }

    public void setFocus() {
    }

    @Override
    public void updatexRuler(final int x) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (PowerView.this.xRuler != null) {
                    PowerView.this.xRuler.updateLenght(x * 10);
                }
                PowerView.this.contents.repaint();
                PowerView.this.canvas.update();
            }
        });
    }

    private final class CreateDotRunnable
    implements Runnable {
        private final Color color;
        private IFigure tmp;
        private final int x;
        private final int y;

        private CreateDotRunnable(int x, int y, Color color) {
            this.x = x;
            this.y = y;
            this.color = color;
        }

        protected IFigure getTmp() {
            return this.tmp;
        }

        @Override
        public void run() {
            this.tmp = PowerView.this.createDot(PowerView.this.contents, 160 + this.x * 10, 20 + this.y, this.color);
        }
    }

    public static class Dot
    extends Ellipse
    implements IPowerViewFigure {
        int size;
        int y = 0;
        Point location = new Point(0, 0);

        public Dot(Color c) {
            this(c, 2);
        }

        public Dot(Color c, int rayon) {
            this.size = rayon;
            Dimension dim = new Dimension(this.size * 2, this.size * 2);
            this.setSize(dim);
            this.setBackgroundColor(c);
            this.setOpaque(true);
        }

        @Override
        public void updateLocation(int size_y) {
            this.y = size_y;
            super.setLocation(new Point(this.location.x - this.size, size_y - this.location.y - this.size));
        }

        public void setLocation(Point p) {
            this.location = p;
            this.updateLocation(this.y);
        }
    }

    public static interface IPowerViewFigure {
        public void updateLocation(int var1);
    }

    public static final class RectangleText
    extends RectangleFigure
    implements IPowerViewFigure {
        int y = 0;
        Rectangle rect = new Rectangle(0, 0, 0, 0);

        @Override
        public void updateLocation(int size_y) {
            this.y = size_y;
            super.setBounds(new Rectangle(this.rect.x, this.rect.y, this.rect.width, this.rect.height));
        }

        public void setBounds(Rectangle _rect) {
            this.rect = new Rectangle(_rect);
            this.updateLocation(this.y);
        }
    }
}

