/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.antlr.editors;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.vcd.action.PrinterAction;
import fr.inria.aoste.timesquare.vcd.antlr.editors.ToolBarAPi;
import fr.inria.aoste.timesquare.vcd.antlr.editors.VcdMultiPageEditor;
import fr.inria.aoste.timesquare.vcd.dialogs.HelpDialog;
import fr.inria.aoste.timesquare.vcd.menu.VcdMenu;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class VcdMultiPageEditorContributor
extends MultiPageEditorActionBarContributor {
    private VcdMultiPageEditor _vcdMultiPageEditor = null;
    private IMenuManager _vcdMenuManager = null;
    private IEditorPart _globalEditorPart = null;
    private IMenuManager _syncMenu = null;
    private IMenuManager _findMenu = null;
    private Action _orderAction = null;
    private Action _showGhostAction = null;
    private Action _hideGhostAction = null;
    private Action _partialGhostAction = null;
    private Action _findAction = null;
    private IMenuManager _clockMenu = null;
    private IMenuManager _optionsMenu = null;
    private HelpDialog _helpDialog = null;

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void setActivePage(IEditorPart _editorPart) {
        if (this._globalEditorPart == _editorPart) {
            this.createActions();
        }
        this._globalEditorPart = _editorPart;
        IActionBars _actionBars = this.getActionBars();
        if (_actionBars == null && _editorPart != null && _editorPart.getEditorSite() != null) {
            _actionBars = _editorPart.getEditorSite().getActionBars();
        }
        if (_actionBars != null) {
            VcdMenu vcdmenu;
            ITextEditor editor = _editorPart instanceof ITextEditor ? (ITextEditor)_editorPart : null;
            _actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(editor, ITextEditorActionConstants.DELETE));
            _actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction(editor, ITextEditorActionConstants.UNDO));
            _actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction(editor, ITextEditorActionConstants.REDO));
            _actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction(editor, ITextEditorActionConstants.CUT));
            _actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction(editor, ITextEditorActionConstants.COPY));
            _actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction(editor, ITextEditorActionConstants.PASTE));
            _actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(editor, ITextEditorActionConstants.SELECT_ALL));
            if (_editorPart instanceof VcdMultiPageEditor && (vcdmenu = ((VcdMultiPageEditor)_editorPart).getVcdmenu()) != null) {
                _actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)vcdmenu.getRefreshAction());
                PrinterAction printer = vcdmenu.getPrinterAction();
                if (printer != null) {
                    _actionBars.setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)printer);
                }
                _actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)vcdmenu.getFindAction());
            }
            _actionBars.updateActionBars();
        }
    }

    public void unsetEditor(IEditorPart _editorPart) {
        if (_editorPart == this._globalEditorPart) {
            this.setActivePage(null);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        this.setActivePage(part);
    }

    private void createActions() {
        try {
            this._vcdMenuManager.removeAll();
            this.updateMenu();
            IEditorPart editorPart = null;
            IWorkbenchWindow iww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (iww != null && iww.getActivePage() != null) {
                editorPart = iww.getActivePage().getActiveEditor();
            }
            if (editorPart instanceof VcdMultiPageEditor) {
                this._vcdMultiPageEditor = (VcdMultiPageEditor)editorPart;
                ToolBarAPi.getDef().setCurrentVcd(this._vcdMultiPageEditor);
            }
            if (this._vcdMultiPageEditor == null) {
                return;
            }
            VcdMenu _vcdMenu = this._vcdMultiPageEditor.getVcdmenu();
            if (_vcdMenu == null) {
                return;
            }
            this._vcdMultiPageEditor._vcdMultiPageEditorContributor = this;
            this._orderAction = _vcdMenu.getOrderAction();
            this._clockMenu.removeAll();
            this._clockMenu.add((IAction)this._orderAction);
            this._optionsMenu.removeAll();
            this._optionsMenu.add((IContributionItem)new Separator("ghost"));
            this._optionsMenu.add((IContributionItem)new Separator("sync"));
            this._showGhostAction = _vcdMenu.getShowGhostAction();
            this._optionsMenu.appendToGroup("ghost", (IAction)this._showGhostAction);
            this._hideGhostAction = _vcdMenu.getHideGhostAction();
            this._optionsMenu.appendToGroup("ghost", (IContributionItem)new ActionContributionItem((IAction)this._hideGhostAction){

                public boolean isVisible() {
                    return this.getAction().isEnabled();
                }
            });
            this._partialGhostAction = _vcdMenu.getPartialGhostAction();
            this._optionsMenu.appendToGroup("ghost", (IContributionItem)new ActionContributionItem((IAction)this._partialGhostAction){

                public boolean isVisible() {
                    return this.getAction().isEnabled();
                }
            });
            this._syncMenu.removeAll();
            for (Action a : _vcdMenu.getSyncAction()) {
                this._syncMenu.add((IAction)a);
            }
            this._optionsMenu.appendToGroup("sync", (IContributionItem)this._syncMenu);
            this._findAction = _vcdMenu.getFindAction();
            this._findMenu.removeAll();
            this._findMenu.add((IAction)this._findAction);
            Action help = new Action("About"){

                public boolean isEnabled() {
                    return true;
                }

                public void run() {
                    if (VcdMultiPageEditorContributor.this._helpDialog == null) {
                        VcdMultiPageEditorContributor.this._helpDialog = new HelpDialog(){

                            public void close() {
                                VcdMultiPageEditorContributor.this._helpDialog = null;
                                super.close();
                                VcdMultiPageEditorContributor.this._vcdMultiPageEditor.setFocus();
                            }
                        };
                    }
                }
            };
            this._vcdMenuManager.add((IAction)_vcdMenu.getRefreshAction());
            this._vcdMenuManager.add((IAction)_vcdMenu.getVCDOption());
            this._vcdMenuManager.add((IAction)_vcdMenu.getPrinterAction());
            this._vcdMenuManager.add((IAction)help);
        }
        catch (Throwable e) {
            ErrorConsole.printError((Throwable)e, (String)" Ex");
            return;
        }
    }

    public void contributeToMenu(IMenuManager _menuManager) {
        this._vcdMenuManager = new MenuManager("&Vcd Editor"){

            public boolean isDynamic() {
                return true;
            }

            public boolean isDirty() {
                return true;
            }
        };
        _menuManager.prependToGroup("additions", (IContributionItem)this._vcdMenuManager);
        this.updateMenu();
    }

    public void updateMenu() {
        this.createClockMenu(this._vcdMenuManager);
        this.createOptionsMenu(this._vcdMenuManager);
        this.createFindMenu(this._vcdMenuManager);
    }

    public void createClockMenu(IMenuManager _menuManager) {
        this._clockMenu = new MenuManager("&Clock");
        _menuManager.add((IContributionItem)this._clockMenu);
    }

    public void createOptionsMenu(IMenuManager _menuManager) {
        this._optionsMenu = new MenuManager("&Options");
        _menuManager.add((IContributionItem)this._optionsMenu);
        this._syncMenu = new MenuManager("&Synchronized");
        this._optionsMenu.add((IContributionItem)this._syncMenu);
    }

    public void createFindMenu(IMenuManager _menuManager) {
        this._findMenu = new MenuManager("&Find");
        _menuManager.add((IContributionItem)this._findMenu);
    }

    public void contributeToToolBar(IToolBarManager _toolBarManager) {
        for (IContributionItem iContributionItem : ToolBarAPi.getDef().getZoomApi()) {
            _toolBarManager.add(iContributionItem);
        }
        _toolBarManager.update(true);
    }
}

