/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.vcd.model.command;

import fr.inria.aoste.timesquare.vcd.model.IDeclarationCommand;
import fr.inria.aoste.timesquare.vcd.model.keyword.TimeUnit;
import fr.inria.aoste.timesquare.vcd.model.visitor.IDeclarationVisitor;

public final class TimeScaleCommand
implements IDeclarationCommand {
    private int _number = 1;
    private TimeUnit _unit;

    public TimeScaleCommand() {
        this.set(1, TimeUnit.tick);
    }

    public TimeScaleCommand(String number, String unit) {
        this.setNumber(number);
        this.setUnit(unit);
    }

    @Override
    public void visit(IDeclarationVisitor visitor) {
        if (this._unit != null && this._unit != TimeUnit.tick) {
            visitor.visitTimeScale(this._number, this._unit);
        }
    }

    public int getNumber() {
        return this._number;
    }

    public TimeUnit getUnit() {
        return this._unit;
    }

    @Override
    public int clear() {
        return 0;
    }

    public final void setNumber(String number) {
        try {
            this._number = Integer.parseInt(number);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void setNumber(int number) {
        this._number = number;
    }

    public final void setUnit(TimeUnit unit) {
        this._unit = unit;
    }

    public final void setUnit(String unit) {
        try {
            this._unit = TimeUnit.valueOf(unit);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int set(int n, TimeUnit tu) {
        this.setNumber(n);
        this.setUnit(tu);
        return 0;
    }

    public int set(int n) {
        switch (n) {
            case 0: {
                return this.set(1, TimeUnit.s);
            }
            case 1: {
                return this.set(100, TimeUnit.ms);
            }
            case 2: {
                return this.set(10, TimeUnit.ms);
            }
            case 3: {
                return this.set(1, TimeUnit.ms);
            }
            case 4: {
                return this.set(100, TimeUnit.us);
            }
            case 5: {
                return this.set(10, TimeUnit.us);
            }
            case 6: {
                return this.set(1, TimeUnit.us);
            }
            case 7: {
                return this.set(100, TimeUnit.ns);
            }
            case 8: {
                return this.set(10, TimeUnit.ns);
            }
            case 9: {
                return this.set(1, TimeUnit.ns);
            }
            case 10: {
                return this.set(100, TimeUnit.ps);
            }
            case 11: {
                return this.set(10, TimeUnit.ps);
            }
            case 12: {
                return this.set(1, TimeUnit.ps);
            }
            case 13: {
                return this.set(100, TimeUnit.fs);
            }
            case 14: {
                return this.set(10, TimeUnit.fs);
            }
            case 15: {
                return this.set(1, TimeUnit.fs);
            }
        }
        return 0;
    }
}

