/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.adapters;

import fr.kairos.timesquare.ccsl.IConstraint;
import fr.kairos.timesquare.ccsl.IDefinition;
import fr.kairos.timesquare.ccsl.IRelation;
import fr.kairos.timesquare.ccsl.ISimpleSpecification;
import fr.kairos.timesquare.ccsl.ISpecification;

public final class GenericToSimple
implements ISpecification {
    public static String SUBCLOCK = "Subclock";
    public static String EXCLUSION = "Exclusion";
    public static String ALTERNATION = "Alternation";
    public static String CAUSALITY = "Causality";
    public static String PRECEDENCE = "Precedence";
    private ISimpleSpecification spec;
    private static String[] SUPPORTED_relations = new String[]{SUBCLOCK, EXCLUSION, ALTERNATION, CAUSALITY, PRECEDENCE};
    private static String[] SUPPORTED_expressions = new String[]{"Union", "Intersection", "Minus", "Inf", "Sup", "Periodic"};

    public GenericToSimple(ISimpleSpecification spec) {
        this.spec = spec;
    }

    @Override
    public void addClock(String name) {
        this.spec.addClock(name);
    }

    private void addRelation(IRelation relation) {
        switch (relation.getConstraintName()) {
            case "Subclock": {
                this.spec.subclock(relation.getLeft(), relation.getRight());
                break;
            }
            case "Exclusion": {
                this.spec.exclusion(relation.getLeft(), relation.getRight());
                break;
            }
            case "Causality": {
                int min = relation.getIntParam("min", 0);
                int max = relation.getIntParam("max", -1);
                if (min != 0 || max != -1) {
                    this.spec.causality(relation.getLeft(), relation.getRight(), min, max);
                    break;
                }
                this.spec.causality(relation.getLeft(), relation.getRight());
                break;
            }
            case "Precedence": {
                int min = relation.getIntParam("min", 0);
                int max = relation.getIntParam("max", -1);
                if (min != 0 || max != -1) {
                    this.spec.precedence(relation.getLeft(), relation.getRight(), min, max);
                    break;
                }
                this.spec.precedence(relation.getLeft(), relation.getRight());
                break;
            }
            case "Alternation": {
                this.spec.causality(relation.getLeft(), relation.getRight(), 0, 1);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported relation " + relation);
            }
        }
    }

    @Override
    public void add(IConstraint constraint) {
        if (constraint instanceof IRelation) {
            this.addRelation((IRelation)constraint);
        } else if (constraint instanceof IDefinition) {
            this.addDefinition((IDefinition)constraint);
        }
    }

    private void addDefinition(IDefinition definition) {
        switch (definition.getConstraintName()) {
            case "Union": {
                this.spec.union(definition.getDefinedClock(), definition.getRefClocks());
                break;
            }
            case "Intersection": {
                this.spec.intersection(definition.getDefinedClock(), definition.getRefClocks());
                break;
            }
            case "Inf": {
                this.spec.inf(definition.getDefinedClock(), definition.getRefClocks());
                break;
            }
            case "Sup": {
                this.spec.sup(definition.getDefinedClock(), definition.getRefClocks());
                break;
            }
            case "Minus": {
                this.spec.minus(definition.getDefinedClock(), definition.getRefClocks());
                break;
            }
            case "Periodic": {
                int period = definition.getIntParam("period", 1);
                int from = definition.getIntParam("from", 0);
                int upto = definition.getIntParam("upto", -1);
                this.spec.periodic(definition.getDefinedClock(), definition.getRefClocks()[0], period, from, upto);
                break;
            }
            case "DelayFor": {
                int from = definition.getIntParam("from", 0);
                int upto = definition.getIntParam("upto", -1);
                String base = null;
                if (definition.getRefClocks().length > 1) {
                    base = definition.getRefClocks()[1];
                }
                this.spec.delayFor(definition.getDefinedClock(), definition.getRefClocks()[0], from, upto, base);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported definition " + definition);
            }
        }
    }

    @Override
    public boolean isConstraintSupported(String name) {
        String s;
        String[] stringArray = SUPPORTED_relations;
        int n = SUPPORTED_relations.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(name)) {
                return true;
            }
            ++n2;
        }
        stringArray = SUPPORTED_expressions;
        n = SUPPORTED_expressions.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (s.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

