/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.ccsl.sat;

import fr.kairos.timesquare.ccsl.ISimpleSpecification;
import fr.kairos.timesquare.ccsl.sat.IBackend;
import fr.kairos.timesquare.ccsl.sat.IClockBuilder;
import fr.kairos.timesquare.ccsl.sat.ISATSolverBuilder;
import fr.kairos.timesquare.ccsl.sat.SATSolver;
import fr.kairos.timesquare.ccsl.simple.AUtility;
import fr.kairos.timesquare.ccsl.simple.ISpecificationBuilder;
import fr.kairos.timesquare.ccsl.simple.IUtility;

public abstract class ASATUtility
extends AUtility
implements IUtility {
    public static String NB_STEPS = "NbSteps";
    public static String DEBUG = "Debug";
    public static String INTERACTIVE = "Interactive";
    private IBackend backend;

    protected abstract ISATSolverBuilder getSATSolverBuilder();

    public void setBackend(IBackend backend) {
        this.backend = backend;
    }

    @Override
    public final ISimpleSpecification treat(String name, ISpecificationBuilder builder) {
        try {
            IClockBuilder clockBuilder = null;
            if (this.backend != null) {
                clockBuilder = this.backend.init(this);
            }
            SATSolver solver = new SATSolver(this.getSATSolverBuilder(), builder, clockBuilder);
            if (this.getBooleanParam(INTERACTIVE, true)) {
                solver.interactiveStep();
            } else {
                solver.stepAndPrint(this.getIntParam(NB_STEPS, 10), this.getBooleanParam(DEBUG, false));
            }
            if (this.backend != null) {
                this.backend.finish(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

