/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import org.eclipse.ajdt.internal.ui.editor.DotWordRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class BracketWordRule
extends DotWordRule {
    public BracketWordRule(IWordDetector detector) {
        super(detector);
    }

    @Override
    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        int numToUnread = 1;
        while (c != -1 && this.fDetector.isWordPart((char)c)) {
            c = scanner.read();
            ++numToUnread;
        }
        while (Character.isWhitespace((char)c)) {
            c = scanner.read();
            ++numToUnread;
        }
        if ((char)c != '(') {
            this.unread(scanner, numToUnread);
            return Token.UNDEFINED;
        }
        this.unread(scanner, numToUnread);
        return super.evaluate(scanner);
    }

    private void unread(ICharacterScanner scanner, int numToUnread) {
        int i = 0;
        while (i < numToUnread) {
            scanner.unread();
            ++i;
        }
    }
}

