/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.quickfix;

import java.util.Collection;
import org.eclipse.ajdt.internal.ui.editor.quickfix.AJSerialVersionHashOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.PotentialProgrammingProblemsFix;
import org.eclipse.jdt.internal.corext.fix.SerialVersionDefaultOperation;
import org.eclipse.jdt.internal.ui.text.correction.SerialVersionSubProcessor;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class AJSerialVersionSubProcessor
extends PotentialProgrammingProblemsFix {
    protected AJSerialVersionSubProcessor(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final void getSerialVersionProposals(IInvocationContext context, IProblemLocation location, Collection proposals) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)location);
        Assert.isNotNull((Object)proposals);
        IProposableFix[] fixes = AJSerialVersionSubProcessor.createMissingSerialVersionFixes(context.getASTRoot(), location);
        if (fixes != null) {
            proposals.add(new SerialVersionSubProcessor.SerialVersionProposal(fixes[0], 9, context, true));
            proposals.add(new SerialVersionSubProcessor.SerialVersionProposal(fixes[1], 9, context, false));
        }
    }

    public static IProposableFix[] createMissingSerialVersionFixes(CompilationUnit compilationUnit, IProblemLocation problem) {
        if (problem.getProblemId() != 0x20000060) {
            return null;
        }
        ICompilationUnit unit = (ICompilationUnit)compilationUnit.getJavaElement();
        if (unit == null) {
            return null;
        }
        SimpleName simpleName = AJSerialVersionSubProcessor.getSelectedName(compilationUnit, problem);
        if (simpleName == null) {
            return null;
        }
        ASTNode declaringNode = AJSerialVersionSubProcessor.getDeclarationNode(simpleName);
        if (declaringNode == null) {
            return null;
        }
        SerialVersionDefaultOperation defop = new SerialVersionDefaultOperation(unit, new ASTNode[]{declaringNode});
        AJSerialVersionSubProcessor fix1 = new AJSerialVersionSubProcessor("Add default serial version ID (AspectJ)", compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{defop});
        AJSerialVersionHashOperation hashop = new AJSerialVersionHashOperation(unit, new ASTNode[]{declaringNode});
        AJSerialVersionSubProcessor fix2 = new AJSerialVersionSubProcessor("Add generated serial version ID (AspectJ)", compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{hashop});
        return new IProposableFix[]{fix1, fix2};
    }

    private static SimpleName getSelectedName(CompilationUnit compilationUnit, IProblemLocation problem) {
        ASTNode selection = problem.getCoveredNode(compilationUnit);
        if (selection == null) {
            return null;
        }
        Name name = null;
        if (selection instanceof SimpleType) {
            SimpleType type = (SimpleType)selection;
            name = type.getName();
        } else if (selection instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)selection;
            Type raw = type.getType();
            if (raw instanceof SimpleType) {
                name = ((SimpleType)raw).getName();
            } else if (raw instanceof QualifiedType) {
                name = ((QualifiedType)raw).getName();
            }
        } else if (selection instanceof Name) {
            name = (Name)selection;
        }
        if (name == null) {
            return null;
        }
        if (name.isSimpleName()) {
            return (SimpleName)name;
        }
        return ((QualifiedName)name).getName();
    }

    private static ASTNode getDeclarationNode(SimpleName name) {
        ASTNode parent = name.getParent();
        if (!(parent instanceof AbstractTypeDeclaration)) {
            if ((parent = parent.getParent()) instanceof ParameterizedType || parent instanceof Type) {
                parent = parent.getParent();
            }
            if (parent instanceof ClassInstanceCreation) {
                ClassInstanceCreation creation = (ClassInstanceCreation)parent;
                parent = creation.getAnonymousClassDeclaration();
            }
        }
        return parent;
    }
}

