/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.ConfigurationChecker;
import org.eclipse.egit.ui.internal.KnownHosts;
import org.eclipse.egit.ui.internal.RepositoryCacheRule;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.egit.ui.internal.variables.GitTemplateVariableResolver;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.events.WorkingTreeModifiedListener;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.themes.ITheme;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements DebugOptionsListener {
    private static Activator plugin;
    private static List<IPropertyChangeListener> propertyChangeListeners;
    public static final String DECORATORS_CHANGED = "org.eclipse.egit.ui.DECORATORS_CHANGED";
    private ResourceManager resourceManager;
    private RepositoryChangeScanner rcs;
    private ResourceRefreshJob refreshJob;
    private ListenerHandle refreshHandle;
    private DebugOptions debugOptions;
    private volatile boolean uiIsActive;
    private IWindowListener focusListener;

    static {
        propertyChangeListeners = new ArrayList<IPropertyChangeListener>(5);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    private static IStatus toStatus(int severity, String message, Throwable throwable) {
        Throwable exc = throwable;
        while (exc instanceof InvocationTargetException) {
            Throwable cause;
            String msg = exc.getLocalizedMessage();
            if (msg != null && !msg.isEmpty() || (cause = exc.getCause()) == null) break;
            exc = cause;
        }
        if (exc != null && (message == null || message.isEmpty())) {
            message = exc.getLocalizedMessage();
        }
        return new Status(severity, Activator.getPluginId(), message, exc);
    }

    public static void handleError(String message, Throwable throwable, boolean show) {
        Activator.handleIssue(4, message, throwable, show);
    }

    public static void handleIssue(int severity, String message, Throwable throwable, boolean show) {
        IStatus status = Activator.toStatus(severity, message, throwable);
        int style = 1;
        if (show) {
            style |= 2;
        }
        StatusManager.getManager().handle(status, style);
    }

    public static void showError(String message, Throwable throwable) {
        IStatus status = Activator.toStatus(4, message, throwable);
        StatusManager.getManager().handle(status, 2);
    }

    public static void showErrorStatus(String message, IStatus status) {
        StatusManager.getManager().handle(status, 2);
    }

    public static void logError(String message, Throwable e) {
        Activator.handleError(message, e, false);
    }

    public static void logWarning(String message, Throwable thr) {
        Activator.handleIssue(2, message, thr, false);
    }

    public static void error(String message, Throwable e) {
        Activator.handleError(message, e, false);
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return Activator.toStatus(4, message, throwable);
    }

    public static IStatus createErrorStatus(String message) {
        return Activator.toStatus(4, message, null);
    }

    public static ITheme getTheme() {
        return plugin.getWorkbench().getThemeManager().getCurrentTheme();
    }

    public static Font getFont(String id) {
        return Activator.getTheme().getFontRegistry().get(id);
    }

    public static Font getBoldFont(String id) {
        return Activator.getTheme().getFontRegistry().getBold(id);
    }

    public Activator() {
        Activator.setActivator(this);
    }

    private static void setActivator(Activator a) {
        plugin = a;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        ((Dictionary)props).put("listener.symbolic.name", context.getBundle().getSymbolicName());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
        this.setupRepoChangeScanner();
        this.setupRepoIndexRefresh();
        this.setupFocusHandling();
        this.setupCredentialsProvider();
        ConfigurationChecker.checkConfiguration();
        this.registerTemplateVariableResolvers();
    }

    private void setupCredentialsProvider() {
        CredentialsProvider.setDefault((CredentialsProvider)new EGitCredentialsProvider());
    }

    private void registerTemplateVariableResolvers() {
        if (Activator.hasJavaPlugin()) {
            ContextTypeRegistry codeTemplateContextRegistry = JavaPlugin.getDefault().getCodeTemplateContextRegistry();
            Iterator ctIter = codeTemplateContextRegistry.contextTypes();
            while (ctIter.hasNext()) {
                TemplateContextType contextType = (TemplateContextType)ctIter.next();
                contextType.addResolver((TemplateVariableResolver)new GitTemplateVariableResolver("git_config", UIText.GitTemplateVariableResolver_GitConfigDescription));
            }
        }
    }

    static boolean isActive() {
        return Activator.getDefault().uiIsActive;
    }

    private void setupFocusHandling() {
        this.focusListener = new IWindowListener(){

            private void updateUiState() {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean wasActive = Activator.this.uiIsActive;
                        Activator.this.uiIsActive = Display.getCurrent().getActiveShell() != null;
                        if (Activator.this.uiIsActive != wasActive && GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                            this.traceUiIsActive();
                        }
                    }

                    private void traceUiIsActive() {
                        StringBuilder message = new StringBuilder("workbench is ");
                        message.append(Activator.this.uiIsActive ? "active" : "inactive");
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), message.toString());
                    }
                });
            }

            public void windowOpened(IWorkbenchWindow window) {
                this.updateUiState();
            }

            public void windowDeactivated(IWorkbenchWindow window) {
                this.updateUiState();
            }

            public void windowClosed(IWorkbenchWindow window) {
                this.updateUiState();
            }

            public void windowActivated(IWorkbenchWindow window) {
                this.updateUiState();
                Activator.this.rcs.schedule(500L);
                Activator.this.refreshJob.triggerRefresh();
            }
        };
        Job job = new Job(UIText.Activator_setupFocusListener){

            protected IStatus run(IProgressMonitor monitor) {
                if (PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().addWindowListener(Activator.this.focusListener);
                } else {
                    this.schedule(1000L);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void optionsChanged(DebugOptions options) {
        this.debugOptions = options;
        GitTraceLocation.initializeFromOptions(options, this.isDebugging());
    }

    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    private void setupRepoIndexRefresh() {
        this.refreshJob = new ResourceRefreshJob();
        this.refreshHandle = Repository.getGlobalListenerList().addWorkingTreeModifiedListener((WorkingTreeModifiedListener)this.refreshJob);
    }

    public static synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static synchronized void removePropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public static synchronized void broadcastPropertyChange(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    private void setupRepoChangeScanner() {
        this.rcs = new RepositoryChangeScanner();
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.rcs);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.refreshHandle != null) {
            this.refreshHandle.remove();
            this.refreshHandle = null;
        }
        if (this.focusListener != null) {
            if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().removeWindowListener(this.focusListener);
            }
            this.focusListener = null;
        }
        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Trying to cancel " + this.rcs.getName() + " job");
        }
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.rcs);
        this.rcs.setReschedule(false);
        this.rcs.cancel();
        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Trying to cancel " + this.refreshJob.getName() + " job");
        }
        this.refreshJob.cancel();
        this.rcs.join();
        this.refreshJob.join();
        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Jobs terminated");
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        super.stop(context);
        plugin = null;
    }

    protected void saveDialogSettings() {
        KnownHosts.store();
        super.saveDialogSettings();
    }

    public RepositoryUtil getRepositoryUtil() {
        return org.eclipse.egit.core.Activator.getDefault().getRepositoryUtil();
    }

    public synchronized ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display == null) {
                throw new IllegalStateException();
            }
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)display));
        }
        return this.resourceManager;
    }

    public static final boolean hasJavaPlugin() {
        try {
            return Class.forName("org.eclipse.jdt.internal.ui.JavaPlugin") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static class RepositoryChangeScanner
    extends Job
    implements IPropertyChangeListener {
        private volatile boolean doReschedule;
        private int interval;
        private final RepositoryCache repositoryCache;
        private final IndexChangedListener listener = event -> {
            if (event.isInternal()) {
                return;
            }
            Repository repository = event.getRepository();
            if (repository.isBare()) {
                return;
            }
            ArrayList<String> directories = new ArrayList<String>();
            IProject[] iProjectArray = RuleUtil.getProjects((Repository)repository);
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                String repoRelativePath;
                RepositoryMapping mapping;
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && (mapping = RepositoryMapping.getMapping((IProject)project)) != null && repository == mapping.getRepository() && (repoRelativePath = mapping.getRepoRelativePath((IResource)project)) != null) {
                    if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Scanning project " + project.getName());
                    }
                    try {
                        Throwable throwable = null;
                        Object var10_12 = null;
                        try (TreeWalk w = new TreeWalk(repository);){
                            w.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
                            if (!repoRelativePath.isEmpty()) {
                                w.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{repoRelativePath}));
                            } else {
                                directories.add("/");
                            }
                            w.setRecursive(false);
                            while (w.next()) {
                                FileTreeIterator iter;
                                if (!w.isSubtree() || (iter = (FileTreeIterator)w.getTree(0, FileTreeIterator.class)) == null || iter.isEntryIgnored()) continue;
                                directories.add(String.valueOf(w.getPathString()) + '/');
                                w.enterSubtree();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Scanned project " + project.getName());
                    }
                }
                ++n2;
            }
            if (directories.isEmpty()) {
                return;
            }
            repository.fireEvent((RepositoryEvent)new WorkingTreeModifiedEvent(directories, null));
        };

        RepositoryChangeScanner() {
            super(UIText.Activator_repoScanJobName);
            this.setRule(new RepositoryCacheRule());
            this.setSystem(true);
            this.setUser(false);
            this.repositoryCache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
            this.updateRefreshInterval();
        }

        public boolean shouldSchedule() {
            return this.doReschedule;
        }

        public boolean shouldRun() {
            return this.doReschedule;
        }

        void setReschedule(boolean reschedule) {
            this.doReschedule = reschedule;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (Activator.getDefault().getPreferenceStore().getBoolean("refesh_only_when_active") && !Activator.isActive()) {
                monitor.done();
                return Status.OK_STATUS;
            }
            Repository[] repos = this.repositoryCache.getAllRepositories();
            if (repos.length == 0) {
                return Status.OK_STATUS;
            }
            monitor.beginTask(UIText.Activator_scanningRepositories, repos.length);
            try {
                try {
                    Repository[] repositoryArray = repos;
                    int n = repos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Repository repo = repositoryArray[n2];
                        if (monitor.isCanceled()) {
                            break;
                        }
                        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Scanning " + repo + " for changes");
                        }
                        if (!repo.isBare()) {
                            ListenerHandle handle = null;
                            try {
                                handle = repo.getListenerList().addIndexChangedListener(this.listener);
                                repo.scanForRepoChanges();
                            }
                            finally {
                                if (handle != null) {
                                    handle.remove();
                                }
                            }
                        }
                        monitor.worked(1);
                        ++n2;
                    }
                }
                catch (IOException e) {
                    if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Stopped rescheduling " + this.getName() + "job");
                    }
                    IStatus iStatus = Activator.createErrorStatus(UIText.Activator_scanError, e);
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Rescheduling " + this.getName() + " job");
            }
            this.schedule(this.interval);
            return Status.OK_STATUS;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!"refesh_index_interval".equals(event.getProperty())) {
                return;
            }
            this.updateRefreshInterval();
        }

        private void updateRefreshInterval() {
            this.interval = RepositoryChangeScanner.getRefreshIndexInterval();
            this.setReschedule(this.interval > 0);
            this.cancel();
            this.schedule(this.interval);
        }

        private static int getRefreshIndexInterval() {
            return 1000 * Activator.getDefault().getPreferenceStore().getInt("refesh_index_interval");
        }
    }

    static class ResourceRefreshJob
    extends Job
    implements WorkingTreeModifiedListener {
        private Map<File, WorkingTreeChanges> repositoriesChanged = new LinkedHashMap<File, WorkingTreeChanges>();

        ResourceRefreshJob() {
            super(UIText.Activator_refreshJobName);
            this.setUser(false);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public IStatus run(IProgressMonitor monitor) {
            block19: {
                try {
                    ArrayList<WorkingTreeChanges> changes;
                    Map<File, WorkingTreeChanges> map = this.repositoriesChanged;
                    synchronized (map) {
                        block18: {
                            if (!this.repositoriesChanged.isEmpty()) break block18;
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        changes = new ArrayList<WorkingTreeChanges>(this.repositoriesChanged.values());
                        this.repositoriesChanged.clear();
                    }
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)changes.size());
                    try {
                        for (WorkingTreeChanges change : changes) {
                            this.refreshRepository(change, (IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (OperationCanceledException oe) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                    catch (CoreException e) {
                        Activator.handleError(UIText.Activator_refreshFailed, e, false);
                        Status status = new Status(4, Activator.getPluginId(), e.getMessage());
                        monitor.done();
                        return status;
                    }
                    if (monitor.isCanceled()) break block19;
                    Map<File, WorkingTreeChanges> map2 = this.repositoriesChanged;
                    synchronized (map2) {
                        if (!this.repositoriesChanged.isEmpty()) {
                            this.schedule(100L);
                        }
                        break block19;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    monitor.done();
                }
            }
            return Status.OK_STATUS;
        }

        private void refreshRepository(WorkingTreeChanges changes, IProgressMonitor monitor) throws CoreException {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (changes.isEmpty()) {
                return;
            }
            Set<IPath> roots = this.getProjectLocations(changes.getWorkTree());
            if (roots.isEmpty()) {
                return;
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            Path workTree = new Path(changes.getWorkTree().getPath());
            Map<IResource, Boolean> toRefresh = this.computeResources(changes.getModified(), changes.getDeleted(), (IPath)workTree, roots, (IProgressMonitor)progress.newChild(1));
            if (toRefresh.isEmpty()) {
                return;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable operation = arg_0 -> ResourceRefreshJob.lambda$0(toRefresh, (IPath)workTree, arg_0);
            workspace.run(operation, null, 1, (IProgressMonitor)progress.newChild(1));
        }

        private Set<IPath> getProjectLocations(File workTree) {
            IProject[] projects = RuleUtil.getProjects((File)workTree);
            if (projects == null) {
                return Collections.emptySet();
            }
            HashSet<IPath> result = new HashSet<IPath>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path;
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && (path = project.getLocation()) != null) {
                    result.add(path);
                }
                ++n2;
            }
            return result;
        }

        private Map<IResource, Boolean> computeResources(Set<String> modified, Set<String> deleted, IPath workTree, Set<IPath> roots, IProgressMonitor monitor) {
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Calculating refresh for repository " + workTree + ' ' + modified.size() + ' ' + deleted.size());
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(modified.size() + deleted.size()));
            HashSet fullRefreshes = new HashSet();
            HashMap handled = new HashMap();
            HashMap<IResource, Boolean> result = new HashMap<IResource, Boolean>();
            Stream.concat(modified.stream(), deleted.stream()).forEach(path -> {
                IPath containerPath;
                boolean isFile;
                IPath filePath;
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IPath iPath2 = filePath = "/".equals(path) ? workTree : workTree.append(path);
                if (fullRefreshes.stream().anyMatch(full -> full.isPrefixOf(filePath)) || !roots.stream().anyMatch(root -> root.isPrefixOf(filePath))) {
                    progress.worked(1);
                    return;
                }
                if (path.endsWith("/")) {
                    isFile = false;
                    containerPath = filePath.removeTrailingSeparator();
                } else {
                    isFile = true;
                    containerPath = filePath.removeLastSegments(1);
                }
                if (!handled.containsKey(containerPath)) {
                    if (!isFile && containerPath != null) {
                        IContainer container = ResourceUtil.getContainerForLocation((IPath)containerPath, (boolean)false);
                        if (container != null) {
                            IFile file = (IFile)handled.get(containerPath);
                            handled.put(containerPath, null);
                            if (file != null) {
                                result.remove(file);
                            }
                            result.put((IResource)container, Boolean.FALSE);
                        }
                    } else if (isFile) {
                        String lastPart = filePath.lastSegment();
                        while (containerPath != null && workTree.isPrefixOf(containerPath)) {
                            IContainer container = ResourceUtil.getContainerForLocation((IPath)containerPath, (boolean)false);
                            if (container == null) {
                                lastPart = containerPath.lastSegment();
                                containerPath = containerPath.removeLastSegments(1);
                                isFile = false;
                                continue;
                            }
                            if (container.getType() == 8) {
                                containerPath = containerPath.append(lastPart);
                                fullRefreshes.add(containerPath);
                                handled.put(containerPath, null);
                            } else if (isFile) {
                                IFile file = container.getFile((IPath)new Path(lastPart));
                                handled.put(containerPath, file);
                                result.put((IResource)file, Boolean.FALSE);
                            } else {
                                container = container.getFolder((IPath)new Path(lastPart));
                                containerPath = containerPath.append(lastPart);
                                fullRefreshes.add(containerPath);
                                handled.put(containerPath, null);
                                result.put((IResource)container, Boolean.TRUE);
                            }
                            break;
                        }
                    }
                } else {
                    IFile file = (IFile)handled.get(containerPath);
                    if (file != null) {
                        handled.put(containerPath, null);
                        result.remove(file);
                        result.put((IResource)file.getParent(), Boolean.FALSE);
                    }
                }
                progress.worked(1);
            });
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Calculated refresh for repository " + workTree);
            }
            return result;
        }

        public void onWorkingTreeModified(WorkingTreeModifiedEvent event) {
            if (Activator.getDefault().getPreferenceStore().getBoolean("refesh_on_index_change")) {
                this.mayTriggerRefresh(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mayTriggerRefresh(WorkingTreeModifiedEvent event) {
            if (event.isEmpty()) {
                return;
            }
            Repository repo = event.getRepository();
            if (repo == null || repo.isBare()) {
                return;
            }
            File gitDir = repo.getDirectory();
            Map<File, WorkingTreeChanges> map = this.repositoriesChanged;
            synchronized (map) {
                WorkingTreeChanges changes = this.repositoriesChanged.get(gitDir);
                if (changes == null) {
                    this.repositoriesChanged.put(gitDir, new WorkingTreeChanges(event));
                } else {
                    changes.merge(event);
                    if (changes.isEmpty()) {
                        this.repositoriesChanged.remove(gitDir);
                    }
                }
            }
            if (!Activator.getDefault().getPreferenceStore().getBoolean("refesh_only_when_active") || Activator.isActive()) {
                this.triggerRefresh();
            }
        }

        void triggerRefresh() {
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Triggered refresh");
            }
            this.schedule();
        }

        private static /* synthetic */ void lambda$0(Map map, IPath iPath, IProgressMonitor innerMonitor) throws CoreException {
            SubMonitor innerProgress = SubMonitor.convert((IProgressMonitor)innerMonitor, (int)map.size());
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Refreshing repository " + iPath + ' ' + map.size());
            }
            for (Map.Entry entry : map.entrySet()) {
                ((IResource)entry.getKey()).refreshLocal((Boolean)entry.getValue() != false ? 2 : 1, (IProgressMonitor)innerProgress.newChild(1));
            }
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Refreshed repository " + iPath + ' ' + map.size());
            }
        }

        private static class WorkingTreeChanges {
            private final File workTree;
            private final Set<String> modified;
            private final Set<String> deleted;

            public WorkingTreeChanges(WorkingTreeModifiedEvent event) {
                this.workTree = event.getRepository().getWorkTree().getAbsoluteFile();
                this.modified = new HashSet<String>(event.getModified());
                this.deleted = new HashSet<String>(event.getDeleted());
            }

            public File getWorkTree() {
                return this.workTree;
            }

            public Set<String> getModified() {
                return this.modified;
            }

            public Set<String> getDeleted() {
                return this.deleted;
            }

            public boolean isEmpty() {
                return this.modified.isEmpty() && this.deleted.isEmpty();
            }

            public WorkingTreeChanges merge(WorkingTreeModifiedEvent event) {
                this.modified.removeAll(event.getDeleted());
                this.deleted.removeAll(event.getModified());
                this.modified.addAll(event.getModified());
                this.deleted.addAll(event.getDeleted());
                return this;
            }
        }
    }
}

