/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree.provider;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.graph.IGraphView;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.match.impl.NotLoadedFragmentMatch;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.ResourceAttachmentChangeMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.internal.util.ResourceUIUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.provider.IMergeViewerItemContentProvider;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.provider.IMergeViewerItemProviderConfiguration;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.FeatureMapEntryWrapperItemProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

public class TreeMergeViewerItemContentProvider
implements IMergeViewerItemContentProvider {
    public boolean canHandle(Object object) {
        return object instanceof IMergeViewerItem;
    }

    public Object getParent(Object object, IMergeViewerItemProviderConfiguration configuration) {
        IMergeViewerItem mergeViewerItem = (IMergeViewerItem)object;
        IMergeViewerItem ret = null;
        if (mergeViewerItem.getDiff() instanceof ResourceAttachmentChange) {
            ret = this.createBasicContainer((ResourceAttachmentChange)mergeViewerItem.getDiff(), mergeViewerItem, configuration.getAdapterFactory());
        } else {
            Object sideValue = this.getBestSideValue(mergeViewerItem, configuration.getSide());
            Object parent = null;
            ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)configuration.getAdapterFactory().adapt(sideValue, ITreeItemContentProvider.class);
            if (treeItemContentProvider != null) {
                parent = treeItemContentProvider.getParent(sideValue);
            }
            if (parent instanceof EObject) {
                ret = this.createBasicMergeViewerItem((EObject)parent, mergeViewerItem.getSide(), configuration);
            } else if (parent instanceof Resource) {
                ret = this.createParent(mergeViewerItem, (Resource)parent, configuration);
            } else if (sideValue instanceof NotLoadedFragmentMatch) {
                ret = this.createParent(mergeViewerItem, (NotLoadedFragmentMatch)sideValue, configuration);
            }
        }
        return ret;
    }

    public boolean hasChildren(Object object, IMergeViewerItemProviderConfiguration configuration) {
        IMergeViewerItem mergeViewerItem = (IMergeViewerItem)object;
        if (mergeViewerItem.getLeft() instanceof NotLoadedFragmentMatch) {
            NotLoadedFragmentMatch notLoadedFragmentMatch = (NotLoadedFragmentMatch)mergeViewerItem.getLeft();
            return !notLoadedFragmentMatch.getChildren().isEmpty();
        }
        Object sideValue = this.getSideValue(mergeViewerItem, mergeViewerItem.getSide());
        List<Object> children = this.getChildrenFromContentProvider(sideValue, configuration.getAdapterFactory());
        List<Object> otherSideChildren = this.getChildrenFromContentProvider(this.getSideValue(mergeViewerItem, mergeViewerItem.getSide().opposite()), configuration.getAdapterFactory());
        List<? extends Diff> differences = this.collectAndFilterDifferences(otherSideChildren, configuration);
        if (this.hasChildren(mergeViewerItem, differences, children, configuration)) {
            return true;
        }
        EObject bestSideValue = (EObject)this.getBestSideValue(mergeViewerItem, configuration.getSide());
        Match match = configuration.getComparison().getMatch(bestSideValue);
        return this.hasNotLoadedFragmentsItems(match, mergeViewerItem.getSide());
    }

    public Object[] getChildren(Object object, IMergeViewerItemProviderConfiguration configuration) {
        ArrayList ret = Lists.newArrayList();
        IMergeViewerItem mergeViewerItem = (IMergeViewerItem)object;
        if (mergeViewerItem.getLeft() instanceof NotLoadedFragmentMatch) {
            ret.addAll(this.createChildren(mergeViewerItem, (NotLoadedFragmentMatch)mergeViewerItem.getLeft(), configuration));
        } else {
            Object sideValue = this.getSideValue(mergeViewerItem, mergeViewerItem.getSide());
            Object otherSideValue = this.getSideValue(mergeViewerItem, mergeViewerItem.getSide().opposite());
            List<Object> children = this.getChildrenFromContentProvider(sideValue, configuration.getAdapterFactory());
            List<Object> otherSideChildren = this.getChildrenFromContentProvider(otherSideValue, configuration.getAdapterFactory());
            List<? extends Diff> differences = this.collectAndFilterDifferences(otherSideChildren, configuration);
            ret.addAll(this.createChildren(children, mergeViewerItem, differences, configuration));
            EObject bestSideValue = (EObject)this.getBestSideValue(mergeViewerItem, configuration.getSide());
            Match match = configuration.getComparison().getMatch(bestSideValue);
            ret.addAll(this.getNotLoadedFragmentsItems(configuration.getComparison(), match, mergeViewerItem.getSide(), configuration.getAdapterFactory()));
        }
        return ret.toArray();
    }

    protected List<? extends Diff> collectAndFilterDifferences(Iterable<Object> objects, IMergeViewerItemProviderConfiguration configuration) {
        List<Diff> differences = this.collectDifferences(configuration.getComparison(), objects);
        return Lists.newArrayList((Iterable)Iterables.filter(differences, this.visibleContainmentDiffPredicate(configuration)));
    }

    private boolean hasChildren(IMergeViewerItem parent, Iterable<? extends Diff> differences, List<Object> children, IMergeViewerItemProviderConfiguration configuration) {
        if (this.yieldsMergeViewerItem(configuration.getComparison(), parent.getDiff(), children)) {
            return true;
        }
        if (parent.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR) {
            return this.yieldsInsertionPoint(parent, differences, configuration);
        }
        return true;
    }

    private List<IMergeViewerItem> createChildren(IMergeViewerItem parent, NotLoadedFragmentMatch nlfm, IMergeViewerItemProviderConfiguration configuration) {
        ArrayList ret = Lists.newArrayList();
        Collection matches = nlfm.getChildren();
        for (Match match : matches) {
            IMergeViewerItem container = match instanceof NotLoadedFragmentMatch ? this.createMergeViewerItem(configuration.getComparison(), parent.getDiff(), match, match, match, parent.getSide(), configuration.getAdapterFactory()) : this.createMergeViewerItem(configuration.getComparison(), parent.getDiff(), match.getLeft(), match.getRight(), match.getOrigin(), parent.getSide(), configuration.getAdapterFactory());
            ret.add(container);
        }
        return ret;
    }

    private List<IMergeViewerItem> createChildren(Collection<Object> children, IMergeViewerItem parent, List<? extends Diff> differences, IMergeViewerItemProviderConfiguration configuration) {
        ArrayList ret = Lists.newArrayList();
        List<IMergeViewerItem> realChildren = this.createMergeViewerItemsFrom(children, parent, configuration);
        if (parent.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR) {
            ret.addAll(this.createInsertionPoints(parent, realChildren, differences, configuration));
        } else {
            ret.addAll(realChildren);
        }
        return ret;
    }

    protected List<IMergeViewerItem> createInsertionPoints(IMergeViewerItem parent, List<IMergeViewerItem> values, List<? extends Diff> differences, IMergeViewerItemProviderConfiguration configuration) {
        IMergeViewer.MergeViewerSide side = parent.getSide();
        AdapterFactory adapterFactory = configuration.getAdapterFactory();
        List<Object> sideContent = this.getChildrenFromContentProvider(this.getSideValue(parent, side), adapterFactory);
        List<Object> oppositeContent = this.getChildrenFromContentProvider(this.getSideValue(parent, side.opposite()), adapterFactory);
        List<Object> ancestorContent = this.getChildrenFromContentProvider(this.getSideValue(parent, IMergeViewer.MergeViewerSide.ANCESTOR), adapterFactory);
        return this.createInsertionPoints(parent, sideContent, oppositeContent, ancestorContent, values, differences, configuration);
    }

    protected List<IMergeViewerItem> createInsertionPoints(IMergeViewerItem parent, List<Object> sideContent, List<Object> oppositeContent, List<Object> ancestorContent, List<? extends IMergeViewerItem> values, List<? extends Diff> differences, IMergeViewerItemProviderConfiguration configuration) {
        ArrayList ret = Lists.newArrayList(values);
        if (differences.isEmpty()) {
            return ret;
        }
        if (sideContent.isEmpty() && oppositeContent.isEmpty()) {
            return ret;
        }
        Comparison comparison = configuration.getComparison();
        AdapterFactory adapterFactory = configuration.getAdapterFactory();
        IMergeViewer.MergeViewerSide side = parent.getSide();
        for (Diff diff : Lists.reverse(differences)) {
            EObject value = (EObject)this.getDiffValue(diff);
            Match match = comparison.getMatch(value);
            if (this.isPseudoAddConflict(diff) || !this.isAddOnOppositeSide(diff, side) && !this.isDeleteOnSameSide(diff, side) && !this.isInsertOnBothSides(diff, match)) continue;
            if (match == null && AbstractMerger.isInTerminalState((Diff)diff)) {
                EObject bestSideValue = (EObject)this.getBestSideValue(parent, configuration.getSide());
                match = comparison.getMatch(bestSideValue);
                match = this.getMatchWithNullValues(match);
            }
            if (match == null || this.isRealAddConflict(diff, match, side)) continue;
            IMergeViewerItem insertionPoint = this.createMergeViewerItem(comparison, diff, match.getLeft(), match.getRight(), match.getOrigin(), side, adapterFactory);
            int insertionIndex = match.getLeft() == null && match.getRight() == null && diff.getConflict() != null && diff.getConflict().getKind() == ConflictKind.PSEUDO ? ancestorContent.indexOf(value) : Math.min(DiffUtil.findInsertionIndex((Comparison)comparison, oppositeContent, sideContent, (Object)value), ret.size());
            int realIndex = 0;
            int index = 0;
            while (index < insertionIndex && realIndex < ret.size()) {
                if (!((IMergeViewerItem)ret.get(realIndex)).isInsertionPoint()) {
                    ++index;
                }
                ++realIndex;
            }
            ret.add(realIndex, insertionPoint);
        }
        return ret;
    }

    protected Object getDiffValue(Diff diff) {
        Object diffValue = MergeViewerUtil.getDiffValue((Diff)diff);
        if (diffValue != null) {
            return diffValue;
        }
        Set allRefiningDiffs = DiffUtil.getAllRefiningDiffs((Diff)diff);
        Iterable containmentRefs = Iterables.filter((Iterable)allRefiningDiffs, (Predicate)EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE);
        return this.getFirstValue(containmentRefs);
    }

    protected Object getFirstValue(Iterable<Diff> diffs) {
        Iterable values = Iterables.filter((Iterable)Iterables.transform(diffs, (Function)new Function<Diff, Object>(){

            public Object apply(Diff input) {
                return MergeViewerUtil.getDiffValue((Diff)input);
            }
        }), (Predicate)Predicates.notNull());
        if (values.iterator().hasNext()) {
            return values.iterator().next();
        }
        return null;
    }

    private List<Diff> collectDifferences(Comparison comparison, Iterable<Object> objects) {
        Object differences = ImmutableList.of();
        for (Object object : objects) {
            if (!EObject.class.isInstance(object)) continue;
            EList objectDifferences = comparison.getDifferences((EObject)EObject.class.cast(object));
            differences = Iterables.concat((Iterable)differences, (Iterable)objectDifferences);
        }
        return Lists.newArrayList((Iterable)differences);
    }

    protected List<Object> getChildrenFromContentProvider(Object object, AdapterFactory adapterFactory) {
        if (object == null) {
            return Collections.emptyList();
        }
        ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
        if (treeItemContentProvider != null) {
            ArrayList<Object> children = new ArrayList<Object>(treeItemContentProvider.getChildren(object));
            return this.unwrapFeatureMapEntryProviders(children);
        }
        return Collections.emptyList();
    }

    private List<Object> unwrapFeatureMapEntryProviders(List<Object> values) {
        ArrayList<Object> result = new ArrayList<Object>(values.size());
        for (Object value : values) {
            if (FeatureMapEntryWrapperItemProvider.class.isInstance(value)) {
                FeatureMapEntryWrapperItemProvider featureMapEntryProvider = (FeatureMapEntryWrapperItemProvider)FeatureMapEntryWrapperItemProvider.class.cast(value);
                Object featureMapEntry = featureMapEntryProvider.getValue();
                if (!FeatureMap.Entry.class.isInstance(featureMapEntry)) continue;
                Object featureMapValue = ((FeatureMap.Entry)FeatureMap.Entry.class.cast(featureMapEntry)).getValue();
                result.add(featureMapValue);
                continue;
            }
            result.add(value);
        }
        return result;
    }

    protected boolean yieldsInsertionPoint(final IMergeViewerItem parent, Iterable<? extends Diff> diffs, final IMergeViewerItemProviderConfiguration configuration) {
        final IMergeViewer.MergeViewerSide side = parent.getSide();
        final Comparison comparison = configuration.getComparison();
        AdapterFactory adapterFactory = configuration.getAdapterFactory();
        List<Object> sideContent = this.getChildrenFromContentProvider(this.getSideValue(parent, side), adapterFactory);
        List<Object> oppositeContent = this.getChildrenFromContentProvider(this.getSideValue(parent, side.opposite()), adapterFactory);
        if (sideContent.isEmpty() && oppositeContent.isEmpty()) {
            return false;
        }
        return Iterables.any(diffs, (Predicate)new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                if (TreeMergeViewerItemContentProvider.this.isPseudoAddConflict(diff)) {
                    return false;
                }
                EObject value = (EObject)MergeViewerUtil.getDiffValue((Diff)diff);
                Match match = comparison.getMatch(value);
                if (TreeMergeViewerItemContentProvider.this.isAddOnOppositeSide(diff, side) || TreeMergeViewerItemContentProvider.this.isDeleteOnSameSide(diff, side) || TreeMergeViewerItemContentProvider.this.isInsertOnBothSides(diff, match)) {
                    if (match == null && AbstractMerger.isInTerminalState((Diff)diff)) {
                        EObject bestSideValue = (EObject)TreeMergeViewerItemContentProvider.this.getBestSideValue(parent, configuration.getSide());
                        match = comparison.getMatch(bestSideValue);
                        match = TreeMergeViewerItemContentProvider.this.getMatchWithNullValues(match);
                    }
                    return match != null && !TreeMergeViewerItemContentProvider.this.isRealAddConflict(diff, match, side);
                }
                return false;
            }
        });
    }

    protected boolean yieldsMergeViewerItem(Comparison comparison, Diff diff, Collection<?> values) {
        Iterable elements = Iterables.filter(values, EObject.class);
        if (diff != null && !Iterables.isEmpty((Iterable)elements)) {
            return true;
        }
        for (EObject element : elements) {
            Match match = comparison.getMatch(element);
            if (match == null || this.isMatchWithAllProxyData(match)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNotLoadedFragmentsItems(Match match, IMergeViewer.MergeViewerSide side) {
        if (match == null) {
            return false;
        }
        Collection childrenMatches = ResourceUIUtil.getChildrenMatchWithNotLoadedParent((Comparison)match.getComparison(), (Match)match, (IMergeViewer.MergeViewerSide)side);
        return !childrenMatches.isEmpty();
    }

    private IMergeViewerItem createParent(IMergeViewerItem mergeViewerItem, Resource resource, IMergeViewerItemProviderConfiguration configuration) {
        IMergeViewerItem parent;
        URI uri = resource.getURI();
        if (ResourceUIUtil.isFragment((URI)uri)) {
            Object object = this.getBestSideValue(mergeViewerItem, configuration.getSide());
            Match matchOfValue = configuration.getComparison().getMatch((EObject)object);
            if (matchOfValue != null) {
                NotLoadedFragmentMatch notLoadedFragmentMatch = new NotLoadedFragmentMatch(matchOfValue);
                parent = this.createMergeViewerItem(configuration.getComparison(), mergeViewerItem.getDiff(), notLoadedFragmentMatch, notLoadedFragmentMatch, notLoadedFragmentMatch, mergeViewerItem.getSide(), configuration.getAdapterFactory());
            } else {
                parent = null;
            }
        } else {
            parent = null;
        }
        return parent;
    }

    private IMergeViewerItem createParent(IMergeViewerItem mergeViewerItem, NotLoadedFragmentMatch nlfm, IMergeViewerItemProviderConfiguration configuration) {
        IMergeViewerItem parent = null;
        IMergeViewer.MergeViewerSide side = mergeViewerItem.getSide();
        Collection children = nlfm.getChildren();
        for (Match match : children) {
            URI uri = ResourceUIUtil.getDataURI((Match)match, (IMergeViewer.MergeViewerSide)side);
            if (uri == null) continue;
            IGraphView graph = ResourceUIUtil.getResourcesURIGraph();
            URI parentData = (URI)graph.getParentData((Object)uri);
            ResourceSet rs = ResourceUIUtil.getDataResourceSet((Match)match, (IMergeViewer.MergeViewerSide)side);
            Resource resourceParent = ResourceUIUtil.getParent((ResourceSet)rs, (URI)uri);
            while (resourceParent == null && parentData != null) {
                resourceParent = ResourceUIUtil.getParent((ResourceSet)rs, (URI)parentData.trimFragment());
                parentData = (URI)graph.getParentData((Object)parentData.trimFragment());
            }
            if (resourceParent != null && parentData != null) {
                EObject eObjectParent = resourceParent.getEObject(parentData.fragment());
                if (eObjectParent == null) continue;
                parent = this.createBasicMergeViewerItem(eObjectParent, side, configuration);
                break;
            }
            parent = this.createNotLoadedFragmentContainer(rs, uri, configuration.getComparison(), mergeViewerItem.getDiff(), side, configuration.getAdapterFactory());
            if (parent != null) break;
        }
        return parent;
    }

    private IMergeViewerItem createNotLoadedFragmentContainer(ResourceSet rs, URI uri, Comparison comparison, Diff diff, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        IMergeViewerItem parent;
        URI parentURI = ResourceUIUtil.getParentResourceURI((ResourceSet)rs, (URI)uri);
        URI rootResourceURI = ResourceUIUtil.getRootResourceURI((URI)uri);
        if (parentURI == null) {
            parentURI = rootResourceURI;
        }
        ArrayList notLoadedFragmentMatches = Lists.newArrayList();
        EList rootMatches = comparison.getMatches();
        Collection uris = ResourceUIUtil.getDataURIs((Collection)rootMatches, (IMergeViewer.MergeViewerSide)side);
        for (Match rootMatch : rootMatches) {
            URI rootMatchDataURI = ResourceUIUtil.getDataURI((Match)rootMatch, (IMergeViewer.MergeViewerSide)side);
            if (rootResourceURI.equals(rootMatchDataURI) || parentURI.equals(rootMatchDataURI) || !ResourceUIUtil.isChildOf((URI)rootMatchDataURI, (Collection)ImmutableSet.of((Object)parentURI)) || ResourceUIUtil.isChildOf((URI)rootMatchDataURI, (Collection)uris)) continue;
            notLoadedFragmentMatches.add(new NotLoadedFragmentMatch(rootMatch));
        }
        if (notLoadedFragmentMatches.size() > 1) {
            NotLoadedFragmentMatch notLoadedFragmentMatch = new NotLoadedFragmentMatch((Collection)notLoadedFragmentMatches);
            parent = this.createMergeViewerItem(comparison, diff, notLoadedFragmentMatch, notLoadedFragmentMatch, notLoadedFragmentMatch, side, adapterFactory);
        } else {
            parent = null;
        }
        return parent;
    }

    private IMergeViewerItem createBasicMergeViewerItem(EObject eObject, IMergeViewer.MergeViewerSide side, IMergeViewerItemProviderConfiguration configuration) {
        IMergeViewerItem ret = null;
        Comparison comparison = configuration.getComparison();
        Match match = comparison.getMatch(eObject);
        if (match == null) {
            return null;
        }
        EObject expectedValue = MergeViewerUtil.getEObject((Match)match, (IMergeViewer.MergeViewerSide)side);
        if (expectedValue != null) {
            Iterable<? extends Diff> diffs = this.getDiffsWithValue(expectedValue, side, match, configuration);
            Diff diff = (Diff)Iterables.getFirst(diffs, null);
            ret = this.createMergeViewerItem(comparison, diff, match, side, configuration.getAdapterFactory());
        } else {
            expectedValue = MergeViewerUtil.getEObject((Match)match, (IMergeViewer.MergeViewerSide)side.opposite());
            Iterable<Object> diffs = Lists.newArrayList();
            if (expectedValue != null) {
                diffs = this.getDiffsWithValue(expectedValue, side, match, configuration);
            }
            if (Iterables.isEmpty((Iterable)diffs) && (expectedValue = MergeViewerUtil.getEObject((Match)match, (IMergeViewer.MergeViewerSide)IMergeViewer.MergeViewerSide.ANCESTOR)) != null) {
                diffs = this.getDiffsWithValue(expectedValue, side, match, configuration);
            }
            if (!Iterables.isEmpty((Iterable)diffs)) {
                Diff diff = (Diff)Iterables.getFirst((Iterable)diffs, null);
                ret = diff instanceof ResourceAttachmentChange ? this.createMergeViewerItem(comparison, diff, match, side, configuration.getAdapterFactory()) : this.createInsertionPoint(comparison, diff, side, configuration.getAdapterFactory());
            }
        }
        return ret;
    }

    private IMergeViewerItem createInsertionPoint(Comparison comparison, Diff diff, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        Object left = MergeViewerUtil.getValueFromDiff((Diff)diff, (IMergeViewer.MergeViewerSide)IMergeViewer.MergeViewerSide.LEFT);
        Object right = MergeViewerUtil.getValueFromDiff((Diff)diff, (IMergeViewer.MergeViewerSide)IMergeViewer.MergeViewerSide.RIGHT);
        IMergeViewerItem insertionPoint = null;
        if (left != null || right != null) {
            boolean rightEmptyBox;
            boolean leftEmptyBox = side == IMergeViewer.MergeViewerSide.LEFT && (left == null || !MergeViewerUtil.getValues((Diff)diff, (IMergeViewer.MergeViewerSide)side).contains(left));
            boolean bl = rightEmptyBox = side == IMergeViewer.MergeViewerSide.RIGHT && (right == null || !MergeViewerUtil.getValues((Diff)diff, (IMergeViewer.MergeViewerSide)side).contains(right));
            if (leftEmptyBox || rightEmptyBox) {
                Object ancestor = MergeViewerUtil.getValueFromDiff((Diff)diff, (IMergeViewer.MergeViewerSide)IMergeViewer.MergeViewerSide.ANCESTOR);
                insertionPoint = this.createMergeViewerItem(comparison, diff, left, right, ancestor, side, adapterFactory);
            }
        }
        return insertionPoint;
    }

    private Match getMatchWithNullValues(Match match) {
        if (match != null) {
            for (Match subMatch : match.getSubmatches()) {
                if (subMatch.getLeft() != null || subMatch.getRight() != null) continue;
                return subMatch;
            }
        }
        return null;
    }

    private boolean isInsertOnBothSides(Diff diff, Match match) {
        return diff.getState() == DifferenceState.MERGED && (match == null || match.getLeft() == null && match.getRight() == null);
    }

    private boolean isPseudoAddConflict(Diff diff) {
        Conflict conflict = diff.getConflict();
        return conflict != null && conflict.getKind() == ConflictKind.PSEUDO && diff.getKind() == DifferenceKind.ADD;
    }

    private boolean isRealAddConflict(Diff diff, Match match, IMergeViewer.MergeViewerSide side) {
        return match.getRight() != null && match.getLeft() != null && this.isAddOnOppositeSide(diff, side);
    }

    private boolean isAddOnOppositeSide(Diff diff, IMergeViewer.MergeViewerSide side) {
        if (diff.getState() != DifferenceState.MERGED && diff.getKind() == DifferenceKind.ADD) {
            DifferenceSource source = diff.getSource();
            return source == DifferenceSource.LEFT && side == IMergeViewer.MergeViewerSide.RIGHT || source == DifferenceSource.RIGHT && side == IMergeViewer.MergeViewerSide.LEFT;
        }
        return false;
    }

    private boolean isDeleteOnSameSide(Diff diff, IMergeViewer.MergeViewerSide side) {
        if (diff.getState() != DifferenceState.DISCARDED && diff.getKind() == DifferenceKind.DELETE) {
            DifferenceSource source = diff.getSource();
            return source == DifferenceSource.LEFT && side == IMergeViewer.MergeViewerSide.LEFT || source == DifferenceSource.RIGHT && side == IMergeViewer.MergeViewerSide.RIGHT;
        }
        return false;
    }

    private Iterable<? extends Diff> getDiffsWithValue(EObject expectedValue, IMergeViewer.MergeViewerSide side, Match parentMatch, IMergeViewerItemProviderConfiguration configuration) {
        Diff diff;
        Iterable diffs = this.getVisibleContainmentDiffs(expectedValue, configuration);
        if (Iterables.size(diffs) > 1 && side != IMergeViewer.MergeViewerSide.ANCESTOR) {
            diffs = Iterables.filter(diffs, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)side.convertToDifferenceSource()));
        }
        if ((diff = (Diff)Iterables.getFirst(diffs, null)) == null) {
            diffs = Iterables.filter((Iterable)parentMatch.getDifferences(), (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class));
        }
        return diffs;
    }

    protected Iterable<? extends Diff> getVisibleContainmentDiffs(EObject object, IMergeViewerItemProviderConfiguration configuration) {
        EList differences = configuration.getComparison().getDifferences(object);
        return Iterables.filter((Iterable)differences, this.visibleContainmentDiffPredicate(configuration));
    }

    protected Object getBestSideValue(IMergeViewerItem mergeViewerItem, IMergeViewer.MergeViewerSide side) {
        Object sideValue;
        if (side != IMergeViewer.MergeViewerSide.ANCESTOR) {
            sideValue = this.getSideValue(mergeViewerItem, side);
            if (sideValue == null && (sideValue = this.getSideValue(mergeViewerItem, side.opposite())) == null) {
                sideValue = this.getSideValue(mergeViewerItem, IMergeViewer.MergeViewerSide.ANCESTOR);
            }
        } else {
            sideValue = this.getSideValue(mergeViewerItem, IMergeViewer.MergeViewerSide.ANCESTOR);
            if (sideValue == null && (sideValue = this.getSideValue(mergeViewerItem, IMergeViewer.MergeViewerSide.LEFT)) == null) {
                sideValue = this.getSideValue(mergeViewerItem, IMergeViewer.MergeViewerSide.RIGHT);
            }
        }
        return sideValue;
    }

    protected Object getSideValue(IMergeViewerItem mergeViewerItem, IMergeViewer.MergeViewerSide side) {
        switch (side) {
            case LEFT: {
                return mergeViewerItem.getLeft();
            }
            case RIGHT: {
                return mergeViewerItem.getRight();
            }
            case ANCESTOR: {
                return mergeViewerItem.getAncestor();
            }
        }
        throw new IllegalStateException();
    }

    protected IMergeViewerItem createBasicContainer(ResourceAttachmentChange diff, IMergeViewerItem mergeViewerItem, AdapterFactory adapterFactory) {
        Comparison comparison = diff.getMatch().getComparison();
        IMergeViewer.MergeViewerSide side = mergeViewerItem.getSide();
        Resource left = MergeViewerUtil.getResource((Comparison)comparison, (IMergeViewer.MergeViewerSide)IMergeViewer.MergeViewerSide.LEFT, (Diff)diff);
        Resource right = MergeViewerUtil.getResource((Comparison)comparison, (IMergeViewer.MergeViewerSide)IMergeViewer.MergeViewerSide.RIGHT, (Diff)diff);
        Resource ancestor = MergeViewerUtil.getResource((Comparison)comparison, (IMergeViewer.MergeViewerSide)IMergeViewer.MergeViewerSide.ANCESTOR, (Diff)diff);
        ResourceAttachmentChangeMergeViewerItem ret = new ResourceAttachmentChangeMergeViewerItem(comparison, null, left, right, ancestor, side, adapterFactory);
        return ret;
    }

    private List<IMergeViewerItem> getNotLoadedFragmentsItems(Comparison comparison, Match match, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        if (match == null) {
            return Collections.emptyList();
        }
        ArrayList ret = Lists.newArrayList();
        Collection childrenMatches = ResourceUIUtil.getChildrenMatchWithNotLoadedParent((Comparison)comparison, (Match)match, (IMergeViewer.MergeViewerSide)side);
        if (!childrenMatches.isEmpty()) {
            boolean setNames = childrenMatches.size() > 1;
            for (Match child : childrenMatches) {
                NotLoadedFragmentMatch notLoadedFragmentMatch = new NotLoadedFragmentMatch(child);
                if (setNames) {
                    notLoadedFragmentMatch.setName(ResourceUIUtil.getResourceName((NotLoadedFragmentMatch)notLoadedFragmentMatch));
                }
                IMergeViewerItem notLoadedFragmentItem = this.createMergeViewerItem(comparison, null, notLoadedFragmentMatch, notLoadedFragmentMatch, notLoadedFragmentMatch, side, adapterFactory);
                ret.add(notLoadedFragmentItem);
            }
        }
        return ret;
    }

    protected Predicate<Diff> visibleContainmentDiffPredicate(IMergeViewerItemProviderConfiguration configuration) {
        return Predicates.and((Predicate)Predicates.or((Predicate)EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE, (Predicate)EMFComparePredicates.anyRefining((Predicate)EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE)), this.visibleInMergeViewerPredicate((Predicate<? super EObject>)configuration.getDifferenceFilterPredicate(), configuration.getDifferenceGroupProvider()));
    }

    protected Predicate<Diff> visibleInMergeViewerPredicate(final Predicate<? super EObject> predicate, final IDifferenceGroupProvider groupProvider) {
        if (predicate == null) {
            return Predicates.alwaysTrue();
        }
        return new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                return MergeViewerUtil.isVisibleInMergeViewer((Diff)diff, (IDifferenceGroupProvider)groupProvider, (Predicate)predicate);
            }
        };
    }

    protected List<IMergeViewerItem> createMergeViewerItemsFrom(Collection<?> values, IMergeViewerItem parent, IMergeViewerItemProviderConfiguration configuration) {
        ArrayList ret = Lists.newArrayListWithCapacity((int)values.size());
        for (EObject value : Iterables.filter(values, EObject.class)) {
            IMergeViewerItem valueToAdd;
            Match match = configuration.getComparison().getMatch(value);
            if (match == null || this.isMatchWithAllProxyData(match) || (valueToAdd = this.createMergeViewerItemFrom(value, parent, configuration)) == null) continue;
            ret.add(valueToAdd);
        }
        return ret;
    }

    private boolean isMatchWithAllProxyData(Match match) {
        boolean proxy = false;
        EObject left = match.getLeft();
        EObject right = match.getRight();
        EObject origin = match.getOrigin();
        if (left != null && right != null && left.eIsProxy() && right.eIsProxy()) {
            proxy = true;
        }
        if (proxy && match.getComparison().isThreeWay() && (origin == null || !origin.eIsProxy())) {
            proxy = false;
        }
        return proxy;
    }

    protected IMergeViewerItem createMergeViewerItemFrom(EObject eObject, IMergeViewerItem parent, IMergeViewerItemProviderConfiguration configuration) {
        Comparison comparison = configuration.getComparison();
        AdapterFactory adapterFactory = configuration.getAdapterFactory();
        Match match = comparison.getMatch(eObject);
        IMergeViewer.MergeViewerSide side = parent.getSide();
        Diff diff = (Diff)Iterables.getFirst(this.getVisibleContainmentDiffs(eObject, configuration), null);
        if (match != null) {
            return this.createMergeViewerItem(comparison, diff, match, side, adapterFactory);
        }
        switch (side) {
            case LEFT: {
                return this.createMergeViewerItem(comparison, diff, eObject, null, null, side, adapterFactory);
            }
            case RIGHT: {
                return this.createMergeViewerItem(comparison, diff, null, eObject, null, side, adapterFactory);
            }
            case ANCESTOR: {
                return this.createMergeViewerItem(comparison, diff, null, null, eObject, side, adapterFactory);
            }
        }
        throw new IllegalStateException();
    }

    protected IMergeViewerItem createMergeViewerItem(Comparison comparison, Diff diff, Object left, Object right, Object ancestor, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        return new MergeViewerItem(comparison, diff, left, right, ancestor, side, adapterFactory);
    }

    protected IMergeViewerItem createMergeViewerItem(Comparison comparison, Diff diff, Match match, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        return this.createMergeViewerItem(comparison, diff, match.getLeft(), match.getRight(), match.getOrigin(), side, adapterFactory);
    }
}

