/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.GroupItemProviderAdapter;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractMergeContainedAction
extends MergeAction {
    protected Predicate<TreeNode> isFiltered;

    private static Function<TreeNode, Iterable<Diff>> treeNodesToLeafDiffs(final Predicate<TreeNode> isFiltered) {
        return new Function<TreeNode, Iterable<Diff>>(){

            public Iterable<Diff> apply(TreeNode input) {
                TreeIterator allContents = input.eAllContents();
                ImmutableList.Builder builder = new ImmutableList.Builder();
                while (allContents.hasNext()) {
                    TreeNode treeNode;
                    EObject data;
                    EObject eObject = (EObject)allContents.next();
                    if (!(eObject instanceof TreeNode) || !((data = (EObject)IDifferenceGroup.TREE_NODE_DATA.apply((Object)(treeNode = (TreeNode)eObject))) instanceof Diff) || isFiltered.apply((Object)treeNode)) continue;
                    builder.add((Object)((Diff)data));
                }
                return builder.build();
            }
        };
    }

    public AbstractMergeContainedAction(IEMFCompareConfiguration compareConfiguration, IMerger.Registry mergerRegistry, MergeMode mode, INavigatable navigatable) {
        super(compareConfiguration, mergerRegistry, mode, navigatable);
    }

    public AbstractMergeContainedAction(IEMFCompareConfiguration compareConfiguration, IMerger.Registry mergerRegistry, MergeMode mode, INavigatable navigatable, IStructuredSelection selection) {
        super(compareConfiguration, mergerRegistry, mode, navigatable, selection);
    }

    protected abstract Predicate<Diff> getDiffPredicate();

    @Override
    protected boolean updateSelection(IStructuredSelection selection) {
        super.updateSelection(selection);
        return !this.getSelectedDifferences().isEmpty();
    }

    @Override
    protected Iterable<Diff> getSelectedDifferences(IStructuredSelection selection) {
        List selectedObjects = selection.toList();
        Object firstElement = selection.getFirstElement();
        if (selection.getFirstElement() instanceof GroupItemProviderAdapter) {
            ArrayList effectiveSelectedObjects = Lists.newArrayList();
            effectiveSelectedObjects.addAll(((GroupItemProviderAdapter)firstElement).getChildren(firstElement));
            Iterable selectedTreeNodes = Iterables.filter((Iterable)effectiveSelectedObjects, TreeNode.class);
            Iterable diffs = Iterables.concat((Iterable)Iterables.transform((Iterable)selectedTreeNodes, AbstractMergeContainedAction.treeNodesToLeafDiffs(this.isFiltered)));
            return Iterables.filter(this.getSelectedDifferences(diffs), this.getDiffPredicate());
        }
        Iterable selectedAdapters = Iterables.filter((Iterable)selectedObjects, Adapter.class);
        Iterable selectedNotifiers = Iterables.transform((Iterable)selectedAdapters, (Function)ADAPTER__TARGET);
        Iterable selectedTreeNodes = Iterables.filter((Iterable)selectedNotifiers, TreeNode.class);
        Iterable diffs = Iterables.concat((Iterable)Iterables.transform((Iterable)selectedTreeNodes, AbstractMergeContainedAction.treeNodesToLeafDiffs(this.isFiltered)));
        return Iterables.filter(this.getSelectedDifferences(diffs), this.getDiffPredicate());
    }
}

