/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAnnotationValidator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EModelElementItemProvider;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.provider.annotation.EAnnotationItemProviderAdapterFactory;
import org.eclipse.emf.ecore.util.BasicEAnnotationValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.EcoreValidator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EAnnotationItemProvider
extends EModelElementItemProvider {
    public EAnnotationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected ComposeableAdapterFactory getRootAdapterFactory() {
        return ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory();
    }

    protected EAnnotationItemProviderAdapterFactory getEAnnotationItemProviderAdapterFactory() {
        return this.adapterFactory instanceof EAnnotationItemProviderAdapterFactory ? (EAnnotationItemProviderAdapterFactory)this.adapterFactory : null;
    }

    protected BasicEAnnotationValidator.Assistant getAssistant() {
        EAnnotationItemProviderAdapterFactory eAnnotationItemProviderAdapterFactory = this.getEAnnotationItemProviderAdapterFactory();
        return eAnnotationItemProviderAdapterFactory == null ? null : eAnnotationItemProviderAdapterFactory.getAssistant();
    }

    protected List<IItemPropertyDescriptor> getPropertyDescriptorsGen(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addSourcePropertyDescriptor(object);
            this.addReferencesPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.getEAnnotationItemProviderAdapterFactory() != null) {
            this.itemPropertyDescriptors = null;
        }
        List<IItemPropertyDescriptor> propertyDescriptors = this.getPropertyDescriptorsGen(object);
        return propertyDescriptors;
    }

    protected void addSourcePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new SourcePropertyDescriptor());
    }

    protected void addReferencesPropertyDescriptor(Object object) {
        EAnnotation eAnnotation;
        BasicEAnnotationValidator.Assistant assistant = this.getAssistant();
        if (assistant != null && !assistant.isReferencesSupported(eAnnotation = (EAnnotation)object) && eAnnotation.getReferences().isEmpty()) {
            return;
        }
        this.itemPropertyDescriptors.add(new ReferencesPropertyDescriptor());
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(EcorePackage.Literals.EANNOTATION__DETAILS);
            this.childrenFeatures.add(EcorePackage.Literals.EANNOTATION__CONTENTS);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        EStructuralFeature childFeature = super.getChildFeature(object, child);
        BasicEAnnotationValidator.Assistant assistant = this.getAssistant();
        if (assistant != null) {
            EAnnotation eAnnotation = (EAnnotation)object;
            if (child instanceof EAnnotation) {
                EAnnotation nestedEAnnotation = (EAnnotation)child;
                if (assistant.getValidAnnotations(eAnnotation, Collections.singletonList(nestedEAnnotation)).contains(nestedEAnnotation)) {
                    return EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS;
                }
                if (childFeature == EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS) {
                    return null;
                }
            }
            if (child instanceof EObject) {
                if (assistant.getValidContents(eAnnotation, Collections.singletonList((EObject)child)).contains(child)) {
                    return EcorePackage.Literals.EANNOTATION__CONTENTS;
                }
                if (childFeature == EcorePackage.Literals.EANNOTATION__CONTENTS) {
                    return null;
                }
            }
        }
        return childFeature;
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/EAnnotation"));
    }

    @Override
    public String getText(Object object) {
        EAnnotation eAnnotation = (EAnnotation)object;
        StringBuilder result = new StringBuilder();
        String source = eAnnotation.getSource();
        if (source != null) {
            int index;
            int n = index = this.getParent(eAnnotation) instanceof EAnnotation ? -1 : source.lastIndexOf("/");
            if (index == -1) {
                result.append(source);
            } else {
                result.append(source.substring(index + 1));
            }
        }
        return result.toString();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(EAnnotation.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 2: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        BasicEAnnotationValidator.Assistant assistant = this.getAssistant();
        if (assistant != null) {
            EAnnotation eAnnotation = (EAnnotation)object;
            Collection validContents = assistant.getValidContents(eAnnotation, Collections.emptyList());
            for (EObject validContent : validContents) {
                newChildDescriptors.add(this.createChildParameter(EcorePackage.Literals.EANNOTATION__CONTENTS, validContent));
            }
            Collection validAnnotations = assistant.getValidAnnotations(eAnnotation, Collections.emptyList());
            for (EAnnotation validAnnotation : validAnnotations) {
                newChildDescriptors.add(this.createChildParameter(EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS, validAnnotation));
            }
        }
        newChildDescriptors.add(this.createChildParameter(EcorePackage.Literals.EANNOTATION__DETAILS, EcoreFactory.eINSTANCE.create(EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY)));
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        EAnnotation nestedEAnnotation;
        String text;
        String result = super.getCreateChildText(owner, feature, child, selection);
        if (feature == EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS && (text = this.getText(nestedEAnnotation = (EAnnotation)child)).length() != 0) {
            result = String.valueOf(result) + " - " + text;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GroupPropertyDescriptor
    implements IItemPropertyDescriptor {
        private String label;
        private String description;
        private Object itemPropertySource;

        public GroupPropertyDescriptor(String label, String description, IItemPropertySource itemPropertySource) {
            this.label = label;
            this.description = description;
            this.itemPropertySource = itemPropertySource;
        }

        public void setPropertyValue(Object object, Object value) {
        }

        public void resetPropertyValue(Object object) {
        }

        public boolean isSortChoices(Object object) {
            return false;
        }

        public boolean isPropertySet(Object object) {
            return false;
        }

        public boolean isMultiLine(Object object) {
            return false;
        }

        public boolean isMany(Object object) {
            return false;
        }

        public boolean isCompatibleWith(Object object, Object anotherObject, IItemPropertyDescriptor anotherPropertyDescriptor) {
            return false;
        }

        public Object getPropertyValue(Object object) {
            return this.itemPropertySource;
        }

        public IItemLabelProvider getLabelProvider(Object object) {
            return new IItemLabelProvider(){

                public String getText(Object object) {
                    return "";
                }

                public Object getImage(Object object) {
                    return ItemPropertyDescriptor.NO_VALUE_IMAGE;
                }
            };
        }

        public String getId(Object object) {
            return this.label;
        }

        public Object getHelpContextIds(Object object) {
            return null;
        }

        public String[] getFilterFlags(Object object) {
            return null;
        }

        public Object getFeature(Object object) {
            return this.label;
        }

        public String getDisplayName(Object object) {
            return this.label;
        }

        public String getDescription(Object object) {
            return this.description;
        }

        public Collection<?> getChoiceOfValues(Object object) {
            return null;
        }

        public String getCategory(Object object) {
            return null;
        }

        public boolean canSetProperty(Object object) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ReferencesPropertyDescriptor
    extends ItemPropertyDescriptor {
        public ReferencesPropertyDescriptor() {
            super((AdapterFactory)EAnnotationItemProvider.this.getRootAdapterFactory(), EAnnotationItemProvider.this.getResourceLocator(), EAnnotationItemProvider.this.getString("_UI_EAnnotation_references_feature"), EAnnotationItemProvider.this.getString("_UI_EAnnotation_references_description"), (EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES, true, false, true, null, null, null);
        }

        public Collection<?> getChoiceOfValues(Object object) {
            Collection result = super.getChoiceOfValues(object);
            BasicEAnnotationValidator.Assistant assistant = EAnnotationItemProvider.this.getAssistant();
            if (assistant != null) {
                result = assistant.getValidReferences((EAnnotation)object, result);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SourcePropertyDescriptor
    extends ItemPropertyDescriptor {
        public SourcePropertyDescriptor() {
            super((AdapterFactory)EAnnotationItemProvider.this.getRootAdapterFactory(), EAnnotationItemProvider.this.getResourceLocator(), EAnnotationItemProvider.this.getString("_UI_EAnnotation_source_feature"), EAnnotationItemProvider.this.getString("_UI_EAnnotation_source_description"), (EStructuralFeature)EcorePackage.Literals.EANNOTATION__SOURCE, true, false, true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null);
        }

        protected Object createPropertyValueWrapper(Object object, Object propertyValue) {
            List propertyClasses;
            EAnnotation eAnnotation;
            BasicEAnnotationValidator.Assistant assistant = EAnnotationItemProvider.this.getAssistant();
            if (assistant != null && assistant.isValidLocation(eAnnotation = (EAnnotation)object) && !(propertyClasses = assistant.getPropertyClasses(eAnnotation.getEModelElement())).isEmpty()) {
                EAnnotationItemProviderAdapterFactory.Group group = new EAnnotationItemProviderAdapterFactory.Group(propertyValue);
                HashMap<String, EAnnotationItemProviderAdapterFactory.Group> categories = new HashMap<String, EAnnotationItemProviderAdapterFactory.Group>();
                EAnnotationItemProviderAdapterFactory eAnnotationItemProviderAdapterFactory = EAnnotationItemProvider.this.getEAnnotationItemProviderAdapterFactory();
                boolean showInstances = eAnnotationItemProviderAdapterFactory.isShowInstances(eAnnotation);
                boolean onlyMisc = true;
                for (EClass propertyClass : propertyClasses) {
                    EObject instance = assistant.createInstance(propertyClass, eAnnotation);
                    EAnnotationItemProviderAdapterFactory.Group targetGroup = group;
                    if (showInstances) {
                        EAnnotationItemProviderAdapterFactory.Group classGroup = new EAnnotationItemProviderAdapterFactory.Group(instance);
                        String groupName = eAnnotationItemProviderAdapterFactory.getGroupName(instance);
                        GroupPropertyDescriptor groupPropertyDescriptor = new GroupPropertyDescriptor(groupName, groupName, classGroup);
                        group.add(groupPropertyDescriptor);
                        targetGroup = classGroup;
                        categories.clear();
                        onlyMisc = true;
                    }
                    List<IItemPropertyDescriptor> propertyDescriptors = eAnnotationItemProviderAdapterFactory.getPropertyDescriptors(instance, eAnnotation, eAnnotationItemProviderAdapterFactory.getResourceLocator());
                    for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                        EAnnotationItemProviderAdapterFactory.Group categoryGroup;
                        String category = null;
                        if (propertyDescriptor instanceof EAnnotationItemProviderAdapterFactory.DecategorizingItemPropertyDescritorDecorator) {
                            category = ((EAnnotationItemProviderAdapterFactory.DecategorizingItemPropertyDescritorDecorator)propertyDescriptor).getCategory();
                        }
                        if ((categoryGroup = (EAnnotationItemProviderAdapterFactory.Group)categories.get(category)) == null) {
                            categoryGroup = new EAnnotationItemProviderAdapterFactory.Group(category);
                            categories.put(category, categoryGroup);
                            if (category == null) {
                                category = EcoreEditPlugin.INSTANCE.getString("_UI_Misc_property_category");
                            } else {
                                onlyMisc = false;
                            }
                            targetGroup.add(new GroupPropertyDescriptor(category, category, categoryGroup));
                        }
                        categoryGroup.add(propertyDescriptor);
                    }
                    if (!showInstances || !onlyMisc) continue;
                    List<IItemPropertyDescriptor> groupPropertyDescriptors = targetGroup.getPropertyDescriptors();
                    groupPropertyDescriptors.clear();
                    if (categories.isEmpty()) continue;
                    groupPropertyDescriptors.addAll(((EAnnotationItemProviderAdapterFactory.Group)categories.values().iterator().next()).getPropertyDescriptors());
                }
                if (!showInstances && onlyMisc) {
                    List<IItemPropertyDescriptor> groupPropertyDescriptors = group.getPropertyDescriptors();
                    groupPropertyDescriptors.clear();
                    if (!categories.isEmpty()) {
                        groupPropertyDescriptors.addAll(((EAnnotationItemProviderAdapterFactory.Group)categories.values().iterator().next()).getPropertyDescriptors());
                    }
                }
                return group;
            }
            return super.createPropertyValueWrapper(object, propertyValue);
        }

        public void setPropertyValue(Object object, Object value) {
            EAnnotation eAnnotation = (EAnnotation)object;
            String source = eAnnotation.getSource();
            String strippedValue = EAnnotationItemProvider.this.stripToNull((String)value);
            if (strippedValue == null ? source != null : !strippedValue.equals(source)) {
                super.setPropertyValue(object, (Object)strippedValue);
            }
        }

        public Collection<?> getChoiceOfValues(Object object) {
            EObject eContainer;
            EObject eObject;
            EAnnotation eAnnotation = (EAnnotation)object;
            UniqueEList result = new UniqueEList();
            TreeIterator i = EcoreUtil.getRootContainer((EObject)eAnnotation).eAllContents();
            while (i.hasNext()) {
                EAnnotation otherEAnnotation;
                String otherSource;
                eObject = (EObject)i.next();
                if (!(eObject instanceof EAnnotation) || (otherSource = (otherEAnnotation = (EAnnotation)eObject).getSource()) == null || !EcoreValidator.INSTANCE.validateEAnnotation_WellFormedSourceURI(otherEAnnotation, null, null)) continue;
                result.add(otherSource);
            }
            eObject = eContainer = eAnnotation.eContainer();
            while (eObject != null) {
                if (eObject instanceof EPackage) {
                    EPackage ePackage = (EPackage)eObject;
                    if (eContainer instanceof EDataType) {
                        for (String conversionDelegate : EcoreUtil.getConversionDelegates((EPackage)ePackage)) {
                            result.add(conversionDelegate);
                        }
                    } else if (eContainer instanceof EOperation) {
                        for (String invocationDelegate : EcoreUtil.getInvocationDelegates((EPackage)ePackage)) {
                            result.add(invocationDelegate);
                        }
                    } else if (eContainer instanceof EStructuralFeature) {
                        for (String settingDelegate : EcoreUtil.getSettingDelegates((EPackage)ePackage)) {
                            result.add(settingDelegate);
                        }
                    }
                }
                eObject = eObject.eContainer();
            }
            String[] stringArray = EAnnotationValidator.Registry.INSTANCE.keySet().toArray(new String[0]);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object annotationSource = stringArray[n2];
                EAnnotationValidator eAnnotationValidator = EAnnotationValidator.Registry.INSTANCE.getEAnnotationValidator((String)annotationSource);
                if (eAnnotationValidator.isValidLocation(eAnnotation)) {
                    result.add(annotationSource);
                } else {
                    result.remove(annotationSource);
                }
                ++n2;
            }
            String source = eAnnotation.getSource();
            if (source != null) {
                result.add(source);
            }
            return result;
        }

        public boolean isChoiceArbitrary(Object object) {
            return true;
        }

        public IItemPropertyDescriptor.ValueHandler getValueHandler(Object object) {
            return new ItemPropertyDescriptor.DataTypeValueHandler((EDataType)this.feature.getEType()){

                protected Diagnostic validate(EDataType eDataType, Object instance) {
                    EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource((String)instance);
                    BasicDiagnostic diagnostic = new BasicDiagnostic();
                    EcoreValidator.INSTANCE.validateEAnnotation_WellFormedSourceURI(eAnnotation, (DiagnosticChain)diagnostic, null);
                    return diagnostic;
                }
            };
        }
    }
}

