/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.ValidationMessage;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecoretools.ale.core.validation.BaseValidator;
import org.eclipse.emf.ecoretools.ale.core.validation.IValidator;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureInsert;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureRemove;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.While;

public class NameValidator
implements IValidator {
    public static final String NAME_ALREADY_USED = "The name %s is already used";
    public static final String SELF_RESERVED = "'self' is a reserved name";
    public static final String RESULT_RESERVED = "'result' is a reserved name";
    public static final String OP_ALREADY_DECLARED = "The operation %s is already declared";
    public static final String OP_MUST_OVERRIDE = "The operation %s must override";
    public static final String FEATURE_UNDEFINED = "The feature %s is not defined";
    public static final String VARIABLE_UNDEFINED = "The variable %s is not defined";
    public static final String PARAM_ASSIGN = "%s is a parameter and can't be assigned";
    public static final String SELF_ASSIGN = "'self' can't be assigned";
    public static final String OVERRIDE_UNDEFINED = "Can't find matching EOperation in %s";
    BaseValidator base;

    @Override
    public void setBase(BaseValidator base) {
        this.base = base;
    }

    @Override
    public List<IValidationMessage> validateModelBehavior(List<ModelUnit> units) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        ArrayList declarations = new ArrayList();
        units.stream().forEach(unit -> {
            if (declarations.contains(unit.getName())) {
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(NAME_ALREADY_USED, unit.getName()), 0, 0));
            } else {
                declarations.add(unit.getName());
            }
        });
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateModelUnit(ModelUnit unit) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        ArrayList declarations = new ArrayList();
        unit.getClassDefinitions().stream().forEach(cls -> {
            if (declarations.contains(cls.getName())) {
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(NAME_ALREADY_USED, cls.getName()), this.base.getStartOffset(cls), this.base.getEndOffset(cls)));
            } else {
                declarations.add(cls.getName());
            }
        });
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateExtendedClass(ExtendedClass xtdClass) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        msgs.addAll(this.validateBehavioredClass(xtdClass));
        List declarations = xtdClass.getBaseClass().getEAllStructuralFeatures().stream().map(s -> s.getName()).collect(Collectors.toList());
        xtdClass.getAttributes().stream().forEach(att -> {
            String name = att.getFeatureRef().getName();
            if (declarations.contains(name)) {
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(NAME_ALREADY_USED, name), this.base.getStartOffset(att), this.base.getEndOffset(att)));
            }
        });
        EList allEOperations = xtdClass.getBaseClass().getEAllOperations();
        for (Method mtd : xtdClass.getMethods()) {
            EOperation opRef = mtd.getOperationRef();
            if (opRef == null || opRef.getEContainingClass() == xtdClass.getBaseClass() || !allEOperations.stream().anyMatch(op -> this.isMatching(opRef, (EOperation)op))) continue;
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(OP_MUST_OVERRIDE, this.getSignature(mtd)), this.base.getStartOffset(mtd), this.base.getEndOffset(mtd)));
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateRuntimeClass(RuntimeClass classDef) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        msgs.addAll(this.validateBehavioredClass(classDef));
        return msgs;
    }

    private List<IValidationMessage> validateBehavioredClass(BehavioredClass clazz) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        ArrayList declarations = new ArrayList();
        clazz.getAttributes().stream().forEach(att -> {
            String name = att.getFeatureRef().getName();
            if (declarations.contains(name)) {
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(NAME_ALREADY_USED, name), this.base.getStartOffset(att), this.base.getEndOffset(att)));
            } else if (name.equals("self")) {
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(SELF_RESERVED, name), this.base.getStartOffset(att), this.base.getEndOffset(att)));
            } else if (name.equals("result")) {
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(RESULT_RESERVED, name), this.base.getStartOffset(att), this.base.getEndOffset(att)));
            } else {
                declarations.add(name);
            }
        });
        ArrayList<Method> previousOp = new ArrayList<Method>();
        for (Method mtd : clazz.getMethods()) {
            boolean isConflict = previousOp.stream().anyMatch(prevOp -> this.isMatching(mtd, (Method)prevOp));
            if (isConflict) {
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(OP_ALREADY_DECLARED, this.getSignature(mtd)), this.base.getStartOffset(mtd), this.base.getEndOffset(mtd)));
            }
            previousOp.add(mtd);
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateMethod(Method mtd) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        ArrayList<String> declarations = new ArrayList<String>();
        if (mtd.getOperationRef() != null) {
            for (EParameter param : mtd.getOperationRef().getEParameters()) {
                String name = param.getName();
                if (declarations.contains(name)) {
                    msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(NAME_ALREADY_USED, param.getName()), this.base.getStartOffset(mtd), this.base.getEndOffset(mtd)));
                    continue;
                }
                if (param.getName().equals("result")) {
                    msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(RESULT_RESERVED, param.getName()), this.base.getStartOffset(mtd), this.base.getEndOffset(mtd)));
                    continue;
                }
                if (param.getName().equals("self")) {
                    msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(SELF_RESERVED, param.getName()), this.base.getStartOffset(mtd), this.base.getEndOffset(mtd)));
                    continue;
                }
                declarations.add(name);
            }
        } else {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(OVERRIDE_UNDEFINED, ((BehavioredClass)mtd.eContainer()).getName()), this.base.getStartOffset(mtd), this.base.getEndOffset(mtd)));
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateFeatureAssignment(FeatureAssignment featAssign) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        boolean isExistingFeature = false;
        Set<IType> targetTypes = this.base.getPossibleTypes(featAssign.getTarget());
        for (IType type : targetTypes) {
            if (!(type.getType() instanceof EClass)) continue;
            EClass realType = (EClass)type.getType();
            EStructuralFeature feature = realType.getEStructuralFeature(featAssign.getTargetFeature());
            if (feature != null) {
                isExistingFeature = true;
                continue;
            }
            List<ExtendedClass> extensions = this.base.findExtensions(realType);
            Optional<Attribute> foundDynamicAttribute = extensions.stream().flatMap(xtdCls -> xtdCls.getAttributes().stream()).filter(field -> field.getFeatureRef().getName().equals(featAssign.getTargetFeature())).findFirst();
            if (!foundDynamicAttribute.isPresent()) continue;
            isExistingFeature = true;
        }
        if (!isExistingFeature) {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(FEATURE_UNDEFINED, featAssign.getTargetFeature()), this.base.getStartOffset(featAssign), this.base.getEndOffset(featAssign)));
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateFeatureInsert(FeatureInsert featInsert) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        boolean isExistingFeature = false;
        Set<IType> targetTypes = this.base.getPossibleTypes(featInsert.getTarget());
        for (IType type : targetTypes) {
            if (!(type.getType() instanceof EClass)) continue;
            EClass realType = (EClass)type.getType();
            EStructuralFeature feature = realType.getEStructuralFeature(featInsert.getTargetFeature());
            if (feature != null) {
                isExistingFeature = true;
                continue;
            }
            List<ExtendedClass> extensions = this.base.findExtensions(realType);
            Optional<Attribute> foundDynamicAttribute = extensions.stream().flatMap(xtdCls -> xtdCls.getAttributes().stream()).filter(field -> field.getFeatureRef().getName().equals(featInsert.getTargetFeature())).findFirst();
            if (!foundDynamicAttribute.isPresent()) continue;
            isExistingFeature = true;
        }
        if (!isExistingFeature) {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(FEATURE_UNDEFINED, featInsert.getTargetFeature()), this.base.getStartOffset(featInsert), this.base.getEndOffset(featInsert)));
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateFeatureRemove(FeatureRemove featRemove) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        boolean isExistingFeature = false;
        Set<IType> targetTypes = this.base.getPossibleTypes(featRemove.getTarget());
        for (IType type : targetTypes) {
            if (!(type.getType() instanceof EClass)) continue;
            EClass realType = (EClass)type.getType();
            EStructuralFeature feature = realType.getEStructuralFeature(featRemove.getTargetFeature());
            if (feature != null) {
                isExistingFeature = true;
                continue;
            }
            List<ExtendedClass> extensions = this.base.findExtensions(realType);
            Optional<Attribute> foundDynamicAttribute = extensions.stream().flatMap(xtdCls -> xtdCls.getAttributes().stream()).filter(field -> field.getFeatureRef().getName().equals(featRemove.getTargetFeature())).findFirst();
            if (!foundDynamicAttribute.isPresent()) continue;
            isExistingFeature = true;
        }
        if (!isExistingFeature) {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(FEATURE_UNDEFINED, featRemove.getTargetFeature()), this.base.getStartOffset(featRemove), this.base.getEndOffset(featRemove)));
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateVariableAssignment(VariableAssignment varAssign) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        Set<IType> declaringTypes = this.base.getCurrentScope().get(varAssign.getName());
        if (declaringTypes == null && !varAssign.getName().equals("result")) {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(VARIABLE_UNDEFINED, varAssign.getName()), this.base.getStartOffset(varAssign), this.base.getEndOffset(varAssign)));
        } else if (varAssign.getName().equals("self")) {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(SELF_ASSIGN, varAssign.getName()), this.base.getStartOffset(varAssign), this.base.getEndOffset(varAssign)));
        } else {
            EList params;
            Optional<EParameter> matchingParam;
            Method op = this.base.getContainingOperation(varAssign);
            if (op.getOperationRef() != null && (matchingParam = (params = op.getOperationRef().getEParameters()).stream().filter(param -> param.getName().equals(varAssign.getName())).findFirst()).isPresent()) {
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(PARAM_ASSIGN, varAssign.getName()), this.base.getStartOffset(varAssign), this.base.getEndOffset(varAssign)));
            }
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateVariableDeclaration(VariableDeclaration varDecl) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        if (varDecl.getName().equals("result")) {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(RESULT_RESERVED, varDecl.getName()), this.base.getStartOffset(varDecl), this.base.getEndOffset(varDecl)));
        } else if (varDecl.getName().equals("self")) {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(SELF_RESERVED, varDecl.getName()), this.base.getStartOffset(varDecl), this.base.getEndOffset(varDecl)));
        } else {
            Set<IType> declaringTypes = this.base.getCurrentScope().get(varDecl.getName());
            if (declaringTypes != null) {
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(NAME_ALREADY_USED, varDecl.getName()), this.base.getStartOffset(varDecl), this.base.getEndOffset(varDecl)));
            }
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateForEach(ForEach loop) {
        ArrayList<IValidationMessage> msgs = new ArrayList<IValidationMessage>();
        if (loop.getVariable().equals("result")) {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(RESULT_RESERVED, loop.getVariable()), this.base.getStartOffset(loop), this.base.getEndOffset(loop)));
        } else if (loop.getVariable().equals("self")) {
            msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(SELF_RESERVED, loop.getVariable()), this.base.getStartOffset(loop), this.base.getEndOffset(loop)));
        } else {
            Set<IType> declaringTypes = this.base.getCurrentScope().get(loop.getVariable());
            if (declaringTypes != null) {
                msgs.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.ERROR, String.format(NAME_ALREADY_USED, loop.getVariable()), this.base.getStartOffset(loop), this.base.getEndOffset(loop)));
            }
        }
        return msgs;
    }

    @Override
    public List<IValidationMessage> validateIf(If ifStmt) {
        return new ArrayList<IValidationMessage>();
    }

    @Override
    public List<IValidationMessage> validateWhile(While loop) {
        return new ArrayList<IValidationMessage>();
    }

    private String getSignature(Method op) {
        EOperation eOp = op.getOperationRef();
        if (eOp != null) {
            String paramsToString = eOp.getEParameters().stream().map(param -> param.getEType().getName()).collect(Collectors.joining(",", "(", ")"));
            return String.valueOf(eOp.getName()) + paramsToString;
        }
        return "undefined";
    }

    private boolean isMatching(Method op1, Method op2) {
        EOperation eOp1 = op1.getOperationRef();
        EOperation eOp2 = op2.getOperationRef();
        return this.isMatching(eOp1, eOp2);
    }

    private boolean isMatching(EOperation eOp1, EOperation eOp2) {
        boolean isMatchingArgsSize;
        if (eOp1 == null || eOp2 == null) {
            return false;
        }
        boolean isMatchingName = eOp1.getName().equals(eOp2.getName());
        boolean bl = isMatchingArgsSize = eOp1.getEParameters().size() == eOp2.getEParameters().size();
        if (!isMatchingName || !isMatchingArgsSize) {
            return false;
        }
        boolean areParamTypeMatching = true;
        int i = 0;
        while (i < eOp1.getEParameters().size()) {
            EParameter param1 = (EParameter)eOp1.getEParameters().get(i);
            EParameter param2 = (EParameter)eOp2.getEParameters().get(i);
            areParamTypeMatching = areParamTypeMatching && param1.getEType().equals(param2.getEType());
            ++i;
        }
        return isMatchingName && isMatchingArgsSize && areParamTypeMatching;
    }
}

