/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ui.contentassist;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IProposalFilter;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.BasicFilter;
import org.eclipse.acceleo.query.runtime.impl.QueryCompletionEngine;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecoretools.ale.ALEInterpreter;
import org.eclipse.emf.ecoretools.ale.core.parser.DslBuilder;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.core.validation.ALEValidator;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ui.contentassist.AbstractAleProposalProvider;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.BidiIterable;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalPriorities;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class AleProposalProvider
extends AbstractAleProposalProvider {
    @Override
    public void completeExpression_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String candidate = this.getOffsetPrefix(context);
        this.addProposals(candidate, model, context, acceptor);
    }

    @Override
    public void completeExpression_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String candidate = this.getOffsetPrefix(context);
        this.addProposals(candidate, model, context, acceptor);
    }

    @Override
    public void complete_expression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String candidate = this.getOffsetPrefix(context);
        this.addProposals(candidate, model, context, acceptor);
    }

    private void addProposals(String expression, EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Set _entrySet;
        boolean _isEmpty_1;
        boolean _isEmpty = expression.isEmpty();
        if (_isEmpty) {
            return;
        }
        Resource _eResource = model.eResource();
        IFile aleFile = WorkspaceSynchronizer.getFile((Resource)_eResource);
        IPath _fullPath = aleFile.getFullPath();
        IPath _removeFileExtension = _fullPath.removeFileExtension();
        IPath dslPath = _removeFileExtension.addFileExtension("ecore");
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource.Factory.Registry _resourceFactoryRegistry = rs.getResourceFactoryRegistry();
        Map _extensionToFactoryMap = _resourceFactoryRegistry.getExtensionToFactoryMap();
        XMIResourceFactoryImpl _xMIResourceFactoryImpl = new XMIResourceFactoryImpl();
        _extensionToFactoryMap.put("*", _xMIResourceFactoryImpl);
        String _string = dslPath.toString();
        List ecorePkgs = DslBuilder.load((String)_string, (ResourceSet)rs);
        IXtextDocument _document = context.getDocument();
        String _get = _document.get();
        byte[] _bytes = _get.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream stream = new ByteArrayInputStream(_bytes);
        ALEInterpreter interpreter = new ALEInterpreter();
        IQueryEnvironment _queryEnvironment = interpreter.getQueryEnvironment();
        DslBuilder _dslBuilder = new DslBuilder(_queryEnvironment);
        List<InputStream> _asList = Arrays.asList(stream);
        List parsedSemantics = _dslBuilder.parse(ecorePkgs, _asList);
        Functions.Function1 _function = it -> (ModelUnit)it.getRoot();
        List _map = ListExtensions.map((List)parsedSemantics, (Functions.Function1)_function);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
        Functions.Function1 _function_1 = it -> it.getServices();
        Iterable _map_1 = IterableExtensions.map((Iterable)_filterNull, (Functions.Function1)_function_1);
        Iterable _flatten = Iterables.concat((Iterable)_map_1);
        List services = IterableExtensions.toList((Iterable)_flatten);
        interpreter.registerServices(services);
        Map variableTypes = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        int _offset = context.getOffset();
        int _minus = _offset - 1;
        Expression contextExp = this.getExpression(parsedSemantics, _minus);
        IQueryEnvironment _queryEnvironment_1 = interpreter.getQueryEnvironment();
        ALEValidator validator = new ALEValidator(_queryEnvironment_1);
        if (contextExp != null) {
            Map _validationContext = validator.getValidationContext(contextExp, parsedSemantics);
            variableTypes = _validationContext;
        }
        if (_isEmpty_1 = (_entrySet = variableTypes.entrySet()).isEmpty()) {
            int _offset_1 = context.getOffset();
            Block block = this.getBlock(parsedSemantics, _offset_1);
            Map _validationContext_1 = validator.getValidationContext(block, parsedSemantics);
            variableTypes = _validationContext_1;
        }
        IQueryEnvironment _queryEnvironment_2 = interpreter.getQueryEnvironment();
        QueryCompletionEngine engine = new QueryCompletionEngine((IReadOnlyQueryEnvironment)_queryEnvironment_2);
        int _length = expression.length();
        ICompletionResult completionResult = engine.getCompletion(expression, _length, variableTypes);
        BasicFilter _basicFilter = new BasicFilter(completionResult);
        List proposals = completionResult.getProposals((IProposalFilter)_basicFilter);
        Consumer<ICompletionProposal> _function_2 = proposal -> {
            String _proposal = proposal.getProposal();
            StyledString styledText = new StyledString(_proposal);
            String _proposal_1 = proposal.getProposal();
            int _length_1 = _proposal_1.length();
            styledText.setStyle(0, _length_1, StyledString.QUALIFIER_STYLER);
            String _proposal_2 = proposal.getProposal();
            IContentProposalPriorities _priorityHelper = this.getPriorityHelper();
            int _defaultPriority = _priorityHelper.getDefaultPriority();
            int _plus = _defaultPriority + 1;
            ConfigurableCompletionProposal _doCreateProposal = this.doCreateProposal(_proposal_2, styledText, null, _plus, context);
            acceptor.accept((org.eclipse.jface.text.contentassist.ICompletionProposal)_doCreateProposal);
        };
        proposals.forEach(_function_2);
    }

    private org.eclipse.emf.ecoretools.ale.Expression rootExpression(EObject element) {
        org.eclipse.emf.ecoretools.ale.Expression res = null;
        EObject current = element;
        while (current != null) {
            EObject _eContainer;
            if (current instanceof org.eclipse.emf.ecoretools.ale.Expression) {
                res = (org.eclipse.emf.ecoretools.ale.Expression)current;
            }
            current = _eContainer = current.eContainer();
        }
        return res;
    }

    private Expression getExpression(List<ParseResult<ModelUnit>> parsedSemantics, int offset) {
        Functions.Function1 _function;
        ParseResult unit;
        Map _startPositions;
        Set _keySet;
        Iterable allExps;
        Expression candidate;
        boolean _not;
        Expression res = null;
        boolean _isEmpty = parsedSemantics.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not && (candidate = (Expression)IterableExtensions.findFirst((Iterable)(allExps = Iterables.filter(_keySet = (_startPositions = (unit = (ParseResult)IterableExtensions.head(parsedSemantics)).getStartPositions()).keySet(), Expression.class)), (Functions.Function1)(_function = exp -> (Integer)unit.getStartPositions().get(exp) <= offset && (Integer)unit.getEndPositions().get(exp) >= offset))) != null) {
            res = candidate;
            Map _startPositions_1 = unit.getStartPositions();
            Integer _get = (Integer)_startPositions_1.get(candidate);
            _get.intValue();
            Map _endPositions = unit.getEndPositions();
            Integer _get_1 = (Integer)_endPositions.get(candidate);
            _get_1.intValue();
            while (res.eContainer() instanceof Expression) {
                EObject _eContainer = res.eContainer();
                res = (Expression)_eContainer;
            }
        }
        return res;
    }

    private Block getBlock(List<ParseResult<ModelUnit>> parsedSemantics, int offset) {
        Functions.Function1 _function;
        ParseResult unit;
        Map _startPositions;
        Set _keySet;
        Iterable allExps;
        Block candidate;
        boolean _not;
        Block res = null;
        int start = 0;
        int end = 0;
        boolean _isEmpty = parsedSemantics.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not && (candidate = (Block)IterableExtensions.findFirst((Iterable)(allExps = Iterables.filter(_keySet = (_startPositions = (unit = (ParseResult)IterableExtensions.head(parsedSemantics)).getStartPositions()).keySet(), Block.class)), (Functions.Function1)(_function = block -> (Integer)unit.getStartPositions().get(block) <= offset && (Integer)unit.getEndPositions().get(block) >= offset))) != null) {
            res = candidate;
            Map _startPositions_1 = unit.getStartPositions();
            Integer _get = (Integer)_startPositions_1.get(candidate);
            start = _get;
            Map _endPositions = unit.getEndPositions();
            Integer _get_1 = (Integer)_endPositions.get(candidate);
            end = _get_1;
            Iterable _drop = IterableExtensions.drop((Iterable)allExps, (int)1);
            for (Block block2 : _drop) {
                boolean _lessEqualsThan;
                Map _startPositions_2 = unit.getStartPositions();
                Integer _get_2 = (Integer)_startPositions_2.get(block2);
                boolean bl2 = _lessEqualsThan = start <= _get_2;
                if (_lessEqualsThan) {
                    Map _endPositions_1 = unit.getEndPositions();
                    Integer _get_3 = (Integer)_endPositions_1.get(block2);
                    boolean _lessEqualsThan_1 = _get_3 <= end;
                }
                Map _startPositions_3 = unit.getStartPositions();
                Integer _get_4 = (Integer)_startPositions_3.get(block2);
                start = _get_4;
                Map _endPositions_2 = unit.getEndPositions();
                Integer _get_5 = (Integer)_endPositions_2.get(block2);
                end = _get_5;
            }
        }
        return res;
    }

    private CompositeNode getBlockNode(INode node) {
        ICompositeNode _rootNode = node.getRootNode();
        NodeModelUtils.compactDump((INode)_rootNode, (boolean)true);
        INode current = node;
        while (!Objects.equal((Object)current, null)) {
            EObject _semanticElement;
            if (current instanceof CompositeNodeWithSemanticElement && (_semanticElement = ((CompositeNodeWithSemanticElement)current).getSemanticElement()) instanceof org.eclipse.emf.ecoretools.ale.Block) {
                return (CompositeNode)current;
            }
            ICompositeNode _parent = current.getParent();
            current = _parent;
        }
        return null;
    }

    private AbstractNode findStatementNode(INode node, int offset) {
        boolean _notEquals;
        CompositeNode block = this.getBlockNode(node);
        boolean bl = _notEquals = !Objects.equal((Object)block, null);
        if (_notEquals) {
            BidiIterable _basicGetChildren = block.basicGetChildren();
            Functions.Function1 _function = child -> {
                ITextRegion _textRegion = child.getTextRegion();
                return _textRegion.contains(offset);
            };
            AbstractNode candidate = (AbstractNode)IterableExtensions.findFirst((Iterable)_basicGetChildren, (Functions.Function1)_function);
            return candidate;
        }
        return null;
    }

    private int findStart(String text, int offset) {
        int openIndex;
        int i = offset;
        while (i > 0) {
            String frame = text.substring(i - 1, i + 1);
            if (Objects.equal((Object)frame, (Object)":=") || Objects.equal((Object)frame, (Object)"+=") || Objects.equal((Object)frame, (Object)"-=") || Objects.equal((Object)frame, (Object)"in")) {
                if (i == offset) {
                    return offset;
                }
                return i + 1;
            }
            --i;
        }
        int whileIndex = text.indexOf("while");
        if (whileIndex != -1 && (openIndex = text.indexOf("(", whileIndex)) != -1) {
            return openIndex;
        }
        int ifIndex = text.indexOf("if");
        if (ifIndex != -1) {
            int openIndex_1 = text.indexOf("(", ifIndex);
            int thenIndex = text.indexOf("then", ifIndex);
            if (openIndex_1 != -1 && (thenIndex == -1 || openIndex_1 < thenIndex)) {
                return openIndex_1;
            }
        }
        return 0;
    }

    private String getOffsetPrefix(ContentAssistContext context) {
        try {
            INode _currentNode = context.getCurrentNode();
            int _offset = context.getOffset();
            int _minus = _offset - 1;
            AbstractNode stmtNode = this.findStatementNode(_currentNode, _minus);
            if (stmtNode != null) {
                IXtextDocument _document = context.getDocument();
                int _offset_1 = stmtNode.getOffset();
                int _length = stmtNode.getLength();
                String stmtText = _document.get(_offset_1, _length);
                int _offset_2 = context.getOffset();
                int _minus_1 = _offset_2 - 1;
                int _offset_3 = stmtNode.getOffset();
                int _minus_2 = _minus_1 - _offset_3;
                int startIndex = this.findStart(stmtText, _minus_2);
                int _offset_4 = stmtNode.getOffset();
                int startOffset = _offset_4 + startIndex;
                IXtextDocument _document_1 = context.getDocument();
                int _offset_5 = context.getOffset();
                int _minus_3 = _offset_5 - startOffset;
                return _document_1.get(startOffset, _minus_3);
            }
            return "";
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

