/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.discovery.repository;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.internal.p2.ui.discovery.repository.RepositorySource;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class RepositoryDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final String IU_PROPERTY_CATEGORY = "org.eclipse.equinox.p2.type.category";
    private static final String PLUGIN_ID = "org.eclipse.equinox.p2.discovery.repository";
    private final List<URI> locations = new ArrayList<URI>();
    private final Map<IMetadataRepository, RepositorySource> sourceByRepository = new HashMap<IMetadataRepository, RepositorySource>();
    private final Map<String, CatalogCategory> categoryById = new HashMap<String, CatalogCategory>();
    private final Map<String, CatalogItem> catalogItemById = new HashMap<String, CatalogItem>();

    public void addLocation(URI location) {
        this.locations.add(location);
    }

    public void removeLocation(URI location) {
        this.locations.remove(location);
    }

    public void performDiscovery(IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
        monitor.setWorkRemaining(100);
        try {
            List<IMetadataRepository> repositories = this.addRepositories(monitor.newChild(50));
            this.queryInstallableUnits(monitor.newChild(50), repositories);
            this.connectCategories();
        }
        catch (ProvisionException e) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, "Failed to process repository contents", (Throwable)e));
        }
    }

    private void connectCategories() {
        for (CatalogCategory category : this.categories) {
            if (!(category.getData() instanceof IInstallableUnit)) continue;
            IInstallableUnit categoryIU = (IInstallableUnit)category.getData();
            Collection required = categoryIU.getRequirements();
            for (IRequirement requirement : required) {
                IRequiredCapability capability;
                CatalogItem item;
                if (!(requirement instanceof IRequiredCapability) || (item = this.catalogItemById.get((capability = (IRequiredCapability)requirement).getName())) == null) continue;
                item.setCategoryId(category.getId());
            }
        }
    }

    private List<IMetadataRepository> addRepositories(SubMonitor monitor) throws ProvisionException {
        ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
        monitor.setWorkRemaining(this.locations.size());
        RepositoryTracker repositoryTracker = ProvisioningUI.getDefaultUI().getRepositoryTracker();
        for (URI location : this.locations) {
            repositoryTracker.addRepository(location, null, session);
            monitor.worked(1);
        }
        ArrayList<IMetadataRepository> repositories = new ArrayList<IMetadataRepository>();
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)session.getProvisioningAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        for (URI uri : this.locations) {
            IMetadataRepository repository = manager.loadRepository(uri, (IProgressMonitor)monitor.newChild(1));
            repositories.add(repository);
        }
        return repositories;
    }

    private void checkCancelled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void queryInstallableUnits(SubMonitor monitor, List<IMetadataRepository> repositories) {
        monitor.setWorkRemaining(repositories.size());
        for (IMetadataRepository repository : repositories) {
            this.checkCancelled((IProgressMonitor)monitor);
            IQuery query = QueryUtil.createMatchQuery((String)"id ~= /*.feature.group/ ? providedCapabilities.exists(p | p.namespace == 'org.eclipse.equinox.p2.iu' && p.name ~= /*.feature.group/) : properties['org.eclipse.equinox.p2.type.category'] == true", (Object[])new Object[0]);
            IQueryResult result = repository.query(query, (IProgressMonitor)monitor.newChild(1));
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                this.process(repository, (IInstallableUnit)iter.next());
            }
        }
    }

    protected void process(IMetadataRepository repository, IInstallableUnit candidate) {
        if (this.isCategory(candidate).booleanValue()) {
            this.processCategory(repository, candidate);
        } else {
            this.processCatalogItem(repository, candidate);
        }
    }

    private CatalogItem processCatalogItem(IMetadataRepository repository, IInstallableUnit candidate) {
        CatalogItem item = this.catalogItemById.get(candidate.getId());
        if (item != null) {
            return item;
        }
        item = new CatalogItem();
        item.setId(candidate.getId());
        item.setDescription(this.getProperty(candidate, "org.eclipse.equinox.p2.description"));
        item.setName(this.getProperty(candidate, "org.eclipse.equinox.p2.name"));
        item.setProvider(this.getProperty(candidate, "org.eclipse.equinox.p2.provider"));
        item.setSource(this.getSource(repository));
        item.setData((Object)candidate);
        item.setSiteUrl(repository.getLocation().toString());
        item.getInstallableUnits().add(item.getId());
        this.catalogItemById.put(item.getId(), item);
        this.items.add(item);
        return item;
    }

    public String getProperty(IInstallableUnit candidate, String key) {
        String value = TranslationSupport.getInstance().getIUProperty(candidate, key);
        return value != null ? value : "";
    }

    private AbstractCatalogSource getSource(IMetadataRepository repository) {
        RepositorySource source = this.sourceByRepository.get(repository);
        if (source == null) {
            source = new RepositorySource(repository);
            this.sourceByRepository.put(repository, source);
        }
        return source;
    }

    private CatalogCategory processCategory(IMetadataRepository repository, IInstallableUnit candidate) {
        CatalogCategory category = this.categoryById.get(candidate.getId());
        if (category != null) {
            return category;
        }
        category = new CatalogCategory();
        category.setId(candidate.getId());
        category.setDescription(this.getProperty(candidate, "org.eclipse.equinox.p2.description"));
        category.setName(this.getProperty(candidate, "org.eclipse.equinox.p2.name"));
        category.setSource(this.getSource(repository));
        category.setData((Object)candidate);
        this.categoryById.put(category.getId(), category);
        this.categories.add(category);
        return category;
    }

    private Boolean isCategory(IInstallableUnit candidate) {
        return Boolean.valueOf(candidate.getProperty(IU_PROPERTY_CATEGORY));
    }
}

