/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings.internal;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.ListBinding;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.bindings.internal.SyncedBindingHelperObserver;

public class SyncListBinding<A>
extends ListBinding<A> {
    private SyncedBindingHelperObserver observer;
    private ObservableList<A> source;
    private ThreadSynchronize thread;

    public SyncListBinding(ObservableList<A> source, ThreadSynchronize thread) {
        this.source = source;
        this.thread = thread;
        this.syncedBind(new Observable[]{this.source});
    }

    public void dispose() {
        this.syncedUnbind(new Observable[]{this.source});
        super.dispose();
    }

    protected ObservableList<A> computeValue() {
        return FXCollections.observableArrayList(this.source);
    }

    protected final void syncedBind(Observable ... dependencies) {
        if (dependencies != null && dependencies.length > 0) {
            if (this.observer == null) {
                this.observer = new SyncedBindingHelperObserver(this.thread, (Binding<?>)this);
            }
            Observable[] observableArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                Observable dep = observableArray[n2];
                if (dep != null) {
                    dep.addListener((InvalidationListener)this.observer);
                }
                ++n2;
            }
        }
    }

    protected final void syncedUnbind(Observable ... dependencies) {
        if (this.observer != null) {
            Observable[] observableArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                Observable dep = observableArray[n2];
                if (dep != null) {
                    dep.removeListener((InvalidationListener)this.observer);
                }
                ++n2;
            }
            this.observer = null;
        }
    }
}

