/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.jdt;

import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;

public class CallHierarchyHelper {
    public static HashSet<IMethod> getCallersOf(IMethod m) {
        CallHierarchy callHierarchy = CallHierarchy.getDefault();
        IMember[] members = new IMember[]{m};
        MethodWrapper[] methodWrappers = callHierarchy.getCallerRoots(members);
        HashSet<IMethod> callers = new HashSet<IMethod>();
        MethodWrapper[] methodWrapperArray = methodWrappers;
        int n = methodWrappers.length;
        int n2 = 0;
        while (n2 < n) {
            MethodWrapper mw = methodWrapperArray[n2];
            MethodWrapper[] mw2 = mw.getCalls((IProgressMonitor)new NullProgressMonitor());
            HashSet<IMethod> temp = CallHierarchyHelper.getIMethods(mw2);
            callers.addAll(temp);
            ++n2;
        }
        return callers;
    }

    public static HashSet<CallLocation> getCallLocationsOf(IMethod m) {
        CallHierarchy callHierarchy = CallHierarchy.getDefault();
        IMember[] members = new IMember[]{m};
        MethodWrapper[] methodWrappers = callHierarchy.getCallerRoots(members);
        HashSet<CallLocation> callers = new HashSet<CallLocation>();
        MethodWrapper[] methodWrapperArray = methodWrappers;
        int n = methodWrappers.length;
        int n2 = 0;
        while (n2 < n) {
            MethodWrapper mw = methodWrapperArray[n2];
            MethodWrapper[] mw2 = mw.getCalls((IProgressMonitor)new NullProgressMonitor());
            HashSet<CallLocation> temp = CallHierarchyHelper.getCallLocations(mw2);
            callers.addAll(temp);
            ++n2;
        }
        return callers;
    }

    private static HashSet<IMethod> getIMethods(MethodWrapper[] methodWrappers) {
        HashSet<IMethod> c = new HashSet<IMethod>();
        MethodWrapper[] methodWrapperArray = methodWrappers;
        int n = methodWrappers.length;
        int n2 = 0;
        while (n2 < n) {
            MethodWrapper m = methodWrapperArray[n2];
            IMethod im = CallHierarchyHelper.getIMethodFromMethodWrapper(m);
            if (im != null) {
                c.add(im);
            }
            ++n2;
        }
        return c;
    }

    private static IMethod getIMethodFromMethodWrapper(MethodWrapper m) {
        try {
            IMember im = m.getMember();
            if (im.getElementType() == 9) {
                return (IMethod)m.getMember();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static HashSet<CallLocation> getCallLocations(MethodWrapper[] methodWrappers) {
        HashSet<CallLocation> c = new HashSet<CallLocation>();
        MethodWrapper[] methodWrapperArray = methodWrappers;
        int n = methodWrappers.length;
        int n2 = 0;
        while (n2 < n) {
            MethodWrapper m = methodWrapperArray[n2];
            CallLocation im = CallHierarchyHelper.getCallLocation(m);
            if (im != null) {
                c.add(im);
            }
            ++n2;
        }
        return c;
    }

    private static CallLocation getCallLocation(MethodWrapper m) {
        return m.getMethodCall().getFirstCallLocation();
    }
}

