/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.ui.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gemoc.dsl.debug.ide.Activator;
import org.eclipse.gemoc.dsl.debug.ide.launch.AbstractDSLLaunchConfigurationDelegate;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;

public abstract class AbstractDSLLaunchConfigurationDelegateUI
extends AbstractDSLLaunchConfigurationDelegate
implements ILaunchShortcut,
ILaunchShortcut2 {
    protected void launch(EObject firstInstruction, ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ExtendedImageRegistry.getInstance();
            }
        });
        super.launch(firstInstruction, configuration, mode, launch, monitor);
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return this.getLaunchConfigurations(this.getLaunchableResource(selection));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return this.getLaunchConfigurations(this.getLaunchableResource(editorpart));
    }

    public IResource getLaunchableResource(ISelection selection) {
        IResource res = null;
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                URI resourceURI;
                Object element = objectArray[n2];
                if (element instanceof IFile) {
                    res = (IResource)element;
                    break;
                }
                if (element instanceof EObject && (resourceURI = ((EObject)element).eResource().getURI()).isPlatformResource()) {
                    String pathString = resourceURI.toPlatformString(true);
                    res = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathString));
                    break;
                }
                ++n2;
            }
        }
        return res;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return ResourceUtil.getFile((IEditorInput)editorpart.getEditorInput());
    }

    public void launch(ISelection selection, String mode) {
        this.launch(this.getLaunchableResource(selection), this.getFirstInstruction(selection), mode);
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch(this.getLaunchableResource(editor), this.getFirstInstruction(editor), mode);
    }

    protected ILaunchConfiguration[] getLaunchConfigurations(IResource resource) {
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.getLaunchConfigurationTypeID());
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations(type);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                if (configuration.hasAttribute("Resource")) {
                    String pathString = configuration.getAttribute("Resource", "");
                    try {
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathString));
                        if (resource != null && resource.equals((Object)file)) {
                            configurations.add(configuration);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Activator.getDefault().error((Throwable)e);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.toString();
        }
        return configurations.toArray(new ILaunchConfiguration[configurations.size()]);
    }

    public void launch(IResource file, EObject firstInstruction, String mode) {
        if (file instanceof IFile) {
            this.prepareLaunch(file, firstInstruction, mode);
            try {
                ILaunchConfiguration[] configurations = this.getLaunchConfigurations(file);
                if (configurations.length == 0) {
                    configurations = this.createLaunchConfiguration(file, firstInstruction, mode);
                }
                if (configurations.length == 1) {
                    configurations[0].launch(mode, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)configurations[0], (String)mode);
                    DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IStructuredSelection)new StructuredSelection((Object)configurations[0]), (String)group.getIdentifier(), null);
                }
            }
            catch (CoreException e) {
                Activator.getDefault().error((Throwable)e);
            }
        }
    }

    protected void prepareLaunch(IResource file, EObject firstInstruction, String mode) {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true);
    }

    protected ILaunchConfiguration[] createLaunchConfiguration(IResource file, EObject firstInstruction, String mode) throws CoreException {
        ILaunchConfiguration[] res;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.getLaunchConfigurationTypeID());
        ILaunchConfigurationWorkingCopy configuration = type.newInstance(null, file.getName());
        configuration.setMappedResources(new IResource[]{file});
        configuration.setAttribute("Resource", file.getFullPath().toString());
        if (firstInstruction == null) {
            ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)mode);
            if (group != null) {
                configuration.doSave();
                DebugUITools.openLaunchConfigurationDialog((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)configuration, (String)group.getIdentifier(), null);
            }
            res = new ILaunchConfiguration[]{};
        } else {
            configuration.setAttribute("First Instruction", EcoreUtil.getURI((EObject)firstInstruction).toString());
            configuration.doSave();
            res = new ILaunchConfiguration[]{configuration};
        }
        return res;
    }

    protected abstract String getLaunchConfigurationTypeID();

    protected abstract EObject getFirstInstruction(ISelection var1);

    protected abstract EObject getFirstInstruction(IEditorPart var1);
}

