/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.ui.views.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.gemoc.commons.eclipse.ui.TreeViewerHelper;
import org.eclipse.gemoc.executionframework.engine.core.GemocRunningEnginesRegistry;
import org.eclipse.gemoc.executionframework.engine.core.IEngineRegistrationListener;
import org.eclipse.gemoc.executionframework.ui.Activator;
import org.eclipse.gemoc.executionframework.ui.SharedIcons;
import org.eclipse.gemoc.executionframework.ui.views.engine.IEngineSelectionListener;
import org.eclipse.gemoc.executionframework.ui.views.engine.ViewContentProvider;
import org.eclipse.gemoc.executionframework.ui.views.engine.actions.DisposeAllStoppedEnginesAction;
import org.eclipse.gemoc.executionframework.ui.views.engine.actions.DisposeStoppedEngineAction;
import org.eclipse.gemoc.executionframework.ui.views.engine.actions.StopEngineAction;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class EnginesStatusView
extends ViewPart
implements IEngineAddon,
IEngineRegistrationListener {
    public static final String ID = "org.eclipse.gemoc.executionframework.ui.views.engine.EnginesStatusView";
    public TreeViewer _viewer;
    private ViewContentProvider _contentProvider;
    private IExecutionEngine<?> selectedEngine = null;

    public void dispose() {
        org.eclipse.gemoc.executionframework.engine.Activator.getDefault().gemocRunningEngineRegistry.removeEngineRegistrationListener((IEngineRegistrationListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this._viewer = new TreeViewer(parent, 66306);
        this._contentProvider = new ViewContentProvider();
        this._viewer.setContentProvider((IContentProvider)this._contentProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this._viewer);
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EnginesStatusView.this.fireEngineSelectionChanged();
            }
        });
        this.createColumns();
        Font mono = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this._viewer.getTree().setFont(mono);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this._viewer.getControl(), "org.eclipse.gemoc.executionframework.ui.views.engine.EngineStatusView");
        this.buildMenu();
        org.eclipse.gemoc.executionframework.engine.Activator.getDefault().gemocRunningEngineRegistry.addEngineRegistrationListener((IEngineRegistrationListener)this);
    }

    private void buildMenu() {
        this.addActionToToolbar(new StopEngineAction());
        this.addActionToToolbar(new DisposeStoppedEngineAction());
        this.addActionToToolbar(new DisposeAllStoppedEnginesAction());
    }

    private void addActionToToolbar(Action action) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)action);
    }

    private void createColumns() {
        this.createColumn1();
        this.createColumn2();
        this.createColumn3();
    }

    private void createColumn1() {
        TreeColumn column = new TreeColumn(this._viewer.getTree(), 16384);
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this._viewer, column);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return null;
            }

            public Image getImage(Object element) {
                Image result = null;
                if (element instanceof IExecutionEngine) {
                    IExecutionEngine engine = (IExecutionEngine)element;
                    switch (engine.getRunningStatus()) {
                        case Running: {
                            result = SharedIcons.getSharedImage(SharedIcons.RUNNING_ENGINE_ICON);
                            break;
                        }
                        case Stopped: {
                            result = SharedIcons.getSharedImage(SharedIcons.STOPPED_ENGINE_ICON);
                            break;
                        }
                        case WaitingLogicalStepSelection: {
                            result = SharedIcons.getSharedImage(SharedIcons.WAITING_ENGINE_ICON);
                            break;
                        }
                        case Initializing: {
                            result = SharedIcons.getSharedImage(SharedIcons.ENGINE_ICON);
                            break;
                        }
                    }
                }
                return result;
            }
        });
    }

    private void createColumn2() {
        TreeColumn column = new TreeColumn(this._viewer.getTree(), 16384);
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this._viewer, column);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String result = "";
                if (element instanceof IExecutionEngine) {
                    IExecutionEngine engine = (IExecutionEngine)element;
                    result = (String)engine.getExecutionContext().getResourceModel().getURI().segmentsList().get(engine.getExecutionContext().getResourceModel().getURI().segments().length - 1);
                }
                return result;
            }

            public Image getImage(Object element) {
                Image result = null;
                return result;
            }

            public String getToolTipText(Object element) {
                String result = "";
                if (element instanceof IExecutionEngine) {
                    IExecutionEngine engine = (IExecutionEngine)element;
                    GemocRunningEnginesRegistry registry = org.eclipse.gemoc.executionframework.engine.Activator.getDefault().gemocRunningEngineRegistry;
                    for (Map.Entry e : registry.getRunningEngines().entrySet()) {
                        if (e.getValue() != engine) continue;
                        result = (String)e.getKey();
                        break;
                    }
                    result = String.valueOf(result) + "\n";
                    switch (engine.getRunningStatus()) {
                        case Initializing: {
                            result = String.valueOf(result) + "Initializing";
                            break;
                        }
                        case Running: {
                            result = String.valueOf(result) + "Running";
                            break;
                        }
                        case WaitingLogicalStepSelection: {
                            result = String.valueOf(result) + "Waiting LogicalStep Selection";
                            break;
                        }
                        case Stopped: {
                            result = String.valueOf(result) + "Stopped";
                        }
                    }
                    result = String.valueOf(result) + "\n";
                    result = String.valueOf(result) + "Step " + engine.getEngineStatus().getNbLogicalStepRun();
                }
                return result;
            }
        });
    }

    private void createColumn3() {
        TreeColumn column = new TreeColumn(this._viewer.getTree(), 16384);
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this._viewer, column);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String result = "";
                if (element instanceof IExecutionEngine) {
                    IExecutionEngine engine = (IExecutionEngine)element;
                    result = String.format("%d", engine.getEngineStatus().getNbLogicalStepRun());
                }
                return result;
            }
        });
    }

    public void setFocus() {
        this._viewer.getControl().setFocus();
    }

    public IExecutionEngine<?> getSelectedEngine() {
        try {
            IStructuredSelection selection = (IStructuredSelection)this._viewer.getSelection();
            return (IExecutionEngine)selection.getFirstElement();
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
            return null;
        }
    }

    public void removeStoppedEngines() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry engineEntry : org.eclipse.gemoc.executionframework.engine.Activator.getDefault().gemocRunningEngineRegistry.getRunningEngines().entrySet()) {
                    switch (((IExecutionEngine)engineEntry.getValue()).getRunningStatus()) {
                        case Stopped: {
                            ((IExecutionEngine)engineEntry.getValue()).dispose();
                            org.eclipse.gemoc.executionframework.engine.Activator.getDefault().gemocRunningEngineRegistry.unregisterEngine((String)engineEntry.getKey());
                        }
                    }
                }
                EnginesStatusView.this._viewer.setInput((Object)org.eclipse.gemoc.executionframework.engine.Activator.getDefault().gemocRunningEngineRegistry);
            }
        });
    }

    private void fireEngineSelectionChanged() {
        IExecutionEngine<?> engine = this.getSelectedEngine();
        if (engine != this.selectedEngine) {
            this.selectedEngine = engine;
            for (IEngineSelectionListener listener : Activator.getDefault().getEngineSelectionManager().getEngineSelectionListeners()) {
                listener.engineSelectionChanged(this.selectedEngine);
            }
        }
    }

    public void engineRegistered(final IExecutionEngine<?> engine) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                engine.getExecutionContext().getExecutionPlatform().addEngineAddon((IEngineAddon)EnginesStatusView.this);
                EnginesStatusView.this._viewer.setInput((Object)org.eclipse.gemoc.executionframework.engine.Activator.getDefault().gemocRunningEngineRegistry);
                TreeViewerHelper.resizeColumns((TreeViewer)EnginesStatusView.this._viewer);
                TreePath treePath = new TreePath(new Object[]{engine});
                TreeSelection newSelection = new TreeSelection(treePath);
                EnginesStatusView.this._viewer.setSelection((ISelection)newSelection, true);
            }
        });
    }

    public void engineUnregistered(IExecutionEngine<?> engine) {
        engine.getExecutionContext().getExecutionPlatform().removeEngineAddon((IEngineAddon)this);
    }

    private void updateUserInterface(IExecutionEngine<?> engine) {
        this._viewer.update(engine, null);
        TreeViewerHelper.resizeColumns((TreeViewer)this._viewer);
    }

    private void reselectEngine(final IExecutionEngine<?> engine) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EnginesStatusView.this.updateUserInterface(engine);
                if (EnginesStatusView.this.getSelectedEngine() == engine) {
                    EnginesStatusView.this.fireEngineSelectionChanged();
                }
            }
        });
    }

    public void engineAboutToStart(IExecutionEngine<?> engine) {
    }

    public void engineStarted(IExecutionEngine<?> engine) {
        this.reselectEngine(engine);
    }

    public void aboutToExecuteStep(IExecutionEngine<?> executionEngine, Step<?> logicalStepToApply) {
    }

    public void engineAboutToStop(IExecutionEngine<?> engine) {
        this.reselectEngine(engine);
    }

    public void engineStopped(IExecutionEngine<?> engine) {
        this.reselectEngine(engine);
    }

    public void aboutToSelectStep(IExecutionEngine<?> engine, Collection<Step<?>> logicalSteps) {
        this.reselectEngine(engine);
    }

    public void stepSelected(IExecutionEngine<?> engine, Step<?> selectedLogicalStep) {
    }

    public void stepExecuted(IExecutionEngine<?> engine, Step<?> logicalStepExecuted) {
        this.reselectEngine(engine);
    }

    public void engineStatusChanged(IExecutionEngine<?> engine, EngineStatus.RunStatus newStatus) {
    }

    public void proposedStepsChanged(IExecutionEngine<?> engine, Collection<Step<?>> logicalSteps) {
        this.reselectEngine(engine);
    }

    public void engineAboutToDispose(IExecutionEngine<?> engine) {
    }

    public List<String> validate(List<IEngineAddon> otherAddons) {
        return new ArrayList<String>();
    }
}

