/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;

class VisibleLinesTracker
implements PaintListener {
    private static final String DATA_KEY = VisibleLinesTracker.class.getName();
    private final ITextViewer viewer;
    private int oldBottom = -1;
    private int oldBottomPixel;
    private final Collection<Consumer<StyledText>> handlers;

    private VisibleLinesTracker(ITextViewer viewer) {
        this.viewer = viewer;
        this.handlers = new ArrayList<Consumer<StyledText>>();
    }

    public void paintControl(PaintEvent e) {
        StyledText textWidget = this.viewer.getTextWidget();
        if (this.oldBottom == -1) {
            this.oldBottom = JFaceTextUtil.getPartialBottomIndex(this.viewer);
            this.oldBottomPixel = JFaceTextUtil.getLinePixel(textWidget, this.oldBottom);
            return;
        }
        int newBottom = JFaceTextUtil.getPartialBottomIndex(this.viewer);
        if (newBottom != this.oldBottom) {
            this.oldBottom = newBottom;
            this.oldBottomPixel = JFaceTextUtil.getLinePixel(textWidget, this.oldBottom);
            this.handlers.forEach(handler -> handler.accept(textWidget));
            return;
        }
        int newBottomPixel = JFaceTextUtil.getLinePixel(textWidget, newBottom);
        if (newBottomPixel != this.oldBottomPixel) {
            this.oldBottomPixel = newBottomPixel;
            this.handlers.forEach(handler -> handler.accept(textWidget));
            return;
        }
    }

    static void track(ITextViewer viewer, Consumer<StyledText> handler) {
        StyledText textWidget;
        StyledText styledText = textWidget = viewer != null ? viewer.getTextWidget() : null;
        if (textWidget == null) {
            return;
        }
        VisibleLinesTracker tracker = (VisibleLinesTracker)textWidget.getData(DATA_KEY);
        if (tracker == null) {
            tracker = new VisibleLinesTracker(viewer);
            textWidget.setData(DATA_KEY, (Object)tracker);
        }
        tracker.addHandler(handler);
    }

    static void untrack(ITextViewer viewer, Consumer<StyledText> handler) {
        StyledText textWidget;
        StyledText styledText = textWidget = viewer != null ? viewer.getTextWidget() : null;
        if (textWidget == null) {
            return;
        }
        VisibleLinesTracker tracker = (VisibleLinesTracker)textWidget.getData(DATA_KEY);
        if (tracker != null) {
            tracker.removeHandler(handler);
        }
    }

    private void addHandler(Consumer<StyledText> handler) {
        if (this.handlers.isEmpty()) {
            this.viewer.getTextWidget().addPaintListener((PaintListener)this);
        }
        this.handlers.add(handler);
    }

    private void removeHandler(Consumer<StyledText> handler) {
        this.handlers.remove(handler);
        if (this.handlers.isEmpty()) {
            this.viewer.getTextWidget().removePaintListener((PaintListener)this);
        }
    }
}

