/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;

public class TemplateSpecialisation {
    protected final @NonNull CompleteEnvironment environment;
    protected Map<TemplateParameter, Type> bindings = null;

    public static boolean needsSpecialisation(@Nullable Type referencedType) {
        TemplateSignature templateSignature;
        if (referencedType == null) {
            return true;
        }
        TemplateParameter templateParameter = referencedType.isTemplateParameter();
        if (templateParameter != null) {
            return true;
        }
        if (referencedType instanceof CollectionType) {
            Type elementType = ((CollectionType)referencedType).getElementType();
            return TemplateSpecialisation.needsSpecialisation(elementType);
        }
        if (referencedType instanceof TupleType) {
            TupleType tupleType = (TupleType)referencedType;
            for (Property tuplePart : tupleType.getOwnedProperties()) {
                Type type = tuplePart.getType();
                if (!TemplateSpecialisation.needsSpecialisation(type)) continue;
                return true;
            }
            return false;
        }
        if (referencedType instanceof LambdaType) {
            LambdaType lambdaType = (LambdaType)referencedType;
            Type contextType = lambdaType.getContextType();
            if (TemplateSpecialisation.needsSpecialisation(contextType)) {
                return true;
            }
            Type resultType = lambdaType.getResultType();
            if (TemplateSpecialisation.needsSpecialisation(resultType)) {
                return true;
            }
            for (Type type : lambdaType.getParameterTypes()) {
                if (!TemplateSpecialisation.needsSpecialisation(type)) continue;
                return true;
            }
            return false;
        }
        return referencedType instanceof Class && (templateSignature = ((Class)referencedType).getOwnedSignature()) != null;
    }

    public TemplateSpecialisation(@NonNull CompleteEnvironment environment) {
        this.environment = environment;
    }

    private @Nullable Type getResolution(@Nullable Type referencedType) {
        TemplateParameter templateParameter;
        if (referencedType != null && (templateParameter = referencedType.isTemplateParameter()) != null) {
            return this.bindings != null ? this.bindings.get(templateParameter) : null;
        }
        if (referencedType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)referencedType;
            Type elementType = this.getResolution(collectionType.getElementType());
            if (elementType == null) {
                elementType = this.environment.getOwnedStandardLibrary().getOclAnyType();
            }
            Class containerType = ClassUtil.nonNullState(collectionType.getContainerType());
            return this.environment.getCollectionType(containerType, elementType, false, collectionType.getLowerValue(), collectionType.getUpperValue());
        }
        if (referencedType instanceof TupleType) {
            throw new UnsupportedOperationException();
        }
        if (referencedType instanceof LambdaType) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public @NonNull Class getSpecialisation(@NonNull Type referredType) {
        Type specialisation = this.getResolution(referredType);
        return (Class)(specialisation != null ? specialisation : referredType);
    }

    public void installEquivalence(@Nullable Type resolvedType, @Nullable Type referencedType) {
        if (resolvedType == null) {
            return;
        }
        if (referencedType == null) {
            return;
        }
        TemplateParameter templateParameter = referencedType.isTemplateParameter();
        if (templateParameter != null) {
            if (this.bindings == null) {
                this.bindings = new HashMap<TemplateParameter, Type>();
            }
            if (this.bindings.put(templateParameter, resolvedType) != null) {
                this.bindings.put(templateParameter, null);
            }
            return;
        }
        if (referencedType instanceof CollectionType) {
            if (resolvedType instanceof CollectionType) {
                Type resolvedElementType = ((CollectionType)resolvedType).getElementType();
                Type referencedElementType = ((CollectionType)referencedType).getElementType();
                this.installEquivalence(resolvedElementType, referencedElementType);
            }
            return;
        }
        if (referencedType instanceof TupleType) {
            if (resolvedType instanceof TupleType) {
                TupleType referencedTupleType = (TupleType)referencedType;
                TupleType resolvedTupleType = (TupleType)resolvedType;
                List<Property> referencedTupleParts = referencedTupleType.getOwnedProperties();
                for (Property resolvedTuplePart : resolvedTupleType.getOwnedProperties()) {
                    Property referencedTuplePart = NameUtil.getNameable(referencedTupleParts, resolvedTuplePart.getName());
                    if (referencedTuplePart == null) continue;
                    Type resolvedTuplePartType = resolvedTuplePart.getType();
                    Type referencedTuplePartType = referencedTuplePart.getType();
                    this.installEquivalence(resolvedTuplePartType, referencedTuplePartType);
                }
            }
            return;
        }
        if (referencedType instanceof LambdaType) {
            if (resolvedType instanceof LambdaType) {
                LambdaType referencedLambdaType = (LambdaType)referencedType;
                LambdaType resolvedLambdaType = (LambdaType)resolvedType;
                this.installEquivalence(resolvedLambdaType.getContextType(), referencedLambdaType.getContextType());
                this.installEquivalence(resolvedLambdaType.getResultType(), referencedLambdaType.getResultType());
                List<? extends Type> resolvedParameterTypes = resolvedLambdaType.getParameterTypes();
                List<? extends Type> referencedParameterTypes = referencedLambdaType.getParameterTypes();
                int i = 0;
                while (i < Math.min(resolvedParameterTypes.size(), referencedParameterTypes.size())) {
                    Type resolvedParameterType = resolvedParameterTypes.get(i);
                    Type referencedParameterType = referencedParameterTypes.get(i);
                    this.installEquivalence(resolvedParameterType, referencedParameterType);
                    ++i;
                }
            }
            return;
        }
    }
}

