/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.mtl.business.internal.extension;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.common.acceleo.mtl.business.api.extension.AbstractImportHandler;
import org.eclipse.sirius.common.acceleo.mtl.business.internal.extension.ImportHandlerDescriptor;

public final class ImportHandlerRegistry {
    private static final List<ImportHandlerDescriptor> HANDLERS = new ArrayList<ImportHandlerDescriptor>();

    private ImportHandlerRegistry() {
    }

    public static void addHandler(ImportHandlerDescriptor descriptor) {
        HANDLERS.add(descriptor);
    }

    public static void clearRegistry() {
        HANDLERS.clear();
    }

    public static List<AbstractImportHandler> getRegisteredHandlers() {
        ArrayList<AbstractImportHandler> importHandlers = new ArrayList<AbstractImportHandler>();
        for (ImportHandlerDescriptor descriptor : HANDLERS) {
            importHandlers.add(descriptor.getImportHandler());
        }
        return importHandlers;
    }

    public static void removeHandler(String className) {
        for (ImportHandlerDescriptor descriptor : Lists.newArrayList(HANDLERS)) {
            if (!descriptor.getClassName().equals(className)) continue;
            HANDLERS.remove(descriptor);
        }
    }
}

