/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;
import org.eclipse.sirius.common.tools.internal.resource.ResourceDeltaVisitor;
import org.eclipse.sirius.common.tools.internal.resource.ResourceSyncClientNotifier;
import org.eclipse.sirius.common.tools.internal.resource.WorkspaceBackend;

public class EditingSessionWorkspaceListener
implements IResourceChangeListener {
    private WorkspaceBackend workspaceBackend;

    public EditingSessionWorkspaceListener(WorkspaceBackend workspaceBackend) {
        this.workspaceBackend = workspaceBackend;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            if (delta != null) {
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this.workspaceBackend);
                delta.accept((IResourceDeltaVisitor)visitor);
                Collection<ResourceSyncClient.ResourceStatusChange> changes = this.getChanges(visitor);
                if (!changes.isEmpty()) {
                    ResourceSyncClientNotifier resourceSyncClientNotifier = new ResourceSyncClientNotifier(this.workspaceBackend.getClient(), changes);
                    resourceSyncClientNotifier.run((IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (CoreException exception) {
            DslCommonPlugin.getDefault().error(Messages.EditingSessionWorkspaceListener_resourceRefreshError, exception);
        }
    }

    private Collection<ResourceSyncClient.ResourceStatusChange> getChanges(ResourceDeltaVisitor resourceDeltaVisitor) {
        ResourceSetSync.ResourceStatus oldStatus;
        ArrayList<ResourceSyncClient.ResourceStatusChange> changes = new ArrayList<ResourceSyncClient.ResourceStatusChange>();
        for (Resource removedRes : resourceDeltaVisitor.getRemovedResources()) {
            oldStatus = ResourceSetSync.getStatus(removedRes);
            if (this.workspaceBackend.isChanged(oldStatus)) {
                changes.add(new ResourceSyncClient.ResourceStatusChange(removedRes, ResourceSetSync.ResourceStatus.CONFLICTING_DELETED, oldStatus));
                continue;
            }
            changes.add(new ResourceSyncClient.ResourceStatusChange(removedRes, ResourceSetSync.ResourceStatus.DELETED, oldStatus));
        }
        for (Resource changedResource : resourceDeltaVisitor.getChangedResources()) {
            oldStatus = ResourceSetSync.getStatus(changedResource);
            if (this.workspaceBackend.isChanged(oldStatus)) {
                changes.add(new ResourceSyncClient.ResourceStatusChange(changedResource, ResourceSetSync.ResourceStatus.CONFLICTING_CHANGED, oldStatus));
                continue;
            }
            changes.add(new ResourceSyncClient.ResourceStatusChange(changedResource, ResourceSetSync.ResourceStatus.EXTERNAL_CHANGED, oldStatus));
        }
        for (Resource addedResource : resourceDeltaVisitor.getAddedResources()) {
            oldStatus = ResourceSetSync.getStatus(addedResource);
            if (!ResourceSetSync.ResourceStatus.SYNC.equals((Object)oldStatus)) continue;
            changes.add(new ResourceSyncClient.ResourceStatusChange(addedResource, ResourceSetSync.ResourceStatus.SYNC, oldStatus));
        }
        return changes;
    }
}

