/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.layout;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramDescriptionProvider;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.AbstractDiagramAction;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractCopyPasteFormatAction
extends AbstractDiagramAction {
    private IWorkbenchPart representationPart;

    public AbstractCopyPasteFormatAction(IWorkbenchPage workbenchPage, IWorkbenchPart actionWorkbenchPart) {
        super(workbenchPage);
        this.representationPart = actionWorkbenchPart;
    }

    protected final Request createTargetRequest() {
        return null;
    }

    protected final boolean isSelectionListener() {
        return true;
    }

    public void dispose() {
        super.dispose();
        this.representationPart = null;
    }

    @Override
    protected final boolean calculateEnabled() {
        Predicate<DSemanticDecorator> allowsPasteFormat;
        boolean enable = false;
        if (this.representationPart != null && !this.representationPart.equals(this.getWorkbenchPart())) {
            return super.isEnabled();
        }
        Collection<DSemanticDecorator> dSelection = this.getDSelection(this.getSelectedObjects());
        DDiagram parentDiagram = null;
        for (DSemanticDecorator dsem : dSelection) {
            if (dsem instanceof DDiagram) {
                parentDiagram = (DDiagram)dsem;
            } else if (dsem instanceof DDiagramElement) {
                parentDiagram = ((DDiagramElement)dsem).getParentDiagram();
            }
            if (parentDiagram != null) break;
        }
        if (parentDiagram != null && Iterables.all(dSelection, allowsPasteFormat = AbstractCopyPasteFormatAction.allowsCopyPasteFormat(parentDiagram))) {
            enable = super.calculateEnabled();
        }
        return enable;
    }

    private Collection<DSemanticDecorator> getDSelection(Collection<?> selection) {
        if (selection != null && !selection.isEmpty()) {
            ArrayList<DSemanticDecorator> elements = new ArrayList<DSemanticDecorator>();
            for (IGraphicalEditPart part : Iterables.filter(selection, IGraphicalEditPart.class)) {
                EObject semanticElement = part.resolveSemanticElement();
                if (semanticElement instanceof DDiagramElement) {
                    elements.add((DSemanticDecorator)((DDiagramElement)semanticElement));
                    continue;
                }
                if (!(semanticElement instanceof DSemanticDiagram)) continue;
                elements.add((DSemanticDecorator)((DSemanticDiagram)semanticElement));
            }
            return elements;
        }
        return Collections.emptyList();
    }

    public static Predicate<DSemanticDecorator> allowsCopyPasteFormat(DDiagram diagram) {
        Predicate result = Predicates.alwaysTrue();
        if (diagram == null || diagram.getDescription() == null) {
            return Predicates.alwaysFalse();
        }
        for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(diagram.getDescription().eClass().getEPackage())) continue;
            final IDiagramDescriptionProvider provider = diagramTypeDescriptor.getDiagramDescriptionProvider();
            result = new Predicate<DSemanticDecorator>(){

                public boolean apply(DSemanticDecorator input) {
                    return provider.allowsCopyPasteFormat(input);
                }
            };
            break;
        }
        return result;
    }
}

