/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.internal.graphicalcomponents.GraphicalRepresentationHandler;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.SiriusCommonContentProvider;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SingleRepresentationTreeSelectionDialog
extends Dialog {
    private final Session session;
    private DRepresentationDescriptor selected;
    private TreeViewer viewer;
    private GraphicalRepresentationHandler handler;

    public SingleRepresentationTreeSelectionDialog(Shell parentShell, Session session) {
        super(parentShell);
        this.session = session;
    }

    protected Point getInitialSize() {
        return new Point(500, 340);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SingleRepresentationTreeSelectionDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite compo = (Composite)super.createDialogArea(parent);
        GraphicalRepresentationHandler.GraphicalRepresentationHandlerBuilder builder = new GraphicalRepresentationHandler.GraphicalRepresentationHandlerBuilder(this.session);
        builder.activateHideBrowser().customizeContentAndLabel((ITreeContentProvider)new SiriusCommonContentProvider(this.session, null), null).filterEmptyViewpoints().filterEmptyRepresentationDescriptors();
        this.handler = builder.build();
        this.handler.createControl(compo);
        this.handler.initInput();
        this.viewer = this.handler.getTreeViewer();
        return compo;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.getButton(0).setEnabled(false);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1 && selection.getFirstElement() instanceof RepresentationItemImpl) {
                    SingleRepresentationTreeSelectionDialog.this.selected = ((RepresentationItemImpl)selection.getFirstElement()).getDRepresentationDescriptor();
                } else {
                    SingleRepresentationTreeSelectionDialog.this.selected = null;
                }
                SingleRepresentationTreeSelectionDialog.this.getButton(0).setEnabled(SingleRepresentationTreeSelectionDialog.this.selected != null);
            }
        });
        return result;
    }

    public DRepresentationDescriptor getResult() {
        return this.selected;
    }

    public boolean close() {
        if (this.handler != null) {
            this.handler.dispose();
        }
        return super.close();
    }

    public static DRepresentationDescriptor openSelectRepresentationDescriptor(Shell shell, Session session) {
        SingleRepresentationTreeSelectionDialog dialog = new SingleRepresentationTreeSelectionDialog(shell, session);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }
}

