/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.al.annotationprocessor;

import com.google.common.base.Objects;
import fr.inria.diverse.k3.al.annotationprocessor.Abstract;
import fr.inria.diverse.k3.al.annotationprocessor.Aspect;
import fr.inria.diverse.k3.al.annotationprocessor.AspectMappingBuilder;
import fr.inria.diverse.k3.al.annotationprocessor.Helper;
import fr.inria.diverse.k3.al.annotationprocessor.OverrideAspectMethod;
import fr.inria.diverse.k3.al.annotationprocessor.ProjectStaticDispatchBuilder;
import fr.inria.diverse.k3.al.annotationprocessor.Step;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.CodeGenerationContext;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableConstructorDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtend.lib.macro.services.GlobalTypeLookup;
import org.eclipse.xtend.lib.macro.services.TypeLookup;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class AspectProcessor
extends AbstractClassProcessor {
    private Map<MutableClassDeclaration, List<MutableClassDeclaration>> listResMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private AspectMappingBuilder aspectMappingBuilder;
    private final ProjectStaticDispatchBuilder projectStaticDispatchBuilder = new ProjectStaticDispatchBuilder();
    public static final String CTX_NAME = "AspectContext";
    public static final String PROP_NAME = "AspectProperties";
    public static final String OVERRIDE_METHOD = OverrideAspectMethod.class.getSimpleName();
    public static final String STEP = Step.class.getSimpleName();
    public static final String PROP_VAR_NAME = "_self_";
    public static final String SELF_VAR_NAME = "_self";
    public static final String PRIV_PREFIX = "_privk3_";
    public static final String PRIV_CONSTRUCTOR_POSTFIX = "_constructor_initializer";
    public static final String RESULT_VAR = "result";
    public static final String DISPATCH_POINTCUT_KEY = "#DispatchPointCut_before#";
    public static Boolean lock = false;
    private List<? extends MutableClassDeclaration> mclasses = null;

    public void doRegisterGlobals(ClassDeclaration annotatedClass, RegisterGlobalsContext context) {
        TypeReference type = Helper.getAnnotationAspectType((TypeDeclaration)annotatedClass);
        if (type != null) {
            String className = type.getSimpleName();
            String _qualifiedName = annotatedClass.getQualifiedName();
            String _plus = String.valueOf(_qualifiedName) + className;
            String _plus_1 = String.valueOf(_plus) + PROP_NAME;
            context.registerClass(_plus_1);
            String _qualifiedName_1 = annotatedClass.getQualifiedName();
            String _plus_2 = String.valueOf(_qualifiedName_1) + className;
            String _plus_3 = String.valueOf(_plus_2) + CTX_NAME;
            context.registerClass(_plus_3);
        }
    }

    public void doTransform(List<? extends MutableClassDeclaration> classes, @Extension TransformationContext context) {
        this.mclasses = classes;
        for (MutableClassDeclaration mutableClassDeclaration : classes) {
            List<MutableClassDeclaration> listRes = Helper.sortByClassInheritance(mutableClassDeclaration, classes, (TypeLookup)context);
            Functions.Function1 _function = it -> it.getSimpleName();
            List inheritList = ListExtensions.map(listRes, (Functions.Function1)_function);
            this.listResMap.put(mutableClassDeclaration, listRes);
            TypeReference typeRef = Helper.getAnnotationAspectType((TypeDeclaration)mutableClassDeclaration);
            if (typeRef == null) {
                context.addError((Element)mutableClassDeclaration, "The aspectized class cannot be resolved.");
                continue;
            }
            String className = typeRef.getSimpleName();
            String identifier = typeRef.getName();
            HashMap bodies = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
            this.fieldsProcessing(context, mutableClassDeclaration, className, identifier, bodies);
            this.methodsProcessing(mutableClassDeclaration, context, identifier, bodies, inheritList, className);
            this.constructorsProcessing(mutableClassDeclaration, context, identifier, bodies, className);
            this.aspectContextMaker(context, mutableClassDeclaration, className, identifier);
        }
        this.aspectMappingBuilder = AspectMappingBuilder.getAspectMappingBuilder(context.getProjectFolder(((MutableClassDeclaration)IterableExtensions.head(classes)).getCompilationUnit().getFilePath()).toString());
        this.aspectMappingBuilder.readCurrentMapping(classes, context);
        this.aspectMappingBuilder.cleanUnusedMapping(context);
        this.aspectMappingBuilder.addMappingForAnnotatedSourceElements();
    }

    public void doGenerateCode(List<? extends ClassDeclaration> annotatedSourceElements, @Extension CodeGenerationContext context) {
        this.aspectMappingBuilder.writePropertyFile(context);
        for (ClassDeclaration classDeclaration : annotatedSourceElements) {
            this.generateAspectJCodeForClass(classDeclaration, context);
        }
        for (ClassDeclaration classDeclaration : annotatedSourceElements) {
            this.injectDispatchInParentAspects(classDeclaration, context);
        }
        Functions.Function1 function1 = classDecl_2 -> classDecl_2.getCompilationUnit();
        Consumer<CompilationUnit> _function_1 = cu -> this.projectStaticDispatchBuilder.writeTempStaticDispatchFile((CompilationUnit)cu, context);
        ListExtensions.map(annotatedSourceElements, (Functions.Function1)function1).forEach(_function_1);
    }

    private void methodProcessingAddSelfStatic(MutableMethodDeclaration m, String identifier, @Extension TransformationContext cxt) {
        if (IterableExtensions.isEmpty((Iterable)m.getParameters()) || !Objects.equal((Object)((MutableParameterDeclaration)IterableExtensions.head((Iterable)m.getParameters())).getSimpleName(), (Object)SELF_VAR_NAME)) {
            ArrayList<Pair> l = new ArrayList<Pair>();
            Iterable _parameters = m.getParameters();
            for (MutableParameterDeclaration p1 : _parameters) {
                String _simpleName = p1.getSimpleName();
                TypeReference _type = p1.getType();
                Pair _pair = new Pair((Object)_simpleName, (Object)_type);
                l.add(_pair);
            }
            IterableExtensions.toList((Iterable)m.getParameters()).clear();
            m.addParameter(SELF_VAR_NAME, cxt.newTypeReference(identifier, new TypeReference[0]));
            for (Pair param : l) {
                m.addParameter((String)param.getKey(), (TypeReference)param.getValue());
            }
            boolean _isAbstract = m.isAbstract();
            if (_isAbstract) {
                m.addAnnotation(cxt.newAnnotationReference(cxt.findTypeGlobally(Abstract.class)));
            }
        }
        m.setStatic(true);
    }

    private void methodProcessingAddSuper(MutableMethodDeclaration m, MutableClassDeclaration clazz, String aspectizedClassName, @Extension TransformationContext cxt) {
        boolean _isEmpty;
        boolean _tripleEquals;
        boolean _not;
        Functions.Function1 _function = it -> {
            String _simpleName = it.getAnnotationTypeDeclaration().getSimpleName();
            return Objects.equal((Object)_simpleName, (Object)OVERRIDE_METHOD);
        };
        boolean _exists = IterableExtensions.exists((Iterable)m.getAnnotations(), (Functions.Function1)_function);
        boolean bl = _not = !_exists;
        if (_not) {
            return;
        }
        Functions.Function1 _function_1 = cl -> {
            Type _findTypeGlobally = cxt.findTypeGlobally(cl.getName());
            return (ClassDeclaration)_findTypeGlobally;
        };
        Set superClasses = IterableExtensions.toSet((Iterable)IterableExtensions.filterNull((Iterable)ListExtensions.map(Helper.getAnnotationWithType((TypeDeclaration)clazz), (Functions.Function1)_function_1)));
        ClassDeclaration _xifexpression = null;
        TypeReference _extendedClass = clazz.getExtendedClass();
        boolean bl2 = _tripleEquals = _extendedClass == null;
        if (_tripleEquals) {
            _xifexpression = null;
        } else {
            Type _findTypeGlobally = cxt.findTypeGlobally(clazz.getExtendedClass().getName());
            _xifexpression = (ClassDeclaration)_findTypeGlobally;
        }
        ClassDeclaration superCl = _xifexpression;
        if (superCl != null) {
            superClasses.add(superCl);
        }
        if (_isEmpty = superClasses.isEmpty()) {
            return;
        }
        Functions.Function1 _function_2 = sc -> Helper.findMethod(sc, m, cxt);
        Functions.Function1 _function_3 = it -> {
            Functions.Function1 _function_4 = it_1 -> {
                String _simpleName = it_1.getAnnotationTypeDeclaration().getSimpleName();
                return Objects.equal((Object)_simpleName, (Object)"Abstract");
            };
            AnnotationReference _findFirst = (AnnotationReference)IterableExtensions.findFirst((Iterable)it.getAnnotations(), (Functions.Function1)_function_4);
            return _findFirst == null;
        };
        Iterable superMeths = IterableExtensions.filter((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)superClasses, (Functions.Function1)_function_2)), (Functions.Function1)_function_3);
        int _size = IterableExtensions.size((Iterable)superMeths);
        boolean multiSuper = _size > 1;
        Consumer<MethodDeclaration> _function_4 = sm -> {
            String superAspectedClassName = (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)Helper.getAspectedClassName(sm.getDeclaringType()).split("\\."))));
            String _xifexpression_1 = null;
            _xifexpression_1 = multiSuper ? "super_" + superAspectedClassName + "_" : "super_";
            String superNamePrefix = _xifexpression_1;
            String _simpleName = m.getSimpleName();
            String _plus = String.valueOf(superNamePrefix) + _simpleName;
            Procedures.Procedure1 _function_5 = it -> {
                StringBuilder paramsList = new StringBuilder();
                it.setVisibility(Visibility.PRIVATE);
                it.setStatic(true);
                it.setReturnType(m.getReturnType());
                Iterable _parameters = m.getParameters();
                for (MutableParameterDeclaration p : _parameters) {
                    it.addParameter(p.getSimpleName(), p.getType());
                }
                Functions.Function1 _function_6 = it_1 -> it_1.getSimpleName();
                paramsList.append(IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)m.getParameters(), (Functions.Function1)_function_6), (CharSequence)","));
                CompilationStrategy _function_7 = it_1 -> {
                    boolean _notEquals;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("final ");
                    String _name = cxt.newTypeReference((Type)sm.getDeclaringType(), new TypeReference[0]).getName();
                    String _plus_1 = String.valueOf(_name) + superAspectedClassName;
                    String _plus_2 = String.valueOf(_plus_1) + PROP_NAME;
                    _builder.append(_plus_2);
                    _builder.append(" ");
                    _builder.append(PROP_VAR_NAME);
                    _builder.append(" = ");
                    String _name_1 = cxt.newTypeReference((Type)sm.getDeclaringType(), new TypeReference[0]).getName();
                    String _plus_3 = String.valueOf(_name_1) + superAspectedClassName;
                    String _plus_4 = String.valueOf(_plus_3) + CTX_NAME;
                    _builder.append(_plus_4);
                    _builder.append(".getSelf(");
                    _builder.append(SELF_VAR_NAME);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    String _name_2 = sm.getReturnType().getName();
                    boolean bl = _notEquals = !Objects.equal((Object)_name_2, (Object)"void");
                    if (_notEquals) {
                        _builder.append("return ");
                    }
                    _builder.append(" ");
                    String _name_3 = cxt.newTypeReference((Type)sm.getDeclaringType(), new TypeReference[0]).getName();
                    _builder.append(_name_3);
                    _builder.append(".");
                    String _simpleName_1 = m.getSimpleName();
                    String _plus_5 = PRIV_PREFIX + _simpleName_1;
                    _builder.append(_plus_5);
                    _builder.append("(");
                    _builder.append(PROP_VAR_NAME);
                    _builder.append(", ");
                    _builder.append((Object)paramsList);
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    return _builder;
                };
                it.setBody(_function_7);
                cxt.setPrimarySourceElement((MutableElement)it, (Element)m);
            };
            clazz.addMethod(_plus, _function_5);
        };
        superMeths.forEach(_function_4);
    }

    private void methodProcessingAddHidden(MutableMethodDeclaration m, String identifier, @Extension TransformationContext cxt) {
        MutableClassDeclaration cl;
        Functions.Function1 _function = it -> {
            String _simpleName = it.getAnnotationTypeDeclaration().getSimpleName();
            return Objects.equal((Object)_simpleName, (Object)"ReplaceAspectMethod");
        };
        boolean _exists = IterableExtensions.exists((Iterable)m.getAnnotations(), (Functions.Function1)_function);
        if (_exists && (cl = cxt.findClass(identifier)) != null) {
            Functions.Function1 _function_1 = m2 -> Objects.equal((Object)m2.getSimpleName(), (Object)m.getSimpleName()) && IterableExtensions.size((Iterable)m2.getParameters()) == IterableExtensions.size((Iterable)m.getParameters()) - 1;
            MutableMethodDeclaration m22 = (MutableMethodDeclaration)IterableExtensions.findFirst((Iterable)cl.getDeclaredMethods(), (Functions.Function1)_function_1);
            String _simpleName = m.getSimpleName();
            String _plus = "_hidden_" + _simpleName;
            m22.setSimpleName(_plus);
        }
    }

    private void methodProcessingAddPriv(MutableMethodDeclaration m, MutableClassDeclaration clazz, String aspectizedClassName, Map<MutableMethodDeclaration, String> bodies, @Extension TransformationContext cxt) {
        String _simpleName = m.getSimpleName();
        String _plus = PRIV_PREFIX + _simpleName;
        Procedures.Procedure1 _function = it -> {
            cxt.setPrimarySourceElement((MutableElement)it, (Element)m);
            it.setVisibility(Visibility.PROTECTED);
            it.setStatic(true);
            it.setAbstract(false);
            it.setReturnType(m.getReturnType());
            boolean _isAbstract = m.isAbstract();
            if (_isAbstract) {
                CompilationStrategy _function_1 = it_1 -> {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("throw new java.lang.RuntimeException(\"Not implemented\");");
                    return _builder;
                };
                it.setBody(_function_1);
            } else {
                boolean _tripleEquals;
                Expression _body = m.getBody();
                boolean bl = _tripleEquals = _body == null;
                if (_tripleEquals) {
                    CompilationStrategy _function_2 = it_1 -> (CharSequence)bodies.get(m);
                    it.setBody(_function_2);
                } else {
                    it.setBody(m.getBody());
                }
            }
            String _qualifiedName = clazz.getQualifiedName();
            String _plus_1 = String.valueOf(_qualifiedName) + aspectizedClassName;
            String _plus_2 = String.valueOf(_plus_1) + PROP_NAME;
            it.addParameter(PROP_VAR_NAME, cxt.newTypeReference((Type)cxt.findClass(_plus_2), new TypeReference[0]));
            Iterable _parameters = m.getParameters();
            for (MutableParameterDeclaration p : _parameters) {
                it.addParameter(p.getSimpleName(), p.getType());
            }
        };
        clazz.addMethod(_plus, _function);
    }

    private void methodProcessingChangeBody(MutableMethodDeclaration m, MutableClassDeclaration clazz, @Extension TransformationContext cxt, List<String> inheritList, String className) {
        MutableTypeDeclaration dt = m.getDeclaringType();
        Functions.Function1 _function = it -> it.getSimpleName();
        String parametersString = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)m.getParameters(), (Functions.Function1)_function), (CharSequence)",");
        Functions.Function1 _function_1 = it -> {
            String _simpleName = it.getAnnotationTypeDeclaration().getSimpleName();
            return Objects.equal((Object)_simpleName, (Object)STEP);
        };
        boolean isStep = IterableExtensions.exists((Iterable)m.getAnnotations(), (Functions.Function1)_function_1);
        String returnInstruction = this.getReturnInstruction(m, cxt);
        boolean hasReturn = returnInstruction.contains("return");
        StringBuilder callSB = new StringBuilder();
        String resultVar = RESULT_VAR;
        StringConcatenation _builder = new StringConcatenation();
        String _name = cxt.newTypeReference((Type)dt, new TypeReference[0]).getName();
        _builder.append(_name);
        _builder.append(".");
        String _simpleName = m.getSimpleName();
        String _plus = PRIV_PREFIX + _simpleName;
        _builder.append(_plus);
        _builder.append("(_self_, ");
        String _aspectedClassName = Helper.getAspectedClassName((TypeDeclaration)dt);
        String _plus_1 = "(" + _aspectedClassName;
        String _plus_2 = String.valueOf(_plus_1) + ")";
        String _plus_3 = String.valueOf(_plus_2) + SELF_VAR_NAME;
        String _replaceFirst = parametersString.replaceFirst(SELF_VAR_NAME, _plus_3);
        _builder.append(_replaceFirst);
        _builder.append(")");
        String privcall = _builder.toString();
        if (isStep) {
            int _indexOf = parametersString.indexOf(",");
            int _plus_4 = _indexOf + 1;
            privcall = this.surroundWithStepCommandExecution(className, m.getSimpleName(), privcall, hasReturn, RESULT_VAR, parametersString.substring(_plus_4));
        } else if (hasReturn) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(RESULT_VAR);
            _builder_1.append(" = ");
            _builder_1.append(privcall);
            privcall = _builder_1.toString();
        }
        Consumer<String> _function_2 = dpc -> {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append(dpc);
            _builder_2.newLineIfNotEmpty();
            callSB.append((CharSequence)_builder_2);
        };
        this.projectStaticDispatchBuilder.findExistingDispatchCalls(m, cxt).forEach(_function_2);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("// ");
        _builder_2.append(DISPATCH_POINTCUT_KEY);
        _builder_2.append(" ");
        String _initialMethodSignature = Helper.initialMethodSignature((MethodDeclaration)m);
        _builder_2.append(_initialMethodSignature);
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("if (");
        _builder_2.append(SELF_VAR_NAME);
        _builder_2.append(" instanceof ");
        String _aspectedClassName_1 = Helper.getAspectedClassName((TypeDeclaration)dt);
        _builder_2.append(_aspectedClassName_1);
        _builder_2.append("){");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        _builder_2.append(privcall, "\t");
        _builder_2.append(";");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("}");
        callSB.append((CharSequence)_builder_2);
        m.setAbstract(false);
        CompilationStrategy _function_3 = it -> this.getBody(clazz, className, callSB.toString(), returnInstruction);
        m.setBody(_function_3);
    }

    private boolean hasReturnType(MutableMethodDeclaration declaration, @Extension TransformationContext cxt) {
        TypeReference _newTypeReference;
        TypeReference _returnType = declaration.getReturnType();
        return !Objects.equal((Object)_returnType, (Object)(_newTypeReference = cxt.newTypeReference("void", new TypeReference[0])));
    }

    private String getReturnInstruction(MutableMethodDeclaration declaration, @Extension TransformationContext cxt) {
        String ret = "";
        boolean _hasReturnType = this.hasReturnType(declaration, cxt);
        if (_hasReturnType) {
            boolean _not;
            boolean _isInferred = declaration.getReturnType().isInferred();
            boolean bl = _not = !_isInferred;
            if (_not) {
                String _plus_1;
                String _name = declaration.getReturnType().getName();
                String _plus = "return (" + _name;
                ret = _plus_1 = String.valueOf(_plus) + ")result;";
            } else {
                cxt.addError((Element)declaration, "Cannot infer return type. Please specify the return type of this method.");
                ret = "return result;";
            }
        } else {
            ret = "";
        }
        return ret;
    }

    private String surroundWithStepCommandExecution(String className, String methodName, String code, boolean hasReturn, String resultVar, String parameters) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("fr.inria.diverse.k3.al.annotationprocessor.stepmanager.StepCommand command = new fr.inria.diverse.k3.al.annotationprocessor.stepmanager.StepCommand() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void execute() {");
        _builder.newLine();
        if (hasReturn) {
            _builder.append("\t\t");
            _builder.append("addToResult(");
            _builder.append(code, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t\t");
            _builder.append(code, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("fr.inria.diverse.k3.al.annotationprocessor.stepmanager.IStepManager stepManager = fr.inria.diverse.k3.al.annotationprocessor.stepmanager.StepManagerRegistry.getInstance().findStepManager(_self);");
        _builder.newLine();
        _builder.append("if (stepManager != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("stepManager.executeStep(_self, new Object[] {");
        _builder.append(parameters, "\t");
        _builder.append("}, command, \"");
        _builder.append(className, "\t");
        _builder.append("\", \"");
        _builder.append(methodName, "\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("command.execute();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        if (hasReturn) {
            _builder.append(resultVar);
            _builder.append(" = command.getResult();");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    private CharSequence getBody(MutableClassDeclaration clazz, String className, String call, String returnStatement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("final ");
        String _qualifiedName = clazz.getQualifiedName();
        String _plus = String.valueOf(_qualifiedName) + className;
        String _plus_1 = String.valueOf(_plus) + PROP_NAME;
        _builder.append(_plus_1);
        _builder.append(" ");
        _builder.append(PROP_VAR_NAME);
        _builder.append(" = ");
        String _qualifiedName_1 = clazz.getQualifiedName();
        String _plus_2 = String.valueOf(_qualifiedName_1) + className;
        String _plus_3 = String.valueOf(_plus_2) + CTX_NAME;
        _builder.append(_plus_3);
        _builder.append(".getSelf(");
        _builder.append(SELF_VAR_NAME);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        boolean _contains = returnStatement.contains("return");
        if (_contains) {
            _builder.append("Object result = null;");
            _builder.newLine();
        }
        String _string = call.toString();
        _builder.append(_string);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append(returnStatement);
        return _builder;
    }

    private void methodProcessingAddMultiInheritMeth(MutableClassDeclaration clazz, String identifier, @Extension TransformationContext cxt) {
        Functions.Function1 _function = cl -> {
            TypeReference _extendedClass = clazz.getExtendedClass();
            return !Objects.equal((Object)cl, (Object)_extendedClass);
        };
        Functions.Function1 _function_1 = cl -> cxt.findClass(cl.getName());
        Iterable superClasses = IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(Helper.getAnnotationWithType((TypeDeclaration)clazz), (Functions.Function1)_function), (Functions.Function1)_function_1));
        HashSet scs = CollectionLiterals.newHashSet((Object[])new MutableClassDeclaration[0]);
        Consumer<MutableClassDeclaration> _function_2 = sc -> Helper.getSuperClasses(sc, scs, (TypeLookup)cxt);
        superClasses.forEach(_function_2);
        Consumer<MutableClassDeclaration> _function_3 = sc -> {
            Functions.Function1 _function_4 = dm -> !Objects.equal((Object)dm.getVisibility(), (Object)Visibility.PRIVATE) && !dm.getSimpleName().startsWith(PRIV_PREFIX) && !IterableExtensions.exists((Iterable)clazz.getDeclaredMethods(), dm2 -> Helper.isSamePrototype(dm, dm2, true));
            Consumer<MutableMethodDeclaration> _function_5 = dm -> {
                Procedures.Procedure1 _function_6 = it -> {
                    cxt.setPrimarySourceElement((MutableElement)it, (Element)dm);
                    it.setVisibility(dm.getVisibility());
                    it.setStatic(true);
                    it.setFinal(false);
                    it.setAbstract(false);
                    it.setReturnType(dm.getReturnType());
                    it.addParameter(SELF_VAR_NAME, cxt.newTypeReference(identifier, new TypeReference[0]));
                    Consumer<MutableParameterDeclaration> _function_7 = par -> it.addParameter(par.getSimpleName(), par.getType());
                    IterableExtensions.drop((Iterable)dm.getParameters(), (int)1).forEach(_function_7);
                };
                MutableMethodDeclaration me = clazz.addMethod(dm.getSimpleName(), _function_6);
                this.methodProcessingAddSelfStatic(me, identifier, cxt);
                Functions.Function1 _function_7 = it -> it.getSimpleName();
                String params = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)me.getParameters(), (Functions.Function1)_function_7), (CharSequence)",");
                CompilationStrategy _function_8 = it -> {
                    StringConcatenation _builder = new StringConcatenation();
                    if (me.getReturnType() != null && !Objects.equal((Object)me.getReturnType().getSimpleName(), (Object)"void")) {
                        _builder.append("return ");
                    }
                    String _simpleName = sc.getSimpleName();
                    _builder.append(_simpleName);
                    _builder.append(".");
                    String _simpleName_1 = dm.getSimpleName();
                    _builder.append(_simpleName_1);
                    _builder.append("(");
                    _builder.append(params);
                    _builder.append(");");
                    return _builder;
                };
                me.setBody(_function_8);
            };
            IterableExtensions.filter((Iterable)sc.getDeclaredMethods(), (Functions.Function1)_function_4).forEach(_function_5);
            Functions.Function1 _function_6 = it -> {
                String _simpleName = it.getSimpleName();
                return !Objects.equal((Object)_simpleName, (Object)PROP_VAR_NAME);
            };
            Consumer<MutableFieldDeclaration> _function_7 = fi -> {
                boolean _not;
                String clName = fi.getDeclaringType().getSimpleName();
                Procedures.Procedure1 _function_8 = it -> {
                    cxt.setPrimarySourceElement((MutableElement)it, (Element)fi);
                    it.setStatic(true);
                    it.setReturnType(fi.getType());
                    it.addParameter(SELF_VAR_NAME, cxt.newTypeReference(identifier, new TypeReference[0]));
                    CompilationStrategy _function_9 = it_1 -> {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("return ");
                        _builder.append(clName);
                        _builder.append(".");
                        String _simpleName = fi.getSimpleName();
                        _builder.append(_simpleName);
                        _builder.append("(");
                        _builder.append(SELF_VAR_NAME);
                        _builder.append(");");
                        return _builder;
                    };
                    it.setBody(_function_9);
                };
                clazz.addMethod(fi.getSimpleName(), _function_8);
                boolean _isFinal = fi.isFinal();
                boolean bl = _not = !_isFinal;
                if (_not) {
                    Procedures.Procedure1 _function_9 = it -> {
                        cxt.setPrimarySourceElement((MutableElement)it, (Element)fi);
                        it.setStatic(true);
                        it.setReturnType(cxt.newTypeReference("void", new TypeReference[0]));
                        it.addParameter(SELF_VAR_NAME, cxt.newTypeReference(identifier, new TypeReference[0]));
                        it.addParameter(fi.getSimpleName(), fi.getType());
                        CompilationStrategy _function_10 = it_1 -> {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append(clName);
                            _builder.append(".");
                            String _simpleName = fi.getSimpleName();
                            _builder.append(_simpleName);
                            _builder.append("(");
                            _builder.append(SELF_VAR_NAME);
                            _builder.append(", ");
                            String _simpleName_1 = fi.getSimpleName();
                            _builder.append(_simpleName_1);
                            _builder.append(");");
                            return _builder;
                        };
                        it.setBody(_function_10);
                    };
                    clazz.addMethod(fi.getSimpleName(), _function_9);
                }
            };
            IterableExtensions.filter((Iterable)sc.getDeclaredFields(), (Functions.Function1)_function_6).forEach(_function_7);
        };
        scs.forEach(_function_3);
    }

    private void methodsProcessing(MutableClassDeclaration clazz, TransformationContext cxt, String identifier, Map<MutableMethodDeclaration, String> bodies, List<String> inheritList, String aspectizedClassName) {
        Iterable _declaredMethods = clazz.getDeclaredMethods();
        for (MutableMethodDeclaration m : _declaredMethods) {
            boolean _checkAnnotationprocessorCorrect = this.checkAnnotationprocessorCorrect(m, clazz, cxt);
            if (_checkAnnotationprocessorCorrect) {
                Functions.Function1 _function = an -> {
                    String _qualifiedName = an.getAnnotationTypeDeclaration().getQualifiedName();
                    return Objects.equal((Object)_qualifiedName, (Object)"java.lang.Override");
                };
                m.removeAnnotation((AnnotationReference)IterableExtensions.findFirst((Iterable)m.getAnnotations(), (Functions.Function1)_function));
                this.methodProcessingAddSelfStatic(m, identifier, cxt);
                this.methodProcessingAddSuper(m, clazz, aspectizedClassName, cxt);
                this.methodProcessingAddHidden(m, identifier, cxt);
                this.methodProcessingAddPriv(m, clazz, aspectizedClassName, bodies, cxt);
                this.methodProcessingChangeBody(m, clazz, cxt, inheritList, aspectizedClassName);
                continue;
            }
            cxt.addError((Element)m, "Cannot find a super method in the aspect hierarchy.");
        }
        this.methodProcessingAddMultiInheritMeth(clazz, identifier, cxt);
    }

    private boolean checkAnnotationprocessorCorrect(MutableMethodDeclaration m, MutableClassDeclaration clazz, TransformationContext cxt) {
        boolean _not;
        Functions.Function1 _function = it -> {
            String _simpleName = it.getAnnotationTypeDeclaration().getSimpleName();
            return Objects.equal((Object)_simpleName, (Object)OVERRIDE_METHOD);
        };
        boolean _exists = IterableExtensions.exists((Iterable)m.getAnnotations(), (Functions.Function1)_function);
        boolean bl = _not = !_exists;
        if (_not) {
            return true;
        }
        List<ClassDeclaration> supers = Helper.getDirectPrimaryAndSecondarySuperClasses((ClassDeclaration)clazz, (GlobalTypeLookup)cxt);
        boolean _isEmpty = supers.isEmpty();
        if (_isEmpty) {
            cxt.addError((Element)clazz, "passe par la");
            return false;
        }
        Functions.Function1 _function_1 = superCl -> {
            MethodDeclaration _findMethod = Helper.findMethod(superCl, m, cxt);
            return _findMethod != null;
        };
        return IterableExtensions.exists(supers, (Functions.Function1)_function_1);
    }

    private void constructorsProcessing(MutableClassDeclaration clazz, TransformationContext cxt, String identifier, Map<MutableMethodDeclaration, String> bodies, String className) {
        Iterable _declaredConstructors = clazz.getDeclaredConstructors();
        for (MutableConstructorDeclaration c : _declaredConstructors) {
            boolean _tripleNotEquals;
            Expression _body = c.getBody();
            boolean bl = _tripleNotEquals = _body != null;
            if (!_tripleNotEquals) continue;
            cxt.addError((Element)c, "Constructors not supported in aspect. Please consider using the @AspectInitializer annotation instead.");
        }
    }

    private void aspectContextMaker(@Extension TransformationContext context, MutableClassDeclaration clazz, String className, String identifier) {
        String _qualifiedName = clazz.getQualifiedName();
        String _plus = String.valueOf(_qualifiedName) + className;
        String _plus_1 = String.valueOf(_plus) + CTX_NAME;
        MutableClassDeclaration holderClass = context.findClass(_plus_1);
        if (holderClass == null) {
            return;
        }
        context.setPrimarySourceElement((MutableElement)holderClass, (Element)clazz);
        holderClass.setVisibility(Visibility.PUBLIC);
        Procedures.Procedure1 _function = it -> {
            it.setVisibility(Visibility.PRIVATE);
            context.setPrimarySourceElement((MutableElement)it, (Element)clazz);
        };
        holderClass.addConstructor(_function);
        Procedures.Procedure1 _function_1 = it -> {
            it.setVisibility(Visibility.PUBLIC);
            it.setStatic(true);
            it.setFinal(true);
            it.setType(context.newTypeReference((Type)holderClass, new TypeReference[0]));
            CompilationStrategy _function_2 = it_1 -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("new ");
                String _simpleName = holderClass.getSimpleName();
                _builder.append(_simpleName);
                _builder.append("()");
                return _builder;
            };
            it.setInitializer(_function_2);
            context.setPrimarySourceElement((MutableElement)it, (Element)clazz);
        };
        holderClass.addField("INSTANCE", _function_1);
        Procedures.Procedure1 _function_2 = it -> {
            it.setVisibility(Visibility.PUBLIC);
            it.setStatic(true);
            it.addParameter(SELF_VAR_NAME, context.newTypeReference(identifier, new TypeReference[0]));
            String _qualifiedName_1 = clazz.getQualifiedName();
            String _plus_2 = String.valueOf(_qualifiedName_1) + className;
            String _plus_3 = String.valueOf(_plus_2) + PROP_NAME;
            it.setReturnType(context.newTypeReference((Type)context.findClass(_plus_3), new TypeReference[0]));
            CompilationStrategy _function_3 = it_1 -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("\t\t");
                _builder.append("if (!INSTANCE.map.containsKey(_self))");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("INSTANCE.map.put(_self, new ");
                String _qualifiedName_2 = clazz.getQualifiedName();
                String _plus_4 = String.valueOf(_qualifiedName_2) + className;
                String _plus_5 = String.valueOf(_plus_4) + PROP_NAME;
                _builder.append(_plus_5, "\t\t\t");
                _builder.append("());");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("return INSTANCE.map.get(_self);");
                return _builder;
            };
            it.setBody(_function_3);
            context.setPrimarySourceElement((MutableElement)it, (Element)clazz);
        };
        holderClass.addMethod("getSelf", _function_2);
        Procedures.Procedure1 _function_3 = it -> {
            it.setVisibility(Visibility.PRIVATE);
            it.setStatic(false);
            String _qualifiedName_1 = clazz.getQualifiedName();
            String _plus_2 = String.valueOf(_qualifiedName_1) + className;
            String _plus_3 = String.valueOf(_plus_2) + PROP_NAME;
            it.setType(context.newTypeReference("java.util.Map", new TypeReference[]{context.newTypeReference(identifier, new TypeReference[0]), context.newTypeReference((Type)context.findClass(_plus_3), new TypeReference[0])}));
            CompilationStrategy _function_4 = it_1 -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("new java.util.WeakHashMap<");
                String _mkstring = Helper.mkstring(context.newTypeReference(identifier, new TypeReference[0]).getActualTypeArguments(), ",", "<", ">");
                String _plus_4 = String.valueOf(identifier) + _mkstring;
                _builder.append(_plus_4);
                _builder.append(", ");
                String _qualifiedName_2 = clazz.getQualifiedName();
                String _plus_5 = String.valueOf(_qualifiedName_2) + className;
                String _plus_6 = String.valueOf(_plus_5) + PROP_NAME;
                _builder.append(_plus_6);
                _builder.append(">()");
                return _builder;
            };
            it.setInitializer(_function_4);
            context.setPrimarySourceElement((MutableElement)it, (Element)clazz);
        };
        holderClass.addField("map", _function_3);
        Procedures.Procedure1 _function_4 = it -> {
            it.setVisibility(Visibility.PUBLIC);
            it.setStatic(false);
            String _qualifiedName_1 = clazz.getQualifiedName();
            String _plus_2 = String.valueOf(_qualifiedName_1) + className;
            String _plus_3 = String.valueOf(_plus_2) + PROP_NAME;
            it.setReturnType(context.newTypeReference("java.util.Map", new TypeReference[]{context.newTypeReference(identifier, new TypeReference[0]), context.newTypeReference((Type)context.findClass(_plus_3), new TypeReference[0])}));
            CompilationStrategy _function_5 = it_1 -> {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("return map;");
                return _builder;
            };
            it.setBody(_function_5);
            context.setPrimarySourceElement((MutableElement)it, (Element)clazz);
        };
        holderClass.addMethod("getMap", _function_4);
    }

    private void fieldProcessingMoveField(MutableClassDeclaration clazz, List<MutableFieldDeclaration> toRemove, List<MutableFieldDeclaration> propertyAspect, String className, @Extension TransformationContext context) {
        String _qualifiedName = clazz.getQualifiedName();
        String _plus = String.valueOf(_qualifiedName) + className;
        String _plus_1 = String.valueOf(_plus) + PROP_NAME;
        MutableClassDeclaration c = context.findClass(_plus_1);
        if (c == null) {
            context.addError((Element)clazz, "Cannot resolve the class to aspectise. Check that the classes to aspectise are not in the same project that your aspects.");
        } else {
            Iterable _declaredFields = clazz.getDeclaredFields();
            for (MutableFieldDeclaration f : _declaredFields) {
                boolean _notEquals;
                boolean _not;
                boolean _isStatic = f.isStatic();
                boolean bl = _not = !_isStatic;
                if (!_not) continue;
                String _simpleName = f.getSimpleName();
                boolean bl2 = _notEquals = !Objects.equal((Object)_simpleName, (Object)PROP_VAR_NAME);
                if (_notEquals) {
                    boolean _not_1;
                    toRemove.add(f);
                    Functions.Function1 _function = it -> {
                        String _simpleName_1 = it.getAnnotationTypeDeclaration().getSimpleName();
                        return Objects.equal((Object)_simpleName_1, (Object)"NotAspectProperty");
                    };
                    boolean _exists = IterableExtensions.exists((Iterable)f.getAnnotations(), (Functions.Function1)_function);
                    boolean bl3 = _not_1 = !_exists;
                    if (_not_1) {
                        propertyAspect.add(f);
                    }
                    Procedures.Procedure1 _function_1 = it -> {
                        boolean _tripleNotEquals;
                        it.setVisibility(Visibility.PUBLIC);
                        it.setStatic(f.isStatic());
                        it.setFinal(f.isFinal());
                        it.setType(f.getType());
                        Expression _initializer = f.getInitializer();
                        boolean bl = _tripleNotEquals = _initializer != null;
                        if (_tripleNotEquals) {
                            it.setInitializer(f.getInitializer());
                        }
                        context.setPrimarySourceElement((MutableElement)it, (Element)f);
                    };
                    c.addField(f.getSimpleName(), _function_1);
                    continue;
                }
                String _qualifiedName_1 = clazz.getQualifiedName();
                String _plus_2 = String.valueOf(_qualifiedName_1) + className;
                String _plus_3 = String.valueOf(_plus_2) + PROP_NAME;
                f.setType(context.newTypeReference((Type)context.findClass(_plus_3), new TypeReference[0]));
                f.setStatic(true);
            }
        }
    }

    private void fieldProcessingAddGetterSetter(MutableClassDeclaration clazz, List<MutableFieldDeclaration> propertyAspect, String identifier, Map<MutableMethodDeclaration, String> bodies, @Extension TransformationContext context) {
        for (MutableFieldDeclaration f : propertyAspect) {
            boolean _not_1;
            boolean _not;
            Procedures.Procedure1 _function = it -> {
                it.setReturnType(f.getType());
                it.addParameter(SELF_VAR_NAME, context.newTypeReference(identifier, new TypeReference[0]));
                context.setPrimarySourceElement((MutableElement)it, (Element)f);
                it.setVisibility(f.getVisibility());
                Consumer<AnnotationReference> _function_1 = ann -> it.addAnnotation(ann);
                f.getAnnotations().forEach(_function_1);
            };
            MutableMethodDeclaration get = clazz.addMethod(f.getSimpleName(), _function);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("try {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("for (java.lang.reflect.Method m : _self.getClass().getMethods()) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("if (m.getName().equals(\"");
            if (Objects.equal((Object)f.getType().getSimpleName(), (Object)"boolean") || Objects.equal((Object)f.getType().getSimpleName(), (Object)"Boolean")) {
                _builder.append("is");
            } else {
                _builder.append("get");
            }
            String _upperCase = f.getSimpleName().substring(0, 1).toUpperCase();
            String _substring = f.getSimpleName().substring(1);
            String _plus = String.valueOf(_upperCase) + _substring;
            _builder.append(_plus, "\t\t");
            _builder.append("\") &&");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("m.getParameterTypes().length == 0) {");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("Object ret = m.invoke(_self);");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("if (ret != null) {");
            _builder.newLine();
            _builder.append("\t\t\t\t\t");
            _builder.append("return (");
            String _qualifiedName = f.getType().getType().getQualifiedName();
            _builder.append(_qualifiedName, "\t\t\t\t\t");
            _builder.append(") ret;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t");
            _builder.append("}");
            boolean _isPrimitive = f.getType().isPrimitive();
            boolean bl = _not = !_isPrimitive;
            if (_not) {
                _builder.append(" else {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t\t");
                _builder.append("\t");
                _builder.append("return null;");
                _builder.newLine();
                _builder.append("\t\t\t\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("} catch (Exception e) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// Chut !");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.append("return ");
            _builder.append(PROP_VAR_NAME);
            _builder.append(".");
            String _simpleName = f.getSimpleName();
            _builder.append(_simpleName);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            String gemocHackGetter = _builder.toString();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(gemocHackGetter);
            bodies.put(get, _builder_1.toString());
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("try {");
            _builder_2.newLine();
            _builder_2.append("\t");
            _builder_2.append("for (java.lang.reflect.Method m : _self.getClass().getMethods()) {");
            _builder_2.newLine();
            _builder_2.append("\t\t");
            _builder_2.append("if (m.getName().equals(\"set");
            String _upperCase_1 = f.getSimpleName().substring(0, 1).toUpperCase();
            String _substring_1 = f.getSimpleName().substring(1);
            String _plus_1 = String.valueOf(_upperCase_1) + _substring_1;
            _builder_2.append(_plus_1, "\t\t");
            _builder_2.append("\")");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t\t\t\t");
            _builder_2.append("&& m.getParameterTypes().length == 1) {");
            _builder_2.newLine();
            _builder_2.append("\t\t\t");
            _builder_2.append("m.invoke(_self, ");
            String _simpleName_1 = f.getSimpleName();
            _builder_2.append(_simpleName_1, "\t\t\t");
            _builder_2.append(");");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t\t\t");
            _builder_2.append("setterCalled = true;");
            _builder_2.newLine();
            _builder_2.append("\t\t");
            _builder_2.append("}");
            _builder_2.newLine();
            _builder_2.append("\t");
            _builder_2.append("}");
            _builder_2.newLine();
            _builder_2.append("} catch (Exception e) {");
            _builder_2.newLine();
            _builder_2.append("\t");
            _builder_2.append("// Chut !");
            _builder_2.newLine();
            _builder_2.append("}");
            _builder_2.newLine();
            String gemocHackSetter = _builder_2.toString();
            boolean _isFinal = f.isFinal();
            boolean bl2 = _not_1 = !_isFinal;
            if (!_not_1) continue;
            Procedures.Procedure1 _function_1 = it -> {
                it.setReturnType(context.newTypeReference("void", new TypeReference[0]));
                it.addParameter(SELF_VAR_NAME, context.newTypeReference(identifier, new TypeReference[0]));
                it.addParameter(f.getSimpleName(), f.getType());
                it.setVisibility(f.getVisibility());
                context.setPrimarySourceElement((MutableElement)it, (Element)f);
                Consumer<AnnotationReference> _function_2 = ann -> it.addAnnotation(ann);
                f.getAnnotations().forEach(_function_2);
            };
            MutableMethodDeclaration set = clazz.addMethod(f.getSimpleName(), _function_1);
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("boolean setterCalled = false;");
            _builder_3.newLine();
            _builder_3.append(gemocHackSetter);
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("if (!setterCalled) {");
            _builder_3.newLine();
            _builder_3.append("\t");
            _builder_3.append(PROP_VAR_NAME, "\t");
            _builder_3.append(".");
            String _simpleName_2 = f.getSimpleName();
            _builder_3.append(_simpleName_2, "\t");
            _builder_3.append(" = ");
            String _simpleName_3 = f.getSimpleName();
            _builder_3.append(_simpleName_3, "\t");
            _builder_3.append(";");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("}");
            _builder_3.newLine();
            bodies.put(set, _builder_3.toString());
        }
    }

    private void fieldsProcessing(@Extension TransformationContext context, MutableClassDeclaration clazz, String className, String identifier, Map<MutableMethodDeclaration, String> bodies) {
        ArrayList toRemove = CollectionLiterals.newArrayList((Object[])new MutableFieldDeclaration[0]);
        ArrayList propertyAspect = CollectionLiterals.newArrayList((Object[])new MutableFieldDeclaration[0]);
        this.fieldProcessingMoveField(clazz, toRemove, propertyAspect, className, context);
        this.fieldProcessingAddGetterSetter(clazz, propertyAspect, identifier, bodies, context);
        for (MutableFieldDeclaration f : toRemove) {
            f.remove();
        }
    }

    private void generateAspectJCodeForClass(ClassDeclaration classDecl, @Extension CodeGenerationContext context) {
        TypeReference typeRef = Helper.getAnnotationAspectType((TypeDeclaration)classDecl);
        StringBuilder stAspectJ = new StringBuilder();
        boolean doGenerate = false;
        CharSequence _subSequence = typeRef.getName().subSequence(0, typeRef.getName().lastIndexOf("."));
        String _plus = "package " + _subSequence;
        String _plus_1 = String.valueOf(_plus) + ";\n";
        stAspectJ.append(_plus_1);
        String _simpleName = typeRef.getSimpleName();
        String _plus_2 = "public aspect AspectJ" + _simpleName;
        String _plus_3 = String.valueOf(_plus_2) + "{\n";
        stAspectJ.append(_plus_3);
        Iterable _declaredMethods = classDecl.getDeclaredMethods();
        for (MethodDeclaration m : _declaredMethods) {
            boolean _not;
            Functions.Function1 _function = it -> {
                String _simpleName_1 = it.getAnnotationTypeDeclaration().getSimpleName();
                return Objects.equal((Object)_simpleName_1, (Object)"ReplaceAspectMethod");
            };
            boolean _exists = IterableExtensions.exists((Iterable)m.getAnnotations(), (Functions.Function1)_function);
            if (!_exists) continue;
            doGenerate = true;
            String _simpleName_1 = m.getReturnType().getSimpleName();
            String _plus_4 = String.valueOf(_simpleName_1) + " around (";
            String _name = typeRef.getName();
            String _plus_5 = String.valueOf(_plus_4) + _name;
            String _plus_6 = String.valueOf(_plus_5) + " self)  :target (self) && (call ( ";
            String _name_1 = m.getReturnType().getName();
            String _plus_7 = String.valueOf(_plus_6) + _name_1;
            String _plus_8 = String.valueOf(_plus_7) + " ";
            String _name_2 = typeRef.getName();
            String _plus_9 = String.valueOf(_plus_8) + _name_2;
            String _plus_10 = String.valueOf(_plus_9) + ".";
            String _simpleName_2 = m.getSimpleName();
            String _plus_11 = String.valueOf(_plus_10) + _simpleName_2;
            String _plus_12 = String.valueOf(_plus_11) + "( ";
            stAspectJ.append(_plus_12);
            Consumer<ParameterDeclaration> _function_1 = p -> {
                boolean _not;
                stAspectJ.append(p.getType().getName());
                boolean _equals = ((ParameterDeclaration)IterableExtensions.last((Iterable)m.getParameters())).equals(p);
                boolean bl = _not = !_equals;
                if (_not) {
                    stAspectJ.append(",");
                }
            };
            m.getParameters().forEach(_function_1);
            stAspectJ.append(" ) ) ) { ");
            boolean _equals = "void".equals(m.getReturnType().getName());
            boolean bl = _not = !_equals;
            if (_not) {
                stAspectJ.append("return ");
            }
            String _qualifiedName = classDecl.getQualifiedName();
            String _plus_13 = String.valueOf(_qualifiedName) + ".";
            String _simpleName_3 = m.getSimpleName();
            String _plus_14 = String.valueOf(_plus_13) + _simpleName_3;
            String _plus_15 = String.valueOf(_plus_14) + "(self";
            stAspectJ.append(_plus_15);
            int i = 0;
            while (i < IterableExtensions.size((Iterable)m.getParameters())) {
                String _name_3 = ((ParameterDeclaration[])Conversions.unwrapArray((Object)m.getParameters(), ParameterDeclaration.class))[i].getType().getName();
                String _plus_16 = ",(" + _name_3;
                String _plus_17 = String.valueOf(_plus_16) + ")thisJoinPoint.getArgs()[";
                String _plus_18 = String.valueOf(_plus_17) + Integer.valueOf(i);
                String _plus_19 = String.valueOf(_plus_18) + "]";
                stAspectJ.append(_plus_19);
                ++i;
            }
            stAspectJ.append(" );}\n");
        }
        Iterable _declaredFields = classDecl.getDeclaredFields();
        for (FieldDeclaration a : _declaredFields) {
            Functions.Function1 _function_2 = it -> {
                String _simpleName_4 = it.getAnnotationTypeDeclaration().getSimpleName();
                return Objects.equal((Object)_simpleName_4, (Object)"SynchroField");
            };
            boolean _exists_1 = IterableExtensions.exists((Iterable)a.getAnnotations(), (Functions.Function1)_function_2);
            if (!_exists_1) continue;
            doGenerate = true;
            String _name_3 = typeRef.getName();
            String _plus_16 = "void around (" + _name_3;
            String _plus_17 = String.valueOf(_plus_16) + " self)  :target (self) &&  call ( void ";
            String _simpleName_4 = typeRef.getSimpleName();
            String _plus_18 = String.valueOf(_plus_17) + _simpleName_4;
            String _plus_19 = String.valueOf(_plus_18) + ".";
            stAspectJ.append(_plus_19);
            String _firstUpper = StringExtensions.toFirstUpper((String)a.getSimpleName());
            String _plus_20 = "set" + _firstUpper;
            String _plus_21 = String.valueOf(_plus_20) + "(";
            String _name_4 = a.getType().getName();
            String _plus_22 = String.valueOf(_plus_21) + _name_4;
            String _plus_23 = String.valueOf(_plus_22) + ")){";
            stAspectJ.append(_plus_23);
            String _qualifiedName_1 = classDecl.getQualifiedName();
            String _plus_24 = String.valueOf(_qualifiedName_1) + ".";
            String _simpleName_5 = a.getSimpleName();
            String _plus_25 = String.valueOf(_plus_24) + _simpleName_5;
            String _plus_26 = String.valueOf(_plus_25) + "(self, (";
            String _name_5 = a.getType().getName();
            String _plus_27 = String.valueOf(_plus_26) + _name_5;
            String _plus_28 = String.valueOf(_plus_27) + ")thisJoinPoint.getArgs()[0]);";
            stAspectJ.append(_plus_28);
            stAspectJ.append("proceed(self);\n}\n");
            String _name_6 = typeRef.getName();
            String _plus_29 = "void around (" + _name_6;
            String _plus_30 = String.valueOf(_plus_29) + " self)  :target (self) &&  call ( void ";
            String _qualifiedName_2 = classDecl.getQualifiedName();
            String _plus_31 = String.valueOf(_plus_30) + _qualifiedName_2;
            String _plus_32 = String.valueOf(_plus_31) + ".";
            stAspectJ.append(_plus_32);
            String _simpleName_6 = a.getSimpleName();
            String _plus_33 = String.valueOf(_simpleName_6) + "(";
            String _name_7 = typeRef.getName();
            String _plus_34 = String.valueOf(_plus_33) + _name_7;
            String _plus_35 = String.valueOf(_plus_34) + ",";
            String _name_8 = a.getType().getName();
            String _plus_36 = String.valueOf(_plus_35) + _name_8;
            String _plus_37 = String.valueOf(_plus_36) + ")){";
            stAspectJ.append(_plus_37);
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)a.getSimpleName());
            String _plus_38 = "self.set" + _firstUpper_1;
            String _plus_39 = String.valueOf(_plus_38) + "( (";
            String _name_9 = a.getType().getName();
            String _plus_40 = String.valueOf(_plus_39) + _name_9;
            String _plus_41 = String.valueOf(_plus_40) + ")thisJoinPoint.getArgs()[0]);";
            stAspectJ.append(_plus_41);
            stAspectJ.append("proceed(self);\n}\n");
        }
        stAspectJ.append("\n}\n");
        Path filePath = classDecl.getCompilationUnit().getFilePath();
        Path _targetFolder = context.getTargetFolder(filePath);
        String _replace = typeRef.getName().subSequence(0, typeRef.getName().lastIndexOf(".")).toString().replace(".", "/");
        String _plus_42 = String.valueOf(_replace) + "/AspectJ";
        String _simpleName_7 = typeRef.getSimpleName();
        String _plus_43 = String.valueOf(_plus_42) + _simpleName_7;
        String _plus_44 = String.valueOf(_plus_43) + ".aj";
        Path targetFilePath = _targetFolder.append(_plus_44);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// AspectJ classes that have been aspectized and name");
        _builder.newLine();
        String _string = stAspectJ.toString();
        _builder.append(_string);
        String contents = _builder.toString();
        if (doGenerate) {
            Helper.writeContentsIfNew(targetFilePath, contents, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectDispatchInParentAspects(ClassDeclaration classDecl, @Extension CodeGenerationContext context) {
        try {
            ArrayList allSuperClasses = CollectionLiterals.newArrayList((Object[])new ClassDeclaration[0]);
            Helper.getAllPrimaryAndSecondarySuperClasses(allSuperClasses, classDecl, (GlobalTypeLookup)context);
            Iterable _declaredMethods = classDecl.getDeclaredMethods();
            for (MethodDeclaration m : _declaredMethods) {
                String methodSignature = Helper.initialMethodSignature(m);
                for (ClassDeclaration superclass : allSuperClasses) {
                    boolean _not;
                    boolean isSuperClassInProject;
                    if (!IterableExtensions.exists((Iterable)superclass.getAnnotations(), it -> {
                        String _simpleName = it.getAnnotationTypeDeclaration().getSimpleName();
                        String _simpleName_1 = Aspect.class.getSimpleName();
                        return Objects.equal((Object)_simpleName, (Object)_simpleName_1);
                    }) || !IterableExtensions.exists((Iterable)superclass.getDeclaredMethods(), supermethod -> {
                        String _initialMethodSignature = Helper.initialMethodSignature(supermethod);
                        return Objects.equal((Object)methodSignature, (Object)_initialMethodSignature);
                    }) || !(isSuperClassInProject = this.aspectMappingBuilder.getAllDeclaredAspects().contains(superclass.getQualifiedName()))) continue;
                    Path superclassfilePath = superclass.getCompilationUnit().getFilePath();
                    Path _xifexpression = null;
                    _xifexpression = ((Object[])Conversions.unwrapArray((Object)context.getSourceFolder(superclassfilePath).relativize(context.getProjectFolder(superclassfilePath)).getSegments(), Object.class)).length > 1 && ((Object[])Conversions.unwrapArray((Object)context.getTargetFolder(superclassfilePath).relativize(context.getProjectFolder(superclassfilePath)).getSegments(), Object.class)).length == 1 ? context.getSourceFolder(superclassfilePath).getParent().append(context.getTargetFolder(superclassfilePath).relativize(context.getProjectFolder(superclassfilePath)).toString()) : context.getTargetFolder(superclassfilePath);
                    Path superclasstargetFolder = _xifexpression;
                    String _replace = superclass.getQualifiedName().replace(".", "/");
                    String _plus = String.valueOf(_replace) + ".java";
                    Path superclassjavafile = superclasstargetFolder.append(_plus);
                    boolean _waitForFileContent = this.waitForFileContent(superclassjavafile, context);
                    boolean bl = _not = !_waitForFileContent;
                    if (_not) {
                        String _plus_1 = (Object)((Object)this) + " timeout occurred while waiting for ";
                        String _plus_2 = String.valueOf(_plus_1) + superclassjavafile;
                        InputOutput.println((Object)_plus_2);
                        continue;
                    }
                    Boolean bl2 = lock;
                    synchronized (bl2) {
                        boolean _not_1;
                        String _name = m.getReturnType().getName();
                        boolean hasReturn = !Objects.equal((Object)_name, (Object)"void");
                        String _xifexpression_1 = null;
                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)m.getParameters());
                        if (_isEmpty) {
                            StringConcatenation _builder = new StringConcatenation();
                            String _aspectedClassName = Helper.getAspectedClassName((TypeDeclaration)classDecl);
                            String _plus_3 = "(" + _aspectedClassName;
                            String _plus_4 = String.valueOf(_plus_3) + ")";
                            String _plus_5 = String.valueOf(_plus_4) + SELF_VAR_NAME;
                            _builder.append(_plus_5);
                            _xifexpression_1 = _builder.toString();
                        } else {
                            StringConcatenation _builder_1 = new StringConcatenation();
                            _builder_1.append("(");
                            String _aspectedClassName_1 = Helper.getAspectedClassName((TypeDeclaration)classDecl);
                            _builder_1.append(_aspectedClassName_1);
                            _builder_1.append(")");
                            _builder_1.append(SELF_VAR_NAME);
                            _builder_1.append(",");
                            Functions.Function1 _function = it -> it.getSimpleName();
                            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)m.getParameters(), (Functions.Function1)_function), (CharSequence)",");
                            _builder_1.append(_join);
                            _xifexpression_1 = _builder_1.toString();
                        }
                        String parametersString = _xifexpression_1;
                        StringConcatenation _builder_2 = new StringConcatenation();
                        String _qualifiedName = classDecl.getQualifiedName();
                        _builder_2.append(_qualifiedName);
                        _builder_2.append(".");
                        String _simpleName = m.getSimpleName();
                        _builder_2.append(_simpleName);
                        _builder_2.append("(");
                        _builder_2.append(parametersString);
                        _builder_2.append(");");
                        String call = _builder_2.toString();
                        if (hasReturn) {
                            StringConcatenation _builder_3 = new StringConcatenation();
                            _builder_3.append(RESULT_VAR);
                            _builder_3.append(" = ");
                            _builder_3.append(call);
                            call = _builder_3.toString();
                        }
                        StringConcatenation _builder_4 = new StringConcatenation();
                        _builder_4.append("// BeginInjectInto ");
                        String _qualifiedName_1 = superclass.getQualifiedName();
                        _builder_4.append(_qualifiedName_1);
                        _builder_4.append("#");
                        String _methodSignature = Helper.methodSignature(m);
                        _builder_4.append(_methodSignature);
                        _builder_4.append(" from ");
                        String _qualifiedName_2 = classDecl.getQualifiedName();
                        _builder_4.append(_qualifiedName_2);
                        String dispatchInjectKey = _builder_4.toString();
                        StringConcatenation _builder_5 = new StringConcatenation();
                        _builder_5.append("\t");
                        _builder_5.append(dispatchInjectKey, "\t");
                        _builder_5.newLineIfNotEmpty();
                        _builder_5.append("\t\t");
                        _builder_5.append("if (");
                        _builder_5.append(SELF_VAR_NAME, "\t\t");
                        _builder_5.append(" instanceof ");
                        String _aspectedClassName_2 = Helper.getAspectedClassName((TypeDeclaration)classDecl);
                        _builder_5.append(_aspectedClassName_2, "\t\t");
                        _builder_5.append("){");
                        _builder_5.newLineIfNotEmpty();
                        _builder_5.append("\t\t\t");
                        _builder_5.append(call, "\t\t\t");
                        _builder_5.newLineIfNotEmpty();
                        _builder_5.append("\t\t");
                        _builder_5.append("} else");
                        _builder_5.newLine();
                        _builder_5.append("\t\t");
                        _builder_5.append("// EndInjectInto ");
                        String _qualifiedName_3 = superclass.getQualifiedName();
                        _builder_5.append(_qualifiedName_3, "\t\t");
                        _builder_5.append("#");
                        String _methodSignature_1 = Helper.methodSignature(m);
                        _builder_5.append(_methodSignature_1, "\t\t");
                        _builder_5.append(" from ");
                        String _qualifiedName_4 = classDecl.getQualifiedName();
                        _builder_5.append(_qualifiedName_4, "\t\t");
                        String dispatchInjectCodeForParent = _builder_5.toString();
                        this.projectStaticDispatchBuilder.add(dispatchInjectCodeForParent);
                        String aspectJavaFileContent = this.readFileContents(superclassjavafile, context);
                        boolean _contains = aspectJavaFileContent.contains(dispatchInjectKey);
                        boolean bl3 = _not_1 = !_contains;
                        if (_not_1) {
                            String _initialMethodSignature = Helper.initialMethodSignature(m);
                            String pointcutString = "// #DispatchPointCut_before# " + _initialMethodSignature;
                            StringConcatenation _builder_6 = new StringConcatenation();
                            _builder_6.append(dispatchInjectCodeForParent);
                            _builder_6.newLineIfNotEmpty();
                            _builder_6.append("// ");
                            _builder_6.append(DISPATCH_POINTCUT_KEY);
                            _builder_6.append(" ");
                            String _methodSignature_2 = Helper.methodSignature(m);
                            _builder_6.append(_methodSignature_2);
                            String pointcutReplacement = _builder_6.toString();
                            String newContent = aspectJavaFileContent.replace(pointcutString, pointcutReplacement);
                            context.setContents(superclassjavafile, (CharSequence)newContent);
                            int timeout = 40;
                            do {
                                Thread.sleep(100L);
                            } while (!Objects.equal((Object)context.getContents(superclassjavafile).toString(), (Object)newContent) && --timeout > 0);
                        }
                    }
                }
            }
            this.projectStaticDispatchBuilder.cleanDeprecatedDispatchFiles(classDecl.getCompilationUnit(), context);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private boolean waitForFileContent(Path file, @Extension CodeGenerationContext context) {
        try {
            int timeout = 20;
            String _path = context.toURI(file).getPath();
            File f = new File(_path);
            while (!f.exists() && timeout > 0) {
                Thread.sleep(100L);
                --timeout;
            }
            timeout = 20;
            while (f.length() == 0L && timeout > 0) {
                Thread.sleep(100L);
                --timeout;
            }
            return timeout != 0;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String readFileContents(Path file, @Extension CodeGenerationContext context) {
        try {
            String _path = context.toURI(file).getPath();
            FileReader _fileReader = new FileReader(_path);
            BufferedReader br = new BufferedReader(_fileReader);
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            return sb.toString();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

