/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.listeners;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.utils.TreeColumnWidthSetter;
import org.eclipse.sirius.ui.tools.internal.editor.ChangeExpandeStateRunnable;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class DLineExpansionChecker
implements Listener {
    private DTable dTable;
    private DTableViewerManager dTableViewerManager;
    private IPermissionAuthority permissionAuthority;
    private Control control;

    public DLineExpansionChecker(Control control, DTableViewerManager dTableViewerManager, IPermissionAuthority permissionAuthority) {
        this.control = control;
        this.dTableViewerManager = dTableViewerManager;
        this.permissionAuthority = permissionAuthority;
        control.getDisplay().addFilter(17, (Listener)this);
        control.getDisplay().addFilter(18, (Listener)this);
        control.getDisplay().addFilter(11, (Listener)this);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 18: {
                this.handleTreeCollapse(event);
                break;
            }
            case 17: {
                this.handleTreeExpand(event);
                break;
            }
            case 11: {
                this.handleTreeColumnWidthResize(event);
                break;
            }
        }
    }

    private void handleTreeCollapse(Event event) {
        if (!this.isEventForDLineExpandable(event)) {
            event.type = 0;
            TreeItem treeItem = (TreeItem)event.item;
            Display.getDefault().asyncExec((Runnable)new ChangeExpandeStateRunnable(treeItem, true));
        }
    }

    private void handleTreeExpand(Event event) {
        if (!this.isEventForDLineExpandable(event)) {
            event.type = 0;
            TreeItem treeItem = (TreeItem)event.item;
            Display.getDefault().asyncExec((Runnable)new ChangeExpandeStateRunnable(treeItem, false));
        }
    }

    private void handleTreeColumnWidthResize(Event event) {
        if (!this.isEventForHeaderColumnResizable(event) && event.widget instanceof TreeColumn && this.dTableViewerManager != null && this.dTableViewerManager.getEditor().isPropertiesUpdateEnabled()) {
            event.type = 0;
            TreeColumn treeColumn = (TreeColumn)event.widget;
            Object data = treeColumn.getData("org.eclipse.sirius.table.ui.dTableColumn");
            int modelWidth = -1;
            if (data == null) {
                modelWidth = this.dTable.getHeaderColumnWidth();
            } else if (data instanceof DColumn) {
                DColumn dColumn = (DColumn)data;
                modelWidth = dColumn.getWidth();
            }
            if (treeColumn.getWidth() != modelWidth) {
                TreeColumnWidthSetter treeColumnWidthSetter = new TreeColumnWidthSetter(treeColumn, modelWidth);
                Display.getDefault().asyncExec((Runnable)treeColumnWidthSetter);
            }
        }
    }

    private boolean isEventForDLineExpandable(Event event) {
        TreeItem treeItem;
        Object data;
        boolean isEventForDLineExpandable = true;
        if (event.item instanceof TreeItem && (data = (treeItem = (TreeItem)event.item).getData()) instanceof DLine) {
            boolean canEditFeature;
            DLine dLine = (DLine)data;
            isEventForDLineExpandable = canEditFeature = this.permissionAuthority != null && this.permissionAuthority.canEditFeature((EObject)dLine, TablePackage.Literals.DLINE__COLLAPSED.getName());
        }
        return isEventForDLineExpandable;
    }

    private boolean isEventForHeaderColumnResizable(Event event) {
        boolean isEventForHeaderColumnResizable = true;
        if (event.widget instanceof TreeColumn) {
            TreeColumn treeColumn = (TreeColumn)event.widget;
            Object data = treeColumn.getData("org.eclipse.sirius.table.ui.dTableColumn");
            if (data == null) {
                boolean canEditFeature;
                isEventForHeaderColumnResizable = canEditFeature = this.permissionAuthority != null && this.permissionAuthority.canEditFeature((EObject)this.dTable, TablePackage.Literals.DTABLE__HEADER_COLUMN_WIDTH.getName());
            } else if (data instanceof DColumn) {
                boolean canEditFeature;
                DColumn dColumn = (DColumn)data;
                isEventForHeaderColumnResizable = canEditFeature = this.permissionAuthority != null && this.permissionAuthority.canEditFeature((EObject)dColumn, TablePackage.Literals.DCOLUMN__WIDTH.getName());
            }
        }
        return isEventForHeaderColumnResizable;
    }

    public void dispose() {
        this.control.getDisplay().removeFilter(17, (Listener)this);
        this.control.getDisplay().removeFilter(18, (Listener)this);
        this.control.getDisplay().removeFilter(11, (Listener)this);
        this.dTable = null;
        this.dTableViewerManager = null;
        this.permissionAuthority = null;
        this.control = null;
    }
}

