/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootManager {
    static final IPath PROJECT_RELATIVE_PATH_TO_CONFIG_FILE = new Path(".xpand-root");
    private final IFile myConfig;
    private List<RootDescription> myRoots;
    private List<IRootChangeListener> myListeners = new ArrayList<IRootChangeListener>(2);
    private static final List<IPath> DEFAULT_ROOTS = Collections.singletonList(new Path("templates"));

    public RootManager(IProject project) {
        this.myConfig = project.getFile(PROJECT_RELATIVE_PATH_TO_CONFIG_FILE);
    }

    public void addRootChangeListener(IRootChangeListener l) {
        if (l != null && !this.myListeners.contains(l)) {
            this.myListeners.add(l);
        }
    }

    public void removeRootChangeListener(IRootChangeListener l) {
        this.myListeners.remove(l);
    }

    void rootsChanged() {
        this.myRoots = null;
        for (IRootChangeListener next : this.myListeners) {
            next.rootsChanged(this);
        }
    }

    protected IProject getProject() {
        return this.myConfig.getProject();
    }

    public RootDescription getRootDescription(IFile file) {
        for (RootDescription nextDescription : this.getRoots()) {
            if (!nextDescription.contains((IResource)file)) continue;
            return nextDescription;
        }
        return null;
    }

    public List<RootDescription> getRoots() {
        if (this.myRoots == null) {
            this.reloadRoots();
        }
        return this.myRoots;
    }

    /*
     * Unable to fully structure code
     */
    private void reloadRoots() {
        block21: {
            if (!this.myConfig.exists()) {
                this.myRoots = Collections.singletonList(new RootDescription(RootManager.DEFAULT_ROOTS));
                return;
            }
            read = new ArrayList<RootDescription>();
            in = null;
            try {
                in = new BufferedReader(new InputStreamReader(this.myConfig.getContents(), this.myConfig.getCharset()));
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                    split = line.split(",");
                    nextPaths = new ArrayList<IPath>(split.length);
                    var9_9 = split;
                    var8_8 = split.length;
                    var7_7 = 0;
                    while (var7_7 < var8_8) {
                        nextPath = var9_9[var7_7];
                        if (!((nextPath = nextPath.trim()).length() <= 0 || (toAdd = new Path(nextPath)).isAbsolute() && toAdd.segmentCount() < 2)) {
                            nextPaths.add((IPath)toAdd);
                        }
                        ++var7_7;
                    }
                    read.add(new RootDescription(nextPaths));
                }
            }
            catch (CoreException v0) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException v1) {}
                }
                break block21;
            }
            catch (IOException v2) {
                try {
                    ** if (in == null) goto lbl-1000
                }
                catch (Throwable var11_11) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException v4) {}
                    }
                    throw var11_11;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        in.close();
                    }
                    catch (IOException v3) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block21;
                }
            }
            if (in == null) break block21;
            try {
                in.close();
            }
            catch (IOException v5) {}
        }
        this.myRoots = read;
    }

    public Set<IProject> getReferencedProjects() {
        LinkedHashSet<IProject> result = new LinkedHashSet<IProject>();
        for (RootDescription nextDescription : this.getRoots()) {
            result.addAll(nextDescription.getReferencedProjects());
        }
        return result;
    }

    boolean containsProject(IPath projectPath) {
        if (this.myRoots == null) {
            return false;
        }
        for (RootDescription nextRoots : this.myRoots) {
            for (IPath next : nextRoots.getRoots()) {
                if (!next.isAbsolute() || !projectPath.isPrefixOf(next)) continue;
                return true;
            }
        }
        return false;
    }

    public static interface IRootChangeListener {
        public void rootsChanged(RootManager var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RootDescription {
        private final List<IPath> myRoots;
        private Set<IProject> myReferencedProjects;

        public RootDescription(List<IPath> roots) {
            this.myRoots = roots;
        }

        public Set<IProject> getReferencedProjects() {
            if (this.myReferencedProjects == null) {
                this.myReferencedProjects = new LinkedHashSet<IProject>();
                for (IPath next : this.getRoots()) {
                    IProject candidate;
                    if (!next.isAbsolute() || next.segmentCount() <= 1 || !(candidate = ResourcesPlugin.getWorkspace().getRoot().getProject(next.segment(0))).isAccessible()) continue;
                    this.myReferencedProjects.add(candidate);
                }
            }
            return this.myReferencedProjects;
        }

        public List<IPath> getRoots() {
            return this.myRoots;
        }

        public boolean contains(IResource resource) {
            if (resource == null) {
                return false;
            }
            for (IPath nextRoot : this.myRoots) {
                if (!(nextRoot.isAbsolute() ? nextRoot.isPrefixOf(resource.getFullPath()) : resource.getProject().equals((Object)RootManager.this.getProject()) && nextRoot.isPrefixOf(resource.getProjectRelativePath()))) continue;
                return true;
            }
            return false;
        }
    }
}

