/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalComputer;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalFactory;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandProposalComputer
implements ProposalComputer {
    private static final Pattern p1 = Pattern.compile("DEFINE\\s+([\\w]+)");
    private static final Pattern p2 = Pattern.compile("EXPAND\\s+([\\w]*)\\z");
    private final ProposalFactory proposalFactory;
    private final String fullText;

    public ExpandProposalComputer(String fullText, ProposalFactory factory) {
        assert (factory != null);
        this.proposalFactory = factory;
        this.fullText = fullText;
    }

    @Override
    public List<ICompletionProposal> computeProposals(String txtToPoint, ExecutionContext ctx) {
        Matcher m2 = p2.matcher(txtToPoint);
        String prefix = m2.find() ? m2.group(1) : "";
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        Matcher m = p1.matcher(this.fullText);
        while (m.find()) {
            String templateName = m.group(1).trim();
            if (!templateName.startsWith(prefix)) continue;
            result.add(this.proposalFactory.createStatementProposal(templateName, templateName, prefix));
        }
        return result;
    }
}

