/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooldef;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ActionKind implements Enumerator
{
    CREATE_LITERAL(0, "CREATE", "CREATE"),
    PROPCHANGE_LITERAL(1, "PROPCHANGE", "PROPCHANGE"),
    MODIFY_LITERAL(2, "MODIFY", "MODIFY"),
    PROCESS_LITERAL(3, "PROCESS", "PROCESS"),
    CUSTOM_LITERAL(99, "CUSTOM", "CUSTOM");

    public static final int CREATE = 0;
    public static final int PROPCHANGE = 1;
    public static final int MODIFY = 2;
    public static final int PROCESS = 3;
    public static final int CUSTOM = 99;
    private static final ActionKind[] VALUES_ARRAY;
    public static final List<ActionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ActionKind[]{CREATE_LITERAL, PROPCHANGE_LITERAL, MODIFY_LITERAL, PROCESS_LITERAL, CUSTOM_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ActionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActionKind get(int value) {
        switch (value) {
            case 0: {
                return CREATE_LITERAL;
            }
            case 1: {
                return PROPCHANGE_LITERAL;
            }
            case 2: {
                return MODIFY_LITERAL;
            }
            case 3: {
                return PROCESS_LITERAL;
            }
            case 99: {
                return CUSTOM_LITERAL;
            }
        }
        return null;
    }

    private ActionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

