/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.runtime.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.LogHelper;
import org.eclipse.gmf.tooling.runtime.part.DefaultElementChooserDialog;
import org.eclipse.gmf.tooling.runtime.part.LastClickPositionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultCreateShortcutHandler
extends AbstractHandler {
    private final LogHelper myLogHelper;
    private final PreferencesHint myPreferencesHint;

    public DefaultCreateShortcutHandler(LogHelper logHelper, PreferencesHint preferencesHint) {
        this.myLogHelper = logHelper;
        this.myPreferencesHint = preferencesHint;
    }

    public abstract ICommand createShortcutDecorationCommand(View var1, TransactionalEditingDomain var2, List<CreateViewRequest.ViewDescriptor> var3);

    public abstract DefaultElementChooserDialog createChooserDialog(Shell var1, View var2);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart diagramEditor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        Shell shell = diagramEditor.getEditorSite().getShell();
        assert (diagramEditor instanceof DiagramEditor);
        TransactionalEditingDomain editingDomain = ((DiagramEditor)diagramEditor).getEditingDomain();
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        assert (selection instanceof IStructuredSelection);
        assert (((IStructuredSelection)selection).size() == 1);
        assert (((IStructuredSelection)selection).getFirstElement() instanceof EditPart);
        EditPart selectedDiagramPart = (EditPart)((IStructuredSelection)selection).getFirstElement();
        View view = (View)selectedDiagramPart.getModel();
        Point d2dCursorBeforeDialog = this.getLastClickPosition(shell, event);
        DefaultElementChooserDialog chooserDialog = this.createChooserDialog(shell, view);
        int result = chooserDialog.open();
        if (result != 0) {
            return null;
        }
        List<EObject> allSelectedObjects = this.getEObjectsByURI(chooserDialog.getSelectedModelElementURIs(), editingDomain);
        if (allSelectedObjects.isEmpty()) {
            return null;
        }
        DropObjectsRequest request = this.createDragDropRequest(allSelectedObjects, d2dCursorBeforeDialog);
        Command gefCommand = selectedDiagramPart.getCommand((Request)request);
        Object iCommand = gefCommand != null && gefCommand.canExecute() ? new CommandProxy(gefCommand) : this.createCompositeCommand(allSelectedObjects, view, editingDomain);
        if (iCommand != null) {
            try {
                OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)iCommand, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                this.myLogHelper.logError("Unable to create shortcut", e);
                throw e;
            }
        }
        return null;
    }

    private List<EObject> getEObjectsByURI(List<URI> selectedModelElementURIs, TransactionalEditingDomain editingDomain) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (URI nextURI : selectedModelElementURIs) {
            try {
                EObject next = editingDomain.getResourceSet().getEObject(nextURI, true);
                if (next == null) continue;
                result.add(next);
            }
            catch (WrappedException e) {
                this.myLogHelper.logError("Exception while loading object: " + nextURI.toString(), e);
            }
        }
        return result;
    }

    private CompositeTransactionalCommand createCompositeCommand(List<EObject> allSelectedObjects, View view, TransactionalEditingDomain editingDomain) {
        CompositeTransactionalCommand result = new CompositeTransactionalCommand(editingDomain, "Add Shortcuts");
        ArrayList<CreateViewRequest.ViewDescriptor> goodDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>(allSelectedObjects.size());
        for (EObject next : allSelectedObjects) {
            CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(next), Node.class, null, this.myPreferencesHint);
            CreateCommand createCommand = new CreateCommand(editingDomain, viewDescriptor, view);
            if (!createCommand.canExecute()) continue;
            result.add((IUndoableOperation)createCommand);
            goodDescriptors.add(viewDescriptor);
        }
        if (result.isEmpty()) {
            return null;
        }
        ICommand addDecoration = this.createShortcutDecorationCommand(view, editingDomain, goodDescriptors);
        if (addDecoration != null) {
            result.add((IUndoableOperation)addDecoration);
        }
        return result;
    }

    private DropObjectsRequest createDragDropRequest(List<EObject> allSelectedObjects, Point d2dCursorBeforeDialog) {
        DropObjectsRequest req = new DropObjectsRequest();
        req.setObjects(allSelectedObjects);
        req.setAllowedDetail(1);
        req.setRequiredDetail(1);
        req.setLocation(d2dCursorBeforeDialog);
        return req;
    }

    private Point getLastClickPosition(Shell shell, ExecutionEvent event) {
        Point fromSourceProvider = (Point)HandlerUtil.getVariable((ExecutionEvent)event, (String)LastClickPositionProvider.SOURCE_LAST_CLICK);
        if (fromSourceProvider != null) {
            return fromSourceProvider;
        }
        return new Point(0, 0);
    }
}

